/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_graphic.Frame;
import pkg_graphic.ImagePanel;
import pkg_graphic.Menubar;
import pkg_ixe.Ixe;
import pkg_ixe.IxeConst;
import pkg_ixe.IxeDialog;

public class Window
extends Frame {
    private byte[][][] data;
    private BufferedImage image_a = null;
    private BufferedImage image_b = null;
    protected ImagePanel image_panel = new ImagePanel();
    private boolean[] channels = new boolean[4];
    private boolean color_mode;
    private int rotation;
    private boolean flip_v;
    private boolean flip_h;
    private JButton[] nav_btn = new JButton[4];
    private JButton[] lossless_transform_btn = new JButton[4];
    private JButton[] fix_btn = new JButton[3];
    private JScrollPane scroller;
    private boolean inverted;
    private JTextArea file_info = new JTextArea();
    private JSlider zoom = new JSlider();
    private boolean update_image = false;
    private Menubar menu;

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.menu = new Menubar(this);
        this.setJMenuBar(this.menu);
        this.scroller = new JScrollPane(this.image_panel);
        this.scroller.setHorizontalScrollBarPolicy(30);
        this.scroller.setVerticalScrollBarPolicy(20);
        this.file_info.setLineWrap(true);
        this.file_info.setWrapStyleWord(false);
        this.file_info.setOpaque(false);
        this.file_info.setEditable(false);
        this.file_info.setFocusable(false);
        this.file_info.setBackground(UIManager.getColor("Label.background"));
        this.file_info.setFont(UIManager.getFont("Label.font"));
        this.file_info.setBorder(UIManager.getBorder("Label.border"));
        this.add((Component)this.scroller, "Center");
        this.build_navigation();
        this.update_nav_buttons();
        this.reset_image();
        this.fullscreen();
        this.setVisible(true);
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    private void build_navigation() {
        int i;
        JPanel pnl_south = new JPanel(new GridLayout(1, 3));
        JPanel pnl_mid = new JPanel(new GridLayout(2, 4));
        Font font = new Font(UIManager.getFont("Label.font").getFontName(), 0, 36);
        this.lossless_transform_btn[0] = new JButton("\u2ba6");
        this.lossless_transform_btn[1] = new JButton("\u2ba7");
        this.lossless_transform_btn[2] = new JButton("\u2b64");
        this.lossless_transform_btn[3] = new JButton("\u2b65");
        for (i = 0; i < this.lossless_transform_btn.length; ++i) {
            this.lossless_transform_btn[i].setMargin(new Insets(0, 0, 0, 0));
            this.lossless_transform_btn[i].setFont(font);
            pnl_mid.add(this.lossless_transform_btn[i]);
        }
        this.lossless_transform_btn[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.rotation((Window.this.rotation + 1) % 4);
            }
        });
        this.lossless_transform_btn[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.rotation((Window.this.rotation + 3) % 4);
            }
        });
        this.lossless_transform_btn[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.flip(false);
                if (Window.this.rotation % 2 == 1) {
                    Window.this.flip_h = !Window.this.flip_h;
                } else {
                    Window.this.flip_v = !Window.this.flip_v;
                }
            }
        });
        this.lossless_transform_btn[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.flip(true);
                if (Window.this.rotation % 2 == 1) {
                    Window.this.flip_v = !Window.this.flip_v;
                } else {
                    Window.this.flip_h = !Window.this.flip_h;
                }
            }
        });
        this.nav_btn[0] = new JButton("\u21e4");
        this.nav_btn[1] = new JButton("\u2190");
        this.nav_btn[2] = new JButton("\u2192");
        this.nav_btn[3] = new JButton("\u21e5");
        for (i = 0; i < this.nav_btn.length; ++i) {
            final int type = i;
            this.nav_btn[i].setMargin(new Insets(0, 0, 0, 0));
            this.nav_btn[i].setFont(font);
            this.nav_btn[i].addActionListener(new ActionListener(){
                final /* synthetic */ Window this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.move_file(type);
                    this.this$0.update_nav_buttons();
                }
            });
            pnl_mid.add(this.nav_btn[i]);
        }
        JScrollPane scroller = new JScrollPane(this.file_info);
        scroller.setVerticalScrollBarPolicy(21);
        scroller.setHorizontalScrollBarPolicy(30);
        JPanel panel_right = new JPanel(new GridLayout(2, 1));
        JPanel panel_fix_buttons = new JPanel(new GridLayout(1, 6));
        panel_fix_buttons.add(new JLabel());
        panel_fix_buttons.add(new JLabel());
        panel_fix_buttons.add(new JLabel());
        this.fix_btn[0] = new JButton("!");
        this.fix_btn[1] = new JButton("?");
        this.fix_btn[2] = new JButton("\u2020");
        this.fix_btn[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.clear_image();
            }
        });
        this.fix_btn[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.random_image();
            }
        });
        this.fix_btn[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.reset_image();
            }
        });
        for (int i2 = 0; i2 < this.fix_btn.length; ++i2) {
            this.fix_btn[i2].setMargin(new Insets(0, 0, 0, 0));
            this.fix_btn[i2].setFont(font);
            panel_fix_buttons.add(this.fix_btn[i2]);
        }
        panel_right.add(this.build_zoom_slider());
        panel_right.add(panel_fix_buttons);
        pnl_south.add(scroller);
        pnl_south.add(pnl_mid);
        pnl_south.add(panel_right);
        this.add((Component)pnl_south, "South");
    }

    private JSlider build_zoom_slider() {
        this.zoom.setMajorTickSpacing(25);
        this.zoom.setMinorTickSpacing(5);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(0, new JLabel("\u2a2f\u00bc"));
        labels.put(25, new JLabel("\u2a2f\u00bd"));
        labels.put(50, new JLabel("\u2a2f1"));
        labels.put(75, new JLabel("\u2a2f2"));
        labels.put(100, new JLabel("\u2a2f4"));
        this.zoom.setLabelTable(labels);
        this.zoom.setPaintLabels(true);
        this.zoom.setPaintTicks(true);
        this.zoom.setSnapToTicks(true);
        this.zoom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double scale = Window.this.zoom.getValue();
                scale = scale < 25.0 ? 0.25 + 0.25 * scale / 25.0 : (scale < 50.0 ? 0.5 + 0.5 * (scale - 25.0) / 25.0 : (scale < 75.0 ? 1.0 + 1.0 * (scale - 50.0) / 25.0 : 2.0 + 2.0 * (scale - 75.0) / 25.0));
                Window.this.image_panel.set_scale(scale);
                Window.this.image_panel.repaint();
            }
        });
        return this.zoom;
    }

    public void refresh_scoller() {
        this.scroller.revalidate();
        this.scroller.repaint();
    }

    private void update_nav_buttons() {
        int i;
        if (this.dir_index < 0 || this.dir_array == null) {
            for (i = 0; i < this.nav_btn.length; ++i) {
                this.nav_btn[i].setEnabled(false);
            }
        } else {
            this.nav_btn[0].setEnabled(this.dir_index != 0);
            this.nav_btn[1].setEnabled(this.dir_index != 0);
            this.nav_btn[2].setEnabled(this.dir_index != this.dir_array.length - 1);
            this.nav_btn[3].setEnabled(this.dir_index != this.dir_array.length - 1);
        }
        for (i = 0; i < this.lossless_transform_btn.length; ++i) {
            this.lossless_transform_btn[i].setEnabled(this.image_a != null);
        }
        for (i = 0; i < this.fix_btn.length; ++i) {
            this.fix_btn[i].setEnabled(this.image_a != null);
        }
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        if (this.update_image) {
            this.update_image();
        }
        this.refresh_scoller();
    }

    public void set_channels(boolean a, boolean r, boolean g, boolean b) {
        if (this.channels[0] != a || this.channels[1] != r || this.channels[2] != g || this.channels[3] != b) {
            this.channels[0] = a;
            this.channels[1] = r;
            this.channels[2] = g;
            this.channels[3] = b;
            this.update_image = true;
        }
    }

    private void rotation(int rotation) {
        this.rotation = rotation;
        this.image_panel.set_rotation(rotation % 2 == 1);
        this.update_image = true;
    }

    private void flip(boolean horizontal) {
        if (this.rotation % 2 == 1) {
            boolean bl = horizontal = !horizontal;
        }
        if (horizontal) {
            for (int i = 0; i < this.data[0].length; ++i) {
                for (int j = 0; j < this.data[0][0].length / 2; ++j) {
                    for (int k = 0; k < this.data.length; ++k) {
                        byte swap = this.data[k][i][j];
                        this.data[k][i][j] = this.data[k][i][this.data[0][0].length - j - 1];
                        this.data[k][i][this.data[0][0].length - j - 1] = swap;
                    }
                }
            }
        } else {
            for (int j = 0; j < this.data[0][0].length; ++j) {
                for (int i = 0; i < this.data[0].length / 2; ++i) {
                    for (int k = 0; k < this.data.length; ++k) {
                        byte swap = this.data[k][i][j];
                        this.data[k][i][j] = this.data[k][this.data[0].length - i - 1][j];
                        this.data[k][this.data[0].length - i - 1][j] = swap;
                    }
                }
            }
        }
        this.update_image = true;
    }

    public void update_image() {
        this.update_image = false;
        if (this.data != null) {
            for (int i = 0; i < this.data[0].length; ++i) {
                for (int j = 0; j < this.data[0][0].length; ++j) {
                    int blue;
                    int alpha = this.channels[0] ? this.data[3][i][j] + 128 << 24 & 0xFF000000 : -16777216;
                    int red = this.channels[1] ? this.data[0][i][j] + 128 : 0;
                    int green = this.channels[2] ? this.data[1][i][j] + 128 : 0;
                    int n = blue = this.channels[3] ? this.data[2][i][j] + 128 : 0;
                    if (this.inverted) {
                        red = 255 - red;
                        green = 255 - green;
                        blue = 255 - blue;
                    }
                    if (this.color_mode) {
                        int grey;
                        red = grey = (red + green + blue) / 3;
                        green = grey;
                        blue = grey;
                    }
                    red = red << 16 & 0xFF0000;
                    green = green << 8 & 0xFF00;
                    blue = blue << 4 & 0xFF;
                    int x = i;
                    int y = j;
                    BufferedImage image = this.rotation % 2 == 1 ? this.image_b : this.image_a;
                    switch (this.rotation) {
                        case 1: {
                            x = j;
                            y = this.data[0].length - i - 1;
                            break;
                        }
                        case 2: {
                            x = this.data[0].length - i - 1;
                            y = this.data[0][0].length - j - 1;
                            break;
                        }
                        case 3: {
                            x = this.data[0][0].length - j - 1;
                            y = i;
                        }
                    }
                    image.setRGB(x, y, alpha | red | green | blue);
                }
            }
        }
        this.image_panel.revalidate();
        this.image_panel.repaint();
    }

    public void replace_image(File file) throws Exception {
        this.image_a = ImageIO.read(file);
        this.image_b = new BufferedImage(this.image_a.getHeight(), this.image_a.getWidth(), this.image_a.getType());
        this.data = new byte[4][this.image_a.getWidth()][this.image_a.getHeight()];
        for (int i = 0; i < this.data[0].length; ++i) {
            for (int j = 0; j < this.data[0][0].length; ++j) {
                int rgb = this.image_a.getRGB(i, j);
                this.data[0][i][j] = (byte)((rgb >> 16 & 0xFF) - 128);
                this.data[1][i][j] = (byte)((rgb >> 8 & 0xFF) - 128);
                this.data[2][i][j] = (byte)((rgb >> 0 & 0xFF) - 128);
                this.data[3][i][j] = (byte)((rgb >> 24 & 0xFF) - 128);
            }
        }
        if (this.flip_v) {
            this.flip(false);
        }
        if (this.flip_h) {
            this.flip(true);
        }
        this.update_info(file);
        this.update_nav_buttons();
        this.update_image();
        this.image_panel.link(this.image_a, this.image_b);
    }

    private void update_info(File file) throws IOException {
        String info = file.getAbsolutePath() + "\n" + Ixe.rax(this.image_a.getWidth()) + " \u2022 " + Ixe.rax(this.image_a.getHeight()) + " \u205a " + Ixe.rax((long)this.image_a.getWidth() * (long)this.image_a.getHeight()) + " (pixels)";
        BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        info = info + "\n" + Ixe.rax(attr.size()) + " (bytes)";
        this.file_info.setText(info);
    }

    public void set_mode(boolean color_mode) {
        if (this.color_mode != color_mode) {
            this.color_mode = color_mode;
            this.update_image = true;
        }
    }

    public void send_to_physical_printer() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.image_panel);
        boolean accept = job.printDialog();
        if (accept) {
            try {
                job.print();
            }
            catch (Exception e) {
                IxeDialog.error("Printer error");
            }
        }
    }

    public void set_invert(boolean inverted) {
        this.inverted = inverted;
        this.update_image = true;
    }

    private void clear_image() {
        this.image_a = null;
        this.image_b = null;
        this.data = null;
        this.dir_index = -1;
        this.image_panel.link(null, null);
        this.update_nav_buttons();
        this.file_info.setText("");
        this.menu.set(true, true, true, true, false, false);
        this.update_image = true;
    }

    private void random_image() {
        this.color_mode = IxeConst.ixe_RANDOM.nextBoolean();
        this.inverted = IxeConst.ixe_RANDOM.nextBoolean();
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = IxeConst.ixe_RANDOM.nextBoolean();
        }
        if (IxeConst.ixe_RANDOM.nextBoolean()) {
            this.flip(false);
            if (this.rotation % 2 == 1) {
                this.flip_h = !this.flip_h;
            } else {
                boolean bl = this.flip_v = !this.flip_v;
            }
        }
        if (IxeConst.ixe_RANDOM.nextBoolean()) {
            this.flip(true);
            if (this.rotation % 2 == 1) {
                this.flip_v = !this.flip_v;
            } else {
                this.flip_h = !this.flip_h;
            }
        }
        this.rotation(IxeConst.ixe_RANDOM.nextInt(4));
        this.menu.set(this.channels[0], this.channels[1], this.channels[2], this.channels[3], this.color_mode, this.inverted);
        this.update_image = true;
    }

    private void reset_image() {
        this.rotation(0);
        this.color_mode = false;
        this.inverted = false;
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = true;
        }
        if (this.flip_v) {
            this.flip(false);
        }
        if (this.flip_h) {
            this.flip(true);
        }
        this.flip_v = false;
        this.flip_h = false;
        this.zoom.setValue(50);
        this.menu.set(true, true, true, true, false, false);
        this.update_image = true;
    }
}

