/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import pkg_core.HardInfo;
import pkg_graphic.Frame;
import pkg_graphic.Window;

public class Menubar
extends JMenuBar {
    private Frame frame;
    private JCheckBoxMenuItem mi_image_channels_red;
    private JCheckBoxMenuItem mi_image_channels_green;
    private JCheckBoxMenuItem mi_image_channels_blue;
    private JCheckBoxMenuItem mi_image_channels_alpha;
    private JRadioButtonMenuItem mi_image_mode_rgba;
    private JRadioButtonMenuItem mi_image_mode_grey;
    private JCheckBoxMenuItem mi_image_invert;
    private boolean reset_override = false;

    public Menubar(Frame frame) {
        this.frame = frame;
        this.gen_file_menu();
        this.gen_window_menu();
        this.gen_navigation_menu();
        this.gen_image_menu();
        this.build_version_label();
    }

    private void gen_file_menu() {
        JMenu m_file = new JMenu("File");
        JMenuItem mi_file_open = new JMenuItem("Open...");
        JMenuItem mi_file_export = new JMenuItem("Export as .png file...");
        JMenuItem mi_file_print = new JMenuItem("Print...");
        JMenuItem mi_file_exit = new JMenuItem("Exit program");
        mi_file_open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.open_file();
            }
        });
        mi_file_export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.export_image();
            }
        });
        mi_file_print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)Menubar.this.frame).send_to_physical_printer();
            }
        });
        mi_file_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Menubar)Menubar.this).frame.request_close = true;
            }
        });
        mi_file_open.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        mi_file_export.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        mi_file_print.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        mi_file_exit.setAccelerator(KeyStroke.getKeyStroke(27, 128));
        m_file.add(mi_file_open);
        m_file.add(mi_file_export);
        m_file.add(mi_file_print);
        m_file.addSeparator();
        m_file.add(mi_file_exit);
        this.add(m_file);
    }

    private void gen_window_menu() {
        JMenu menu = new JMenu("Window");
        final JCheckBoxMenuItem mi_fullscreen = new JCheckBoxMenuItem("Fullscreen");
        mi_fullscreen.setSelected(HardInfo.FULLSCREEN);
        mi_fullscreen.addActionListener(new ActionListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HardInfo.FULLSCREEN = mi_fullscreen.getState();
                ((Menubar)this.this$0).frame.request_fullscreen = true;
            }
        });
        mi_fullscreen.setAccelerator(KeyStroke.getKeyStroke(122, 128));
        menu.add(mi_fullscreen);
        this.add(menu);
    }

    private void gen_navigation_menu() {
        JMenu m_nav = new JMenu("Navigation");
        JMenuItem mi_nav_first = new JMenuItem("First");
        JMenuItem mi_nav_previous = new JMenuItem("Previous");
        JMenuItem mi_nav_next = new JMenuItem("Next");
        JMenuItem mi_nav_last = new JMenuItem("Last");
        mi_nav_first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.move_file(0);
            }
        });
        mi_nav_previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.move_file(1);
            }
        });
        mi_nav_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.move_file(2);
            }
        });
        mi_nav_last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.move_file(3);
            }
        });
        mi_nav_first.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        mi_nav_previous.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        mi_nav_next.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        mi_nav_last.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        m_nav.add(mi_nav_first);
        m_nav.add(mi_nav_previous);
        m_nav.add(mi_nav_next);
        m_nav.add(mi_nav_last);
        this.add(m_nav);
    }

    private void gen_image_menu() {
        JMenu m_file = new JMenu("Image");
        JMenu mi_image_channels = new JMenu("Enabled");
        this.mi_image_channels_red = new JCheckBoxMenuItem("Red");
        this.mi_image_channels_green = new JCheckBoxMenuItem("Green");
        this.mi_image_channels_blue = new JCheckBoxMenuItem("Blue");
        this.mi_image_channels_alpha = new JCheckBoxMenuItem("Alpha");
        this.mi_image_channels_red.setSelected(true);
        this.mi_image_channels_green.setSelected(true);
        this.mi_image_channels_blue.setSelected(true);
        this.mi_image_channels_alpha.setSelected(true);
        ActionListener action_mi_image_channels = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Menubar.this.reset_override) {
                    ((Window)Menubar.this.frame).set_channels(Menubar.this.mi_image_channels_alpha.isSelected(), Menubar.this.mi_image_channels_red.isSelected(), Menubar.this.mi_image_channels_green.isSelected(), Menubar.this.mi_image_channels_blue.isSelected());
                }
            }
        };
        this.mi_image_channels_red.addActionListener(action_mi_image_channels);
        this.mi_image_channels_green.addActionListener(action_mi_image_channels);
        this.mi_image_channels_blue.addActionListener(action_mi_image_channels);
        this.mi_image_channels_alpha.addActionListener(action_mi_image_channels);
        this.mi_image_channels_red.setAccelerator(KeyStroke.getKeyStroke(49, 128));
        this.mi_image_channels_green.setAccelerator(KeyStroke.getKeyStroke(50, 128));
        this.mi_image_channels_blue.setAccelerator(KeyStroke.getKeyStroke(51, 128));
        this.mi_image_channels_alpha.setAccelerator(KeyStroke.getKeyStroke(52, 128));
        mi_image_channels.add(this.mi_image_channels_red);
        mi_image_channels.add(this.mi_image_channels_green);
        mi_image_channels.add(this.mi_image_channels_blue);
        mi_image_channels.add(this.mi_image_channels_alpha);
        JMenu mi_image_mode = new JMenu("Mode");
        this.mi_image_mode_rgba = new JRadioButtonMenuItem("ARGB");
        this.mi_image_mode_grey = new JRadioButtonMenuItem("Greyscale");
        ButtonGroup mode_group = new ButtonGroup();
        mode_group.add(this.mi_image_mode_rgba);
        mode_group.add(this.mi_image_mode_grey);
        this.mi_image_mode_rgba.setSelected(true);
        ActionListener action_mi_image_mode = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Menubar.this.reset_override) {
                    ((Window)Menubar.this.frame).set_mode(Menubar.this.mi_image_mode_grey.isSelected());
                }
            }
        };
        this.mi_image_mode_rgba.addActionListener(action_mi_image_mode);
        this.mi_image_mode_grey.addActionListener(action_mi_image_mode);
        this.mi_image_mode_rgba.setAccelerator(KeyStroke.getKeyStroke(57, 128));
        this.mi_image_mode_grey.setAccelerator(KeyStroke.getKeyStroke(48, 128));
        mi_image_mode.add(this.mi_image_mode_rgba);
        mi_image_mode.add(this.mi_image_mode_grey);
        this.mi_image_invert = new JCheckBoxMenuItem("Inverted values");
        this.mi_image_invert.setAccelerator(KeyStroke.getKeyStroke(56, 128));
        this.mi_image_invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Menubar.this.reset_override) {
                    ((Window)Menubar.this.frame).set_invert(Menubar.this.mi_image_invert.isSelected());
                }
            }
        });
        m_file.add(mi_image_channels);
        m_file.add(mi_image_mode);
        m_file.add(this.mi_image_invert);
        this.add(m_file);
    }

    private void build_version_label() {
        this.add(Box.createHorizontalGlue());
        JLabel version_lbl = new JLabel("Version 1.1");
        version_lbl.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.add(version_lbl);
    }

    public void set(boolean red, boolean green, boolean blue, boolean alpha, boolean mode, boolean invert) {
        this.reset_override = true;
        this.mi_image_channels_red.setSelected(red);
        this.mi_image_channels_green.setSelected(green);
        this.mi_image_channels_blue.setSelected(blue);
        this.mi_image_channels_alpha.setSelected(alpha);
        this.mi_image_mode_rgba.setSelected(!mode);
        this.mi_image_mode_grey.setSelected(mode);
        this.mi_image_invert.setSelected(invert);
        this.reset_override = false;
    }
}

