/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

public class ImagePanel
extends JComponent
implements Printable {
    private BufferedImage image_a = null;
    private BufferedImage image_b = null;
    private boolean rotation = false;
    private double scale = 1.0;
    private Dimension dimension = new Dimension();

    public ImagePanel() {
        this.setPreferredSize(this.dimension);
    }

    public void link(BufferedImage image_a, BufferedImage image_b) {
        this.image_a = image_a;
        this.image_b = image_b;
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image;
        super.paintComponent(g);
        BufferedImage bufferedImage = image = this.rotation ? this.image_b : this.image_a;
        if (image != null) {
            double img_w = image.getWidth();
            double img_h = image.getHeight();
            double scaled_w = this.scale * img_w;
            double scaled_h = this.scale * img_h;
            this.dimension.width = (int)scaled_w;
            this.dimension.height = (int)scaled_h;
            double panel_w = this.getWidth();
            double panel_h = this.getHeight();
            double x = panel_w > scaled_w ? (panel_w - scaled_w) / 2.0 : 0.0;
            double y = panel_h > scaled_h ? (panel_h - scaled_h) / 2.0 : 0.0;
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(x, y);
            g2d.scale(this.scale, this.scale);
            g2d.drawImage((Image)image, 0, 0, null);
        } else {
            this.dimension.width = 0;
            this.dimension.height = 0;
        }
    }

    public void set_scale(double scale) {
        this.scale = scale;
    }

    public void set_rotation(boolean rotation) {
        this.rotation = rotation;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        BufferedImage image;
        if (page > 0) {
            return 1;
        }
        BufferedImage bufferedImage = image = this.rotation ? this.image_b : this.image_a;
        if (image != null) {
            double img_height;
            double scale;
            double page_width = pf.getImageableWidth();
            double page_height = pf.getImageableHeight();
            double c = 0.72;
            double img_width = c * (double)image.getWidth();
            if (img_width * (scale = page_height / (img_height = c * (double)image.getHeight())) > page_width) {
                scale = page_width / img_width;
            }
            double off_x = (page_width - img_width * scale) / 2.0;
            double off_y = (page_height - img_height * scale) / 2.0;
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate((int)(pf.getImageableX() + off_x), (int)(pf.getImageableY() + off_y));
            g2d.scale(scale * c, scale * c);
            g2d.drawImage((Image)image, 0, 0, null);
        }
        return 0;
    }

    public BufferedImage get_image() {
        return this.rotation ? this.image_b : this.image_a;
    }
}

