/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import pkg_core.Screen;
import pkg_graphic.Window;
import pkg_ixe.Ixe;
import pkg_ixe.IxeDialog;

public abstract class Frame
extends JFrame {
    private static final JFileChooser fc = new JFileChooser();
    public boolean request_close = false;
    public boolean request_fullscreen = true;
    protected File[] dir_array = null;
    protected int dir_index = -1;
    private final FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String name = file.getName().toLowerCase();
            return name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg");
        }
    };

    public Frame(String title) {
        this.init_dialog();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame.this.request_close = true;
            }
        });
        this.setSize(Screen.w / 2, Screen.h / 2);
        this.setLocationRelativeTo(null);
        this.setTitle(title);
    }

    private void init_dialog() {
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new javax.swing.filechooser.FileFilter(){

            @Override
            public String getDescription() {
                return ".jpg and .png images";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".png");
            }
        });
    }

    public void open_file() {
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                File parent = file.getParentFile();
                if (parent == null) {
                    this.dir_array = new File[]{file};
                } else {
                    this.dir_array = parent.listFiles(this.ff);
                    for (int i = 0; i < this.dir_array.length; ++i) {
                        if (!this.dir_array[i].equals(file)) continue;
                        this.dir_index = i;
                        break;
                    }
                }
                ((Window)this).replace_image(file);
            }
            catch (Exception e) {
                IxeDialog.error("Cannot load " + file + "\n" + e.getMessage());
            }
        }
    }

    public void move_file(int type) {
        if (this.dir_array == null || this.dir_array.length == 1 || this.dir_index == 0 && (type == 0 || type == 1) || this.dir_index == this.dir_array.length - 1 && (type == 2 || type == 3)) {
            return;
        }
        this.dir_index = Ixe.clamp(this.dir_index, 0, this.dir_array.length - 1);
        switch (type) {
            case 0: {
                this.dir_index = 0;
                break;
            }
            case 1: {
                --this.dir_index;
                break;
            }
            case 2: {
                ++this.dir_index;
                break;
            }
            case 3: {
                this.dir_index = this.dir_array.length - 1;
            }
        }
        try {
            ((Window)this).replace_image(this.dir_array[this.dir_index]);
        }
        catch (Exception e) {
            IxeDialog.error("Cannot load " + this.dir_array[this.dir_index] + "\n" + e.getMessage());
        }
    }

    public abstract void update();

    public void export_image() {
        BufferedImage image = ((Window)this).image_panel.get_image();
        if (image == null) {
            IxeDialog.error("Image does not exist.");
            return;
        }
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String[] split = file.getName().split("\\.");
            if (!split[split.length - 1].equalsIgnoreCase("png")) {
                file = new File(file.getPath() + ".png");
            }
            try {
                ImageIO.write((RenderedImage)image, "png", file);
            }
            catch (Exception e) {
                IxeDialog.error("Cannot save " + file + "\n" + e.getMessage());
            }
        }
    }
}

