/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pkg_graphic.CountupColumn;
import pkg_graphic.TabContent;

public class CountupPanel
extends TabContent {
    int col_nb = 3;
    CountupColumn[] cols = new CountupColumn[this.col_nb];

    public CountupPanel() {
        super("Countup", "Track the time spent");
        this.setLayout(new BorderLayout());
        JPanel cols_panel = new JPanel(new BorderLayout());
        JPanel col_panel = new JPanel(new GridLayout(1, this.col_nb));
        JPanel col_analysis_panel = new JPanel(new GridLayout(1, this.col_nb));
        JPanel col_btn_panel = new JPanel(new GridLayout(1, this.col_nb));
        for (int i = 0; i < this.col_nb; ++i) {
            this.cols[i] = new CountupColumn();
            col_panel.add(this.cols[i]);
            this.cols[i].link(col_analysis_panel, col_btn_panel);
        }
        JScrollPane scroller = new JScrollPane(col_panel);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setHorizontalScrollBarPolicy(31);
        cols_panel.add((Component)col_analysis_panel, "North");
        cols_panel.add((Component)scroller, "Center");
        cols_panel.add((Component)col_btn_panel, "South");
        this.add((Component)cols_panel, "Center");
        JPanel btn_panel = new JPanel(new GridLayout(1, 4));
        JButton btn_start = new JButton("Start");
        JButton btn_stop = new JButton("Stop");
        JButton btn_lap = new JButton("Lap");
        JButton btn_reset = new JButton("Reset");
        btn_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long now = System.nanoTime();
                for (int i = 0; i < CountupPanel.this.col_nb; ++i) {
                    if (!CountupPanel.this.cols[i].apply_global()) continue;
                    CountupPanel.this.cols[i].start(true, now);
                }
            }
        });
        btn_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long now = System.nanoTime();
                for (int i = 0; i < CountupPanel.this.col_nb; ++i) {
                    if (!CountupPanel.this.cols[i].apply_global()) continue;
                    CountupPanel.this.cols[i].start(false, now);
                }
            }
        });
        btn_lap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long now = System.nanoTime();
                for (int i = 0; i < CountupPanel.this.col_nb; ++i) {
                    if (!CountupPanel.this.cols[i].apply_global()) continue;
                    CountupPanel.this.cols[i].lap(now);
                }
            }
        });
        btn_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < CountupPanel.this.col_nb; ++i) {
                    if (!CountupPanel.this.cols[i].apply_global()) continue;
                    CountupPanel.this.cols[i].reset();
                }
            }
        });
        btn_panel.add(btn_start);
        btn_panel.add(btn_stop);
        btn_panel.add(btn_lap);
        btn_panel.add(btn_reset);
        this.add((Component)btn_panel, "South");
    }

    @Override
    public void update() {
        long now = System.nanoTime();
        for (int i = 0; i < this.col_nb; ++i) {
            this.cols[i].update(now);
        }
    }
}

