/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pkg_ixe.IxeTime;

public class CountupColumn
extends JPanel {
    private boolean active = false;
    private JLabel lbl_min;
    private JLabel lbl_max;
    private JLabel lbl_avr;
    private JLabel lbl_cavr;
    private JButton btn_start;
    private JButton btn_lap;
    private JButton btn_reset;
    private JCheckBox box_selected = new JCheckBox();
    private JTextPane content = new JTextPane();
    private JLabel lbl_time = new JLabel("", 0);
    private long time;
    private String log = "";
    private long min;
    private long max;
    private long avr;
    private long cavr;
    private int log_nb;
    private long time_offset;
    private long span = 0L;

    public CountupColumn() {
        this.setLayout(new BorderLayout());
        this.lbl_min = new JLabel("", 0);
        this.lbl_max = new JLabel("", 0);
        this.lbl_avr = new JLabel("", 0);
        this.lbl_cavr = new JLabel("", 0);
        this.box_selected.setSelected(true);
        this.btn_start = new JButton("");
        this.btn_lap = new JButton("Lap");
        this.btn_reset = new JButton("Reset");
        this.btn_start.setMargin(new Insets(0, 0, 0, 0));
        this.btn_lap.setMargin(new Insets(0, 0, 0, 0));
        this.btn_reset.setMargin(new Insets(0, 0, 0, 0));
        this.btn_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountupColumn.this.start(!CountupColumn.this.active, System.nanoTime());
            }
        });
        this.btn_lap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountupColumn.this.lap(System.nanoTime());
            }
        });
        this.btn_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountupColumn.this.reset();
            }
        });
        StyledDocument doc = this.content.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        this.content.setEnabled(false);
        this.content.setDisabledTextColor(Color.BLACK);
        this.add((Component)this.content, "Center");
        this.reset();
    }

    public void start(boolean active, long now) {
        if (active != this.active) {
            this.active = active;
            if (active) {
                if (now < this.time) {
                    this.time_offset += 0x200000000L - this.time - 1L + now;
                }
                this.time = now;
            } else {
                this.time_offset += now - this.time;
                this.time = -1L;
                this.lbl_time.setText(IxeTime.str_nano(this.time_offset));
            }
            this.btn_start.setText(active ? "Stop" : "Start");
        }
    }

    public void reset() {
        this.time = -1L;
        this.min = -1L;
        this.max = 0L;
        this.avr = 0L;
        this.cavr = 0L;
        this.span = 0L;
        this.log_nb = 0;
        this.time_offset = 0L;
        this.lbl_min.setText("[MINIMUM]");
        this.lbl_max.setText("[MAXIMUM]");
        this.lbl_avr.setText("[AVERAGE]");
        this.lbl_cavr.setText("[C-AVERAGE]");
        this.active = false;
        this.btn_start.setText("Start");
        this.log = "";
        this.content.setText("");
        this.lbl_time.setText("");
    }

    public void lap(long now) {
        this.span = this.time_offset + (this.time < 0L ? 0L : now - this.time);
        this.update_analysis(true);
        this.log = this.log + IxeTime.str_nano(this.span) + "\n";
        this.content.setText(this.log);
        this.time_offset = 0L;
        if (this.active) {
            this.time = now;
        }
        this.lbl_time.setText(IxeTime.str_nano(0L));
    }

    public void update(long now) {
        this.span = this.time_offset + (this.time < 0L ? 0L : now - this.time);
        this.update_analysis(false);
        if (this.active) {
            this.lbl_time.setText(IxeTime.str_nano(this.span));
        }
    }

    private void update_analysis(boolean lap) {
        this.cavr = (this.avr * (long)this.log_nb + this.span) / (long)(this.log_nb + 1);
        if (lap) {
            if (this.span < this.min || this.min < 0L) {
                this.min = this.span;
            }
            if (this.span > this.max) {
                this.max = this.span;
            }
            this.avr = (this.avr * (long)this.log_nb + this.span) / (long)(this.log_nb + 1);
            ++this.log_nb;
        }
        if (this.active || lap) {
            this.lbl_min.setText(IxeTime.str_nano(this.span < this.min || this.min < 0L ? this.span : this.min));
            this.lbl_max.setText(IxeTime.str_nano(this.span > this.max ? this.span : this.max));
            this.lbl_avr.setText(IxeTime.str_nano(this.log_nb == 0 ? this.span : this.avr));
            this.lbl_cavr.setText(IxeTime.str_nano(this.cavr));
        }
    }

    public void link(JPanel panel_north, JPanel panel_south) {
        JPanel analysis_panel = new JPanel(new GridLayout(4, 1));
        analysis_panel.add(this.lbl_min);
        analysis_panel.add(this.lbl_max);
        analysis_panel.add(this.lbl_avr);
        analysis_panel.add(this.lbl_cavr);
        panel_north.add(analysis_panel);
        JPanel btn_panel = new JPanel(new GridLayout(2, 1));
        JPanel btn_sub_panel = new JPanel(new GridLayout(1, 4));
        btn_panel.add(this.lbl_time);
        btn_sub_panel.add(this.btn_start);
        btn_sub_panel.add(this.btn_lap);
        btn_sub_panel.add(this.btn_reset);
        btn_sub_panel.add(this.box_selected);
        btn_panel.add(btn_sub_panel);
        panel_south.add(btn_panel);
    }

    public boolean apply_global() {
        return this.box_selected.isSelected();
    }
}

