/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pkg_ixe.IxeTime;

public class CountdownColumn
extends JPanel {
    boolean active = false;
    JLabel lbl_period;
    boolean phase;
    JLabel lbl_phase;
    JLabel lbl_countdown;
    JButton btn_start;
    JCheckBox box_periodic = new JCheckBox();
    JButton btn_reset;
    long period;
    long time = 0L;
    long time_offset = 0L;

    public CountdownColumn(long period) {
        this.setLayout(new BorderLayout());
        this.period = period;
        JPanel panel_north = new JPanel(new BorderLayout());
        JPanel panel_north_grid = new JPanel(new GridLayout(2, 1));
        this.lbl_phase = new JLabel("", 4);
        this.lbl_period = new JLabel("", 0);
        panel_north_grid.add(this.lbl_period);
        JPanel panel_north_btn = new JPanel(new GridLayout(2, 4));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                JButton btn = new JButton(i == 0 ? "+" : "-");
                btn.setMargin(new Insets(0, 0, 0, 0));
                final boolean plus = i == 0;
                final int type = 3 - j;
                btn.addActionListener(new ActionListener(){
                    final /* synthetic */ CountdownColumn this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.this$0.move_period(type, plus);
                    }
                });
                panel_north_btn.add(btn);
            }
        }
        panel_north_grid.add(panel_north_btn);
        JPanel panel_lbl_phase = new JPanel(new GridLayout(2, 1));
        panel_lbl_phase.add(this.lbl_phase);
        panel_north.add((Component)panel_lbl_phase, "West");
        panel_north.add((Component)panel_north_grid, "Center");
        JPanel panel_box_periodic = new JPanel(new GridLayout(2, 1));
        panel_box_periodic.add(this.box_periodic);
        panel_north.add((Component)panel_box_periodic, "East");
        this.lbl_countdown = new JLabel("", 0);
        this.btn_start = new JButton("");
        this.btn_reset = new JButton("Reset");
        this.btn_start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountdownColumn.this.start(!CountdownColumn.this.active, System.nanoTime());
            }
        });
        this.btn_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CountdownColumn.this.reset();
            }
        });
        this.box_periodic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CountdownColumn.this.box_periodic.isSelected()) {
                    CountdownColumn.this.lbl_phase.setText("");
                    CountdownColumn.this.phase = false;
                }
            }
        });
        JPanel btn_panel = new JPanel(new GridLayout(2, 1));
        JPanel style_start = new JPanel();
        JPanel style_reset = new JPanel();
        style_start.add(this.btn_start);
        style_reset.add(this.btn_reset);
        btn_panel.add(style_start);
        btn_panel.add(style_reset);
        this.add((Component)panel_north, "North");
        this.add((Component)this.lbl_countdown, "Center");
        this.add((Component)btn_panel, "South");
        this.reset();
    }

    private void reset() {
        this.active = false;
        this.phase = false;
        this.time_offset = 0L;
        this.lbl_countdown.setText(IxeTime.str_major(this.period));
        this.lbl_period.setText(IxeTime.str_major(this.period));
        this.lbl_phase.setText("");
        this.btn_start.setText(this.active ? "Stop" : "Start");
    }

    private void start(boolean active, long now) {
        if (active != this.active) {
            this.active = active;
            if (active) {
                this.time = now;
            } else {
                this.time_offset += now - this.time;
                this.lbl_countdown.setText(IxeTime.str_major(this.period - IxeTime.time(this.time_offset)));
            }
            this.btn_start.setText(active ? "Stop" : "Start");
        }
    }

    private void move_period(int type, boolean plus) {
        long move = (long)Math.pow(16.0, type + 4);
        this.period = plus ? (this.period >= 0x200000000L - move ? 0x1FFFFFFFFL : (this.period += move)) : (this.period - move < 0L ? 0L : (this.period -= move));
        this.lbl_period.setText(IxeTime.str_major(this.period));
        if (!this.active) {
            this.lbl_countdown.setText(IxeTime.str_major(this.period));
        }
    }

    public void update(long now) {
        if (this.active) {
            long span = IxeTime.time(this.time_offset + (now - this.time));
            if (span < this.period) {
                this.lbl_countdown.setText(IxeTime.str_major(this.period - span));
            } else if (this.box_periodic.isSelected()) {
                this.phase = !this.phase;
                this.lbl_phase.setText(this.phase ? "\u2a02" : "\u2a01");
                this.time_offset = 0L;
                this.time = now;
            } else {
                this.reset();
            }
        }
    }
}

