/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.time.LocalTime;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pkg_graphic.TabContent;
import pkg_ixe.IxeTime;

public class ClockPanel
extends TabContent {
    JLabel lbl_relative = new JLabel("", 0);
    JLabel lbl_absolute = new JLabel("", 0);

    public ClockPanel() {
        super("Clock", "Track the current time");
        this.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        JPanel pnl_relative = new JPanel(new BorderLayout());
        pnl_relative.add((Component)this.lbl_relative, "Center");
        tabs.addTab("Relative", null, pnl_relative, "Time of the day");
        JPanel pnl_absolute = new JPanel(new BorderLayout());
        pnl_absolute.add((Component)this.lbl_absolute, "Center");
        tabs.addTab("Absolute", null, pnl_absolute, "Time since epoch");
        this.add((Component)tabs, "Center");
        this.update();
    }

    @Override
    public void update() {
        LocalTime now = LocalTime.now();
        this.lbl_relative.setText(this.relative(now));
        this.lbl_absolute.setText(this.absolute(now));
    }

    private String relative(LocalTime now) {
        long time = IxeTime.time(now);
        String prefix = IxeTime.day_halfway(time) ? "\u2a02 " : "\u2a01 ";
        return prefix + IxeTime.str_major(time);
    }

    private String absolute(LocalTime now) {
        long time = IxeTime.time_absolute(now);
        return IxeTime.str_major_absolute(time);
    }
}

