/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_ixe.Ixe;
import pkg_layout.FileTab;
import pkg_layout.Frame;
import pkg_layout.Menubar;
import pkg_layout.TabbedPane;

public class Window
extends Frame {
    public TabbedPane tabbed_pane;
    public boolean toggle_line_nb = HardInfo.LINE_NB;
    public boolean toggle_line_wrap = HardInfo.LINE_WRAP;
    public boolean[] toggle_show = new boolean[]{HardInfo.SHOW_SEARCH, HardInfo.SHOW_REPLACE};
    public boolean[] toggle_highlight = new boolean[]{HardInfo.HIGHLIGHT_SEARCH, HardInfo.HIGHLIGHT_REPLACE};

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(new Menubar(this));
        this.tabbed_pane = new TabbedPane(this);
        this.add((Component)this.tabbed_pane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Window.this.tabbed_pane.request_update = true;
            }
        });
        this.auto();
        this.fullscreen();
        this.setVisible(true);
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        this.tabbed_pane.update();
    }

    public void toggle_line_nb(boolean state) {
        this.toggle_line_nb = state;
        this.tabbed_pane.request_update = true;
    }

    public void toggle_line_wrap(boolean state) {
        this.toggle_line_wrap = state;
        this.update();
        this.tabbed_pane.request_update = true;
        if (this.tabbed_pane.get_selected() != null) {
            this.tabbed_pane.get_selected().request_update = true;
        }
    }

    public void toggle_show(int type, boolean state) {
        this.toggle_show[type] = state;
        this.tabbed_pane.request_update = true;
    }

    public void toggle_highlight(int type, boolean state) {
        this.toggle_highlight[type] = state;
        this.tabbed_pane.request_update = true;
    }

    public void edit_action(int type) {
        FileTab selected = this.tabbed_pane.get_selected();
        if (selected == null) {
            return;
        }
        switch (type) {
            case 0: {
                selected.undo();
                break;
            }
            case 1: {
                selected.redo();
            }
        }
    }

    public void nav_action(int type) {
        int count = this.tabbed_pane.getTabCount();
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.tabbed_pane.setSelectedIndex(0);
            return;
        }
        int index = this.tabbed_pane.getSelectedIndex();
        switch (type) {
            case 0: {
                this.tabbed_pane.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.tabbed_pane.setSelectedIndex(Ixe.clamp(index - 1, 0, count - 1));
                break;
            }
            case 2: {
                this.tabbed_pane.setSelectedIndex(Ixe.clamp(index + 1, 0, count - 1));
                break;
            }
            case 3: {
                this.tabbed_pane.setSelectedIndex(count - 1);
            }
        }
    }

    public void add_new_file_tab() {
        this.tabbed_pane.add_empty_tab();
    }

    public void close_selected_file_tab() {
        int selected_tab = this.tabbed_pane.getSelectedIndex();
        if (selected_tab != -1) {
            this.tabbed_pane.remove(selected_tab);
        }
        if (this.tabbed_pane.getTabCount() == 0) {
            this.tabbed_pane.add_empty_tab();
        }
    }

    public void close_all_file_tabs() {
        this.tabbed_pane.removeAll();
        this.tabbed_pane.add_empty_tab();
    }

    private void auto() {
        this.auto = new File("auto.txt");
        if (this.auto.exists() && this.auto.isFile()) {
            this.load(this.auto);
        } else {
            this.tabbed_pane.add_empty_tab();
        }
    }

    @Override
    public void autosave() {
        int index = this.tabbed_pane.find_file(this.auto);
        if (index != -1) {
            this.save(this.tabbed_pane.get_file_tab(index), this.auto);
        }
    }

    public void set_auto() {
        FileTab ft = this.tabbed_pane.get_selected();
        if (ft != null) {
            int autos;
            while ((autos = this.tabbed_pane.find_file(this.auto)) != -1) {
                this.tabbed_pane.get_file_tab(autos).set_file(null);
            }
            ft.set_file(this.auto);
            this.save(ft, this.auto);
        }
    }

    public void save() {
        FileTab ft = this.tabbed_pane.get_selected();
        if (ft == null) {
            return;
        }
        this.save(ft, ft.get_file());
    }

    private void save(FileTab ft, File f) {
        if (ft == null) {
            return;
        }
        if (f == null) {
            f = this.select_file(true);
        }
        if (f == null) {
            return;
        }
        boolean success = this.write(f, ft);
        if (success) {
            if (ft.get_file() == null) {
                ft.set_file(f);
            }
            ft.make_original();
        }
    }

    public void export() {
        FileTab ft = this.tabbed_pane.get_selected();
        if (ft == null) {
            return;
        }
        File f = this.select_file(true);
        if (f == null) {
            return;
        }
        this.write(f, ft);
    }

    public void save_p1() {
    }

    @Override
    public void load(File file) {
        if (file == null) {
            file = this.select_file(false);
        }
        if (file == null || !file.exists() || !file.isFile()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        try {
            int file_index = this.tabbed_pane.find_file(file);
            if (file_index != -1) {
                this.tabbed_pane.setSelectedIndex(file_index);
            } else {
                FileTab ft2;
                DataInputStream reader = new DataInputStream(new FileInputStream(file));
                byte[] buffer = new byte[2048];
                int read = 0;
                while ((read = reader.read(buffer)) > 0) {
                    builder.append(new String(buffer, 0, read));
                }
                this.tabbed_pane.add_tab(file, builder.toString());
                if (this.tabbed_pane.getTabCount() == 2 && (ft2 = this.tabbed_pane.get_file_tab(0)).is_original() && ft2.area.getText().isEmpty() && ft2.get_file() == null) {
                    this.tabbed_pane.remove(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

