/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_layout.FileTab;
import pkg_layout.Window;

public class TabbedPane
extends JTabbedPane {
    public boolean request_focus = false;
    public boolean request_update = false;
    private boolean override_update = false;
    private FileTab selected_tab = null;
    public Window window;

    public TabbedPane(Window window) {
        this.window = window;
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedPane.this.selected_tab = (FileTab)TabbedPane.this.getSelectedComponent();
                TabbedPane.this.override_update = true;
                TabbedPane.this.update();
                TabbedPane.this.request_focus = true;
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = TabbedPane.this.getSelectedIndex();
                boolean valid = index >= 0 && index < TabbedPane.this.getTabCount();
                switch (e.getButton()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        TabbedPane.this.add_empty_tab();
                        break;
                    }
                    case 3: {
                        FileTab ft;
                        if (!valid || !(ft = (FileTab)TabbedPane.this.getComponentAt(index)).is_original() && (ft.get_file() != null || !ft.get_text().isEmpty())) break;
                        TabbedPane.this.remove(index);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.request_focus = true;
    }

    public void add_tab(File file, String data) {
        FileTab ft = new FileTab(file, data, this);
        this.addTab(null, null, ft, ft.get_path());
        this.setTabComponentAt(this.getTabCount() - 1, ft.get_tab_panel());
        this.setSelectedIndex(this.getTabCount() - 1);
    }

    public void add_empty_tab() {
        this.add_tab(null, "");
    }

    public int find_file(File file) {
        if (file != null) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                File file2 = ((FileTab)this.getComponentAt(i)).get_file();
                if (file2 == null || file2.compareTo(file) != 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void update() {
        if (this.request_focus) {
            this.request_focus = false;
            if (this.selected_tab == null) {
                this.selected_tab = (FileTab)this.getSelectedComponent();
            }
            if (this.selected_tab != null) {
                this.selected_tab.area.requestFocusInWindow();
            }
        }
        if (this.selected_tab != null) {
            this.selected_tab.request_highlight();
        }
        if (this.override_update || this.request_update) {
            this.override_update = false;
            this.request_update = false;
            if (this.selected_tab != null) {
                this.selected_tab.update();
            }
            this.request_update = false;
        }
    }

    public FileTab get_selected() {
        return this.selected_tab;
    }

    public FileTab get_file_tab(int index) {
        return index >= 0 && index < this.getTabCount() ? (FileTab)this.getComponentAt(index) : null;
    }
}

