/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_core.HardInfo;
import pkg_layout.Window;

public class Menubar
extends JMenuBar {
    private Window window;

    public Menubar(Window window) {
        this.window = window;
        this.gen_file_menu();
        this.gen_window_menu();
        this.gen_edit_menu();
        this.gen_navigate_menu();
        this.build_version_label();
    }

    private void gen_file_menu() {
        JMenu menu = new JMenu("File");
        JMenuItem mi_new = new JMenuItem("New");
        JMenuItem mi_save = new JMenuItem("Save");
        JMenuItem mi_save_as_autoload = new JMenuItem("Save as auto");
        JMenu menu_export = new JMenu("Export as");
        JMenuItem mi_export_txt = new JMenuItem("txt...");
        menu_export.add(mi_export_txt);
        JMenuItem mi_load = new JMenuItem("Load...");
        JMenuItem mi_exit = new JMenuItem("Exit program");
        mi_new.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.add_new_file_tab();
            }
        });
        mi_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.save();
            }
        });
        mi_save_as_autoload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.set_auto();
            }
        });
        mi_export_txt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.export();
            }
        });
        mi_load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.load(null);
            }
        });
        mi_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Menubar)Menubar.this).window.request_close = true;
            }
        });
        mi_new.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        mi_save.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        mi_load.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        mi_exit.setAccelerator(KeyStroke.getKeyStroke(27, 128));
        menu.add(mi_new);
        menu.add(mi_save);
        menu.add(mi_save_as_autoload);
        menu.add(menu_export);
        menu.addSeparator();
        menu.add(mi_load);
        menu.addSeparator();
        menu.add(mi_exit);
        this.add(menu);
    }

    private void gen_window_menu() {
        JMenu menu = new JMenu("Window");
        final JCheckBoxMenuItem mi_fullscreen = new JCheckBoxMenuItem("Fullscreen", HardInfo.FULLSCREEN);
        final JCheckBoxMenuItem mi_line_nb = new JCheckBoxMenuItem("Line number", HardInfo.LINE_NB);
        final JCheckBoxMenuItem mi_line_wrap = new JCheckBoxMenuItem("Wrapped lines", HardInfo.LINE_WRAP);
        final JCheckBoxMenuItem mi_show1 = new JCheckBoxMenuItem("Show search", HardInfo.SHOW_SEARCH);
        final JCheckBoxMenuItem mi_show2 = new JCheckBoxMenuItem("Show replace", HardInfo.SHOW_REPLACE);
        final JCheckBoxMenuItem mi_high1 = new JCheckBoxMenuItem("Highlight search term", HardInfo.HIGHLIGHT_SEARCH);
        final JCheckBoxMenuItem mi_high2 = new JCheckBoxMenuItem("Highlight replace term", HardInfo.HIGHLIGHT_REPLACE);
        mi_fullscreen.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                HardInfo.FULLSCREEN = mi_fullscreen.getState();
                ((Menubar)this.this$0).window.request_fullscreen = true;
            }
        });
        mi_line_nb.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.window.toggle_line_nb(mi_line_nb.getState());
            }
        });
        mi_line_wrap.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.window.toggle_line_wrap(mi_line_wrap.getState());
            }
        });
        mi_show1.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.window.toggle_show(0, mi_show1.getState());
                if (!mi_show1.getState()) {
                    mi_show2.setState(false);
                }
            }
        });
        mi_show2.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.window.toggle_show(1, mi_show2.getState());
                if (mi_show2.getState()) {
                    mi_show1.setState(true);
                }
            }
        });
        mi_high1.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.window.toggle_highlight(0, mi_high1.getState());
            }
        });
        mi_high2.addChangeListener(new ChangeListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.window.toggle_highlight(1, mi_high2.getState());
            }
        });
        mi_fullscreen.setAccelerator(KeyStroke.getKeyStroke(122, 128));
        mi_line_nb.setAccelerator(KeyStroke.getKeyStroke(121, 128));
        mi_line_wrap.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        mi_show1.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        mi_show2.setAccelerator(KeyStroke.getKeyStroke(70, 192));
        mi_high1.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        mi_high2.setAccelerator(KeyStroke.getKeyStroke(74, 128));
        menu.add(mi_fullscreen);
        menu.add(mi_line_nb);
        menu.add(mi_line_wrap);
        menu.add(mi_show1);
        menu.add(mi_show2);
        menu.add(mi_high1);
        menu.add(mi_high2);
        this.add(menu);
    }

    private void gen_edit_menu() {
        JMenu menu = new JMenu("Edit");
        JMenuItem mi_undo = new JMenuItem("Undo");
        JMenuItem mi_redo = new JMenuItem("Redo");
        mi_undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.edit_action(0);
            }
        });
        mi_redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.edit_action(1);
            }
        });
        mi_undo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        mi_redo.setAccelerator(KeyStroke.getKeyStroke(90, 192));
        menu.add(mi_undo);
        menu.add(mi_redo);
        this.add(menu);
    }

    private void gen_navigate_menu() {
        JMenu menu = new JMenu("Navigate");
        JMenuItem mi_first = new JMenuItem("First tab");
        JMenuItem mi_prev = new JMenuItem("Previous tab");
        JMenuItem mi_next = new JMenuItem("Next tab");
        JMenuItem mi_last = new JMenuItem("Last tab");
        JMenuItem mi_close = new JMenuItem("Close tab");
        JMenuItem mi_close_all = new JMenuItem("Close all tabs");
        mi_first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.nav_action(0);
            }
        });
        mi_prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.nav_action(1);
            }
        });
        mi_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.nav_action(2);
            }
        });
        mi_last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.nav_action(3);
            }
        });
        mi_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.close_selected_file_tab();
            }
        });
        mi_close_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.window.close_all_file_tabs();
            }
        });
        mi_first.setAccelerator(KeyStroke.getKeyStroke(49, 128));
        mi_prev.setAccelerator(KeyStroke.getKeyStroke(50, 128));
        mi_next.setAccelerator(KeyStroke.getKeyStroke(51, 128));
        mi_last.setAccelerator(KeyStroke.getKeyStroke(52, 128));
        menu.add(mi_first);
        menu.add(mi_prev);
        menu.add(mi_next);
        menu.add(mi_last);
        menu.addSeparator();
        menu.add(mi_close);
        menu.add(mi_close_all);
        this.add(menu);
    }

    private void build_version_label() {
        this.add(Box.createHorizontalGlue());
        JLabel version_lbl = new JLabel("Version 1.0");
        version_lbl.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.add(version_lbl);
    }
}

