/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pkg_core.Screen;
import pkg_ixe.IxeDialog;
import pkg_layout.FileTab;

public abstract class Frame
extends JFrame {
    protected static final JFileChooser fc = new JFileChooser();
    public boolean request_close = false;
    public boolean request_fullscreen = true;
    protected File auto = null;

    public Frame(String title) {
        this.init_dialog();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame.this.request_close = true;
            }
        });
        this.setSize(Screen.w / 2, Screen.h / 2);
        this.setLocationRelativeTo(null);
        this.setTitle(title);
    }

    private void init_dialog() {
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ".txt";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".txt");
            }
        });
    }

    protected abstract void load(File var1);

    public abstract void update();

    protected File select_file(boolean save) {
        int returnVal;
        int n = returnVal = save ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            if (!f.getName().endsWith(".txt")) {
                f = new File(f.getPath() + ".txt");
                fc.setSelectedFile(f);
            }
            return f;
        }
        return null;
    }

    public abstract void autosave();

    protected boolean write(File f, FileTab ft) {
        try {
            FileOutputStream outputStream = new FileOutputStream(f);
            byte[] strToBytes = ft.get_text().getBytes();
            outputStream.write(strToBytes);
            outputStream.close();
        }
        catch (IOException e) {
            IxeDialog.error("! could not save file '" + f + "' !");
            return false;
        }
        return true;
    }
}

