/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import pkg_graphic.ThinButton;
import pkg_ixe.Ixe;
import pkg_layout.TabbedPane;

public class FileTab
extends JPanel {
    private File file;
    private String original;
    public JTextArea area = new JTextArea();
    private JTextArea line_nb = new JTextArea();
    private JLabel lbl_character_count = new JLabel();
    private TabbedPane ref;
    private JPanel pnl_search;
    private JPanel pnl_replace;
    private JPanel tab_panel = new JPanel(new BorderLayout());
    private JLabel tab_label = new JLabel();
    private ThinButton tab_btn = new ThinButton("X");
    private JTextField search = new JTextField();
    private JTextField replace = new JTextField();
    private ThinButton btn_search_previous = new ThinButton("\u2191");
    private ThinButton btn_search_next = new ThinButton("\u2193");
    private ThinButton btn_search_first = new ThinButton("\u2912");
    private ThinButton btn_search_last = new ThinButton("\u2913");
    private JCheckBox box_match_case = new JCheckBox("Match case");
    private JCheckBox box_regex = new JCheckBox("Regex");
    private ThinButton btn_replace = new ThinButton("Replace selected");
    private ThinButton btn_replace_all = new ThinButton("Replace all");
    private JLabel lbl_search_count = new JLabel();
    private JLabel lbl_replace_count = new JLabel();
    private int search_count = 0;
    private int replace_count = 0;
    public boolean request_update = false;
    private boolean toggle_line_nb = false;
    private boolean toggle_line_wrap = false;
    private UndoManager edit_manager;
    private DefaultHighlighter highlighter = (DefaultHighlighter)this.area.getHighlighter();
    private DefaultHighlighter.DefaultHighlightPainter search_painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 128, 128));
    private DefaultHighlighter.DefaultHighlightPainter replace_painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(128, 255, 128));
    private String highlight_search = "";
    private String highlight_replace = "";

    public FileTab(File file, String str, TabbedPane ref) {
        this.ref = ref;
        this.setLayout(new BorderLayout());
        this.file = file;
        this.original = str;
        this.area.setText(str);
        this.line_nb.setDisabledTextColor(Color.BLACK);
        this.line_nb.setBackground(new Color(230, 230, 230));
        this.line_nb.setEditable(false);
        this.line_nb.setEnabled(false);
        this.line_nb.setVisible(this.toggle_line_nb);
        this.area.setBorder(new EmptyBorder(0, 6, 0, 6));
        this.area.setLineWrap(this.toggle_line_wrap);
        this.edit_manager = new UndoManager();
        this.area.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                FileTab.this.edit_manager.addEdit(e.getEdit());
            }
        });
        this.highlighter.setDrawsLayeredHighlights(false);
        JScrollPane pane = new JScrollPane(this.area, 20, 30);
        pane.setRowHeaderView(this.line_nb);
        this.add((Component)pane, "Center");
        this.add((Component)this.make_south(), "South");
        this.area.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FileTab.this.text_callback();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FileTab.this.text_callback();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FileTab.this.text_callback();
            }
        });
        this.init_tab();
        this.text_callback();
    }

    public void request_highlight() {
        boolean request;
        boolean bl = request = !this.highlight_search.equals(this.search.getText()) || !this.highlight_replace.equals(this.replace.getText());
        if (request) {
            this.highlight_search = this.search.getText();
            this.highlight_replace = this.replace.getText();
            this.request_update = true;
            this.ref.request_update = true;
        }
    }

    private JPanel make_south() {
        JPanel pnl_south = new JPanel(new BorderLayout());
        this.search.setPreferredSize(new Dimension(150, 20));
        this.replace.setPreferredSize(new Dimension(150, 20));
        this.lbl_search_count.setPreferredSize(new Dimension(35, 0));
        this.lbl_replace_count.setPreferredSize(new Dimension(35, 0));
        this.lbl_search_count.setForeground(Color.gray);
        this.lbl_replace_count.setForeground(Color.gray);
        JPanel pnl_search_field = new JPanel(new BorderLayout());
        pnl_search_field.add((Component)this.lbl_search_count, "East");
        JPanel pnl_replace_field = new JPanel(new BorderLayout());
        pnl_replace_field.add((Component)this.lbl_replace_count, "East");
        JPanel pnl_sub_south = new JPanel(new BorderLayout());
        this.pnl_search = new JPanel(new BorderLayout());
        this.pnl_search.add((Component)pnl_search_field, "West");
        JPanel search_params = new JPanel(new BorderLayout());
        JPanel search_params_nav = new JPanel(new GridLayout(1, 4));
        search_params_nav.add(this.btn_search_first);
        search_params_nav.add(this.btn_search_previous);
        search_params_nav.add(this.btn_search_next);
        search_params_nav.add(this.btn_search_last);
        search_params.add((Component)search_params_nav, "West");
        JPanel search_params_box = new JPanel(new GridLayout(1, 2));
        search_params_box.add(this.box_match_case);
        search_params_box.add(this.box_regex);
        search_params.add((Component)search_params_box, "East");
        this.pnl_search.add((Component)search_params, "East");
        this.pnl_replace = new JPanel(new BorderLayout());
        this.pnl_replace.add((Component)pnl_replace_field, "West");
        JPanel replace_params_west = new JPanel(new BorderLayout());
        JPanel replace_params = new JPanel(new GridLayout(1, 2));
        replace_params.add(this.btn_replace);
        replace_params.add(this.btn_replace_all);
        replace_params_west.add((Component)replace_params, "West");
        this.pnl_replace.add((Component)replace_params_west, "Center");
        JPanel pnl_params = new JPanel(new BorderLayout());
        pnl_params.add((Component)this.pnl_search, "Center");
        pnl_params.add((Component)this.pnl_replace, "South");
        JPanel pnl_input = new JPanel(new BorderLayout());
        pnl_input.add((Component)this.search, "Center");
        pnl_input.add((Component)this.replace, "South");
        pnl_sub_south.add((Component)pnl_input, "West");
        pnl_sub_south.add((Component)pnl_params, "Center");
        pnl_south.add((Component)pnl_sub_south, "West");
        this.box_match_case.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileTab.this.request_update = true;
                ((FileTab)FileTab.this).ref.request_update = true;
            }
        });
        this.box_regex.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileTab.this.request_update = true;
                ((FileTab)FileTab.this).ref.request_update = true;
            }
        });
        this.btn_search_first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.search_first();
            }
        });
        this.btn_search_previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.search_previous();
            }
        });
        this.btn_search_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.search_next();
            }
        });
        this.btn_search_last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.search_last();
            }
        });
        this.btn_replace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.replace_selected();
            }
        });
        this.btn_replace_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.replace_all();
            }
        });
        JPanel pnl_cc = new JPanel(new BorderLayout());
        pnl_cc.add((Component)this.lbl_character_count, "North");
        pnl_south.add((Component)pnl_cc, "East");
        this.search.setVisible(false);
        this.pnl_search.setVisible(false);
        this.replace.setVisible(false);
        this.pnl_replace.setVisible(false);
        return pnl_south;
    }

    private void search_first() {
        if (this.box_regex.isSelected()) {
            this.regex_search(true, 0);
        } else {
            this.search(this.box_match_case.isSelected() ? this.area.getText() : this.area.getText().toUpperCase(), true, 0);
        }
    }

    private void search_last() {
        if (this.box_regex.isSelected()) {
            this.regex_search(false, this.area.getText().length());
        } else {
            this.search(this.box_match_case.isSelected() ? this.area.getText() : this.area.getText().toUpperCase(), false, 0);
        }
    }

    private void search_previous() {
        int selection_start = this.area.getSelectionStart();
        if (selection_start < 0) {
            selection_start = 0;
        }
        if (this.box_regex.isSelected()) {
            this.regex_search(false, selection_start);
        } else {
            this.search(this.box_match_case.isSelected() ? this.area.getText().substring(0, selection_start) : this.area.getText().substring(0, selection_start).toUpperCase(), false, 0);
        }
    }

    private void search_next() {
        int selection_end = this.area.getSelectionEnd();
        if (selection_end > this.area.getText().length()) {
            selection_end = this.area.getText().length();
        }
        if (this.box_regex.isSelected()) {
            this.regex_search(true, selection_end);
        } else {
            this.search(this.box_match_case.isSelected() ? this.area.getText().substring(selection_end) : this.area.getText().substring(selection_end).toUpperCase(), true, selection_end);
        }
    }

    private void search(String content, boolean asc, int offset) {
        int s;
        String search_str;
        this.area.setSelectionEnd(this.area.getSelectionStart());
        String string = search_str = this.box_match_case.isSelected() ? this.search.getText() : this.search.getText().toUpperCase();
        if (search_str.isEmpty()) {
            return;
        }
        int n = s = asc ? content.indexOf(search_str) : content.lastIndexOf(search_str);
        if (s != -1) {
            this.area.setSelectionStart(s + offset);
            this.area.setSelectionEnd(s + search_str.length() + offset);
        }
        this.ref.request_focus = true;
    }

    private void regex_search(boolean asc, int offset) {
        int start;
        this.area.setSelectionEnd(this.area.getSelectionStart());
        String search_regex = (this.box_match_case.isSelected() ? "" : "(?i)") + this.search.getText();
        if (search_regex.isEmpty()) {
            return;
        }
        Pattern p = this.pattern(search_regex);
        if (p == null) {
            return;
        }
        Matcher matcher = p.matcher(this.area.getText());
        int end = start = this.area.getSelectionStart();
        if (asc) {
            if (matcher.find(offset)) {
                start = matcher.start();
                end = matcher.end();
            }
        } else {
            while (matcher.find() && matcher.end() <= offset) {
                start = matcher.start();
                end = matcher.end();
            }
        }
        this.area.setSelectionStart(start);
        this.area.setSelectionEnd(end);
        this.ref.request_focus = true;
    }

    private void replace_selected() {
        String search_regex = (this.box_match_case.isSelected() ? "" : "(?i)") + this.search.getText();
        if (search_regex.isEmpty() || this.area.getText().isEmpty()) {
            return;
        }
        Pattern p = this.pattern(search_regex);
        if (p == null) {
            return;
        }
        int start = this.area.getSelectionStart();
        int end = this.area.getSelectionEnd();
        Matcher matcher = p.matcher(this.area.getText().substring(start, end));
        if (start >= 0 && end >= 0 && matcher.find()) {
            String replacement = matcher.replaceAll(this.replace.getText());
            String content = this.area.getText().substring(0, start) + replacement + this.area.getText().substring(end);
            this.area.setText(content);
            end = start + replacement.length();
        }
        this.area.setSelectionStart(start);
        this.area.setSelectionStart(end);
        this.ref.request_focus = true;
    }

    private void replace_all() {
        String search_str = (this.box_match_case.isSelected() ? "" : "(?i)") + this.search.getText();
        if (search_str.isEmpty() || this.area.getText().isEmpty()) {
            return;
        }
        this.area.setText(this.area.getText().replaceAll(search_str, this.replace.getText()));
        this.ref.request_focus = true;
    }

    private void update_highlighter() {
        block13: {
            this.search_count = 0;
            this.replace_count = 0;
            this.highlighter.removeAllHighlights();
            if (this.ref.window.toggle_highlight[1] && this.pnl_replace.isVisible() && !this.replace.getText().isEmpty()) {
                int length = this.replace.getText().length();
                String content = this.area.getText();
                for (int i = 0; i <= content.length() - length; ++i) {
                    int s = content.indexOf(this.replace.getText(), i);
                    if (s == -1) continue;
                    try {
                        this.highlighter.addHighlight(s, s + length, this.replace_painter);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    i = s + length - 1;
                    ++this.replace_count;
                }
            }
            if (!this.ref.window.toggle_highlight[0] || !this.pnl_search.isVisible() || this.search.getText().isEmpty()) break block13;
            if (this.box_regex.isSelected()) {
                String search_regex = (this.box_match_case.isSelected() ? "" : "(?i)") + this.search.getText();
                Pattern p = this.pattern(search_regex);
                if (p == null) {
                    return;
                }
                Matcher matcher = p.matcher(this.area.getText());
                while (matcher.find()) {
                    try {
                        this.highlighter.addHighlight(matcher.start(), matcher.end(), this.search_painter);
                    }
                    catch (BadLocationException s) {
                        // empty catch block
                    }
                    ++this.search_count;
                }
            } else {
                String highlight_str = this.box_match_case.isSelected() ? this.search.getText() : this.search.getText().toUpperCase();
                int length = highlight_str.length();
                String content = this.box_match_case.isSelected() ? this.area.getText() : this.area.getText().toUpperCase();
                for (int i = 0; i <= content.length() - length; ++i) {
                    int s = content.indexOf(highlight_str, i);
                    if (s == -1) continue;
                    try {
                        this.highlighter.addHighlight(s, s + length, this.search_painter);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    i = s + length - 1;
                    ++this.search_count;
                }
            }
        }
    }

    private Pattern pattern(String regex) {
        Pattern p = null;
        try {
            p = Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return p;
    }

    private void init_tab() {
        this.tab_label.setText(this.get_name());
        this.tab_panel.setOpaque(false);
        this.tab_label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.tab_panel.add((Component)this.tab_label, "Center");
        this.tab_panel.add((Component)this.tab_btn, "East");
        this.tab_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTab.this.ref.remove(FileTab.this);
            }
        });
    }

    public JPanel get_tab_panel() {
        return this.tab_panel;
    }

    public void make_original() {
        this.original = this.area.getText();
        this.tab_label.setText(this.get_name());
        this.tab_btn.setVisible(false);
    }

    public boolean is_original() {
        return this.original.equals(this.area.getText());
    }

    private void text_callback() {
        this.tab_btn.setVisible(!this.original.equals(this.area.getText()));
        this.lbl_character_count.setText(Ixe.rax(this.area.getText().length()) + " characters, " + Ixe.rax(this.area.getLineCount()) + " lines");
        this.request_update = true;
        this.ref.request_update = true;
    }

    public void update() {
        if (this.pnl_search.isVisible() != this.ref.window.toggle_show[0]) {
            this.pnl_search.setVisible(this.ref.window.toggle_show[0]);
            this.search.setVisible(this.ref.window.toggle_show[0]);
            if (this.ref.window.toggle_show[0]) {
                this.search.requestFocusInWindow();
            }
        }
        if (this.pnl_replace.isVisible() != this.ref.window.toggle_show[1]) {
            this.pnl_replace.setVisible(this.ref.window.toggle_show[1]);
            this.replace.setVisible(this.ref.window.toggle_show[1]);
            if (this.ref.window.toggle_show[1]) {
                this.replace.requestFocusInWindow();
            }
        }
        if (this.toggle_line_nb != this.ref.window.toggle_line_nb) {
            this.toggle_line_nb = this.ref.window.toggle_line_nb;
            if (this.toggle_line_nb) {
                this.request_update = true;
                this.ref.request_update = true;
            } else {
                this.line_nb.setVisible(false);
            }
        }
        if (this.toggle_line_wrap != this.ref.window.toggle_line_wrap) {
            this.toggle_line_wrap = this.ref.window.toggle_line_wrap;
            this.area.setLineWrap(this.toggle_line_wrap);
            if (this.line_nb.isVisible()) {
                this.request_update = true;
                this.ref.request_update = true;
            }
        }
        if (this.request_update) {
            if (this.toggle_line_nb) {
                this.update_line_nb();
            }
            this.line_nb.setVisible(this.toggle_line_nb);
            this.request_update = false;
        }
        this.update_highlighter();
        if (this.pnl_search.isVisible()) {
            this.lbl_search_count.setText(Ixe.rax(this.search_count));
        }
        if (this.pnl_replace.isVisible()) {
            this.lbl_replace_count.setText(Ixe.rax(this.replace_count));
        }
    }

    private void update_line_nb() {
        String line_count_str = "";
        if (this.toggle_line_wrap) {
            if (!this.area.getText().isEmpty()) {
                int line_it = this.area.getLineCount() - 1;
                int offset = this.area.getText().length();
                while (offset >= 0) {
                    try {
                        offset = Utilities.getRowStart(this.area, offset) - 1;
                        line_count_str = System.lineSeparator() + line_count_str;
                        if (offset < 0 || offset >= this.area.getText().length() || this.area.getText().charAt(offset) != '\n') continue;
                        line_count_str = Ixe.rax(line_it--) + line_count_str;
                    }
                    catch (BadLocationException e) {
                        --offset;
                    }
                }
            }
            line_count_str = Ixe.rax(0.0) + line_count_str;
        } else {
            int line_count = this.area.getLineCount();
            for (int i = 0; i < line_count; ++i) {
                line_count_str = line_count_str + Ixe.rax(i) + System.lineSeparator();
            }
        }
        this.line_nb.setText(line_count_str);
    }

    public String get_text() {
        return this.area.getText();
    }

    public String get_name() {
        return this.file == null ? "Untitled" : this.file.getName();
    }

    public String get_path() {
        return this.file == null ? "Save to keep" : this.file.getPath();
    }

    public File get_file() {
        return this.file;
    }

    public void set_file(File file) {
        this.file = file;
        this.tab_label.setText(this.get_name());
    }

    public void undo() {
        if (this.edit_manager.canUndo()) {
            try {
                this.edit_manager.undo();
            }
            catch (CannotRedoException cre) {
                cre.printStackTrace();
            }
        }
    }

    public void redo() {
        if (this.edit_manager.canRedo()) {
            try {
                this.edit_manager.redo();
            }
            catch (CannotRedoException cre) {
                cre.printStackTrace();
            }
        }
    }

    private static enum FILE_TYPE {
        TXT,
        P1;

    }
}

