/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrapPane
extends JTextPane {
    private boolean lineWrap;

    public WrapPane(boolean lineWrap) {
        this.lineWrap = lineWrap;
        if (lineWrap) {
            this.setEditorKit(new WrapEditorKit());
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.lineWrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return this.getParent() == null || this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    private class WrapEditorKit
    extends StyledEditorKit {
        private final ViewFactory defaultFactory;

        private WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    private class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    private class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element element) {
            String kind = element.getName();
            if (kind != null) {
                switch (kind) {
                    case "content": {
                        return new WrapLabelView(element);
                    }
                    case "paragraph": {
                        return new ParagraphView(element);
                    }
                    case "section": {
                        return new BoxView(element, 1);
                    }
                    case "component": {
                        return new ComponentView(element);
                    }
                    case "icon": {
                        return new IconView(element);
                    }
                }
            }
            return new LabelView(element);
        }
    }
}

