/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LimitTextField
extends JTextField {
    private int limit;
    private int case_type;

    public LimitTextField(int limit) {
        this(limit, 0);
    }

    public LimitTextField(int limit, int case_type) {
        this.limit = limit;
        this.case_type = case_type;
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitDocument();
    }

    private class LimitDocument
    extends PlainDocument {
        private LimitDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= LimitTextField.this.limit) {
                switch (LimitTextField.this.case_type) {
                    case 1: {
                        str = str.toLowerCase();
                        break;
                    }
                    case 2: {
                        str = str.toUpperCase();
                    }
                }
                super.insertString(offset, str, attr);
            }
        }
    }
}

