/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import pkg_ixe.Ixe;
import pkg_ixe.IxeArray;
import pkg_ixe.IxeRadix;

public class Sorter {
    private static String[] data(String in, SORT type, boolean no_duplicates, boolean no_empty, boolean only_sort_col, boolean append_unsorted, boolean ignore_case, boolean trim_row, boolean trim_col, int split_index, String split_regex, boolean use_separator, String separator, int value_radix) {
        int i;
        boolean use_compare = !split_regex.isEmpty() || ignore_case;
        StringBuilder builder = new StringBuilder();
        String[] data = in.split("\n");
        String[] compare = use_compare || type == SORT.VALUE ? new String[data.length] : null;
        double[] compare2 = type == SORT.VALUE ? new double[data.length] : null;
        int range = 0;
        for (i = 0; i < data.length; ++i) {
            boolean valid;
            int j;
            String[] stringArray;
            String datum;
            String string = datum = trim_row ? data[i].trim() : data[i];
            if (split_regex.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = datum;
            } else {
                stringArray = datum.split(split_regex);
            }
            String[] cols = stringArray;
            String col = "";
            int index = Ixe.clamp(split_index, 0, cols.length - 1);
            if (index >= 0) {
                String string2 = col = trim_col ? cols[index].trim() : cols[index];
                if (ignore_case) {
                    col = col.toUpperCase();
                }
            }
            if (only_sort_col) {
                datum = col;
            } else if (trim_col) {
                builder.delete(0, builder.length());
                for (int j2 = 0; j2 < cols.length; ++j2) {
                    if (j2 != 0) {
                        builder.append(separator);
                    }
                    builder.append(cols[j2].trim());
                }
                datum = builder.toString();
            }
            if (use_separator) {
                String[] stringArray3;
                if (split_regex.isEmpty()) {
                    String[] stringArray4 = new String[1];
                    stringArray3 = stringArray4;
                    stringArray4[0] = datum;
                } else {
                    stringArray3 = datum.split(split_regex);
                }
                String[] sep_cols = stringArray3;
                builder.delete(0, builder.length());
                for (j = 0; j < sep_cols.length; ++j) {
                    if (j != 0) {
                        builder.append(separator);
                    }
                    builder.append(sep_cols[j]);
                }
                datum = builder.toString();
            }
            boolean bl = valid = !no_empty || !datum.isEmpty();
            if (valid && no_duplicates) {
                for (j = 0; j < range; ++j) {
                    if (!data[i].equals(data[j])) continue;
                    valid = false;
                    break;
                }
            }
            if (!valid) continue;
            data[range] = datum + (append_unsorted ? separator + IxeRadix.write(range) : "");
            if (use_compare || type == SORT.VALUE) {
                compare[range] = col;
            }
            if (type == SORT.VALUE) {
                int j3;
                double v = Double.POSITIVE_INFINITY;
                int best = 0;
                for (j3 = 0; j3 < compare[range].length(); ++j3) {
                    char c = compare[range].charAt(j3);
                    if (j3 == 0 && c == '-' || c == '.' || IxeRadix.valid_digit(c, value_radix)) continue;
                    best = j3;
                    break;
                }
                for (j3 = best; j3 >= 0; --j3) {
                    try {
                        v = IxeRadix.read_double(compare[range].substring(0, j3), value_radix);
                        compare[range] = compare[range].substring(j3);
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                compare2[range] = v;
            }
            ++range;
        }
        for (i = range; i < data.length; ++i) {
            data[i] = null;
        }
        switch (type.ordinal()) {
            case 3: {
                IxeArray.flip(data, 0, range - 1);
                break;
            }
            case 4: {
                IxeArray.shuffle(data, 0, range - 1);
                break;
            }
            case 0: {
                if (use_compare) {
                    Sorter.lex_sort(compare, data, 0, range - 1);
                    break;
                }
                Sorter.lex_sort(data, 0, range - 1);
                break;
            }
            case 1: {
                if (use_compare) {
                    Sorter.num_sort(compare, data, 0, range - 1);
                    break;
                }
                Sorter.num_sort(data, 0, range - 1);
                break;
            }
            case 2: {
                Sorter.val_sort(compare2, compare, data, 0, range - 1);
            }
        }
        return data;
    }

    public static String solve(SORT type, String in1, String in2, boolean order, boolean replace, boolean no_duplicates, boolean no_empty, boolean only_sort_col, boolean append_sorted, boolean append_unsorted, boolean ignore_case, boolean trim_row, boolean trim_col, int split_index, String split_regex, boolean use_separator, String separator, int value_radix, String prefix, String suffix) {
        int length2;
        String[] data1 = Sorter.data(in1, type, no_duplicates, no_empty, only_sort_col, append_unsorted, ignore_case, trim_row, trim_col, split_index, split_regex, use_separator, separator, value_radix);
        String[] data2 = replace ? Sorter.data(in2, type, no_duplicates, no_empty, only_sort_col, append_unsorted, ignore_case, trim_row, trim_col, split_index, split_regex, use_separator, separator, value_radix) : null;
        StringBuilder builder = new StringBuilder();
        int length1 = data1 == null ? 0 : data1.length;
        int n = length2 = data2 == null ? 0 : data2.length;
        while (data1[length1 - 1] == null) {
            --length1;
        }
        if (replace) {
            while (data2[length2 - 1] == null) {
                --length2;
            }
        }
        int length = Math.max(length1, length2);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                builder.append('\n');
            }
            builder.append(prefix);
            if (replace) {
                int x2;
                int x1 = order ? length1 - i - 1 : i;
                int n2 = x2 = order ? length2 - i - 1 : i;
                if (x1 < length1) {
                    builder.append(data1[x1]);
                }
                if (x1 < length1 && x2 < length2) {
                    builder.append(separator);
                }
                if (x2 < length2) {
                    builder.append(data2[x2]);
                }
                if (append_sorted) {
                    builder.append(separator).append(IxeRadix.write(i));
                }
            } else {
                int x = order ? length1 - i - 1 : i;
                builder.append(data1[x]);
                if (append_sorted) {
                    builder.append(separator).append(IxeRadix.write(i));
                }
            }
            builder.append(suffix);
        }
        return builder.toString();
    }

    private static void lex_sort(String[] compare, int lo, int hi) {
        int length = hi - lo + 1;
        int start = length / 2;
        int end = length;
        block0: while (end > 1) {
            if (start <= 0) {
                IxeArray.swap(compare, lo, --end + lo);
            }
            int root = --start;
            while (2 * root + 1 < end) {
                int child = 2 * root + 1;
                if (child + 1 < end && compare[child + lo].compareTo(compare[child + 1 + lo]) < 0) {
                    ++child;
                }
                if (compare[root + lo].compareTo(compare[child + lo]) >= 0) continue block0;
                IxeArray.swap(compare, root + lo, child + lo);
                root = child;
            }
        }
    }

    private static void lex_sort(String[] compare, String[] data, int lo, int hi) {
        int length = hi - lo + 1;
        int start = length / 2;
        int end = length;
        block0: while (end > 1) {
            if (start <= 0) {
                IxeArray.swap(compare, lo, --end + lo);
                IxeArray.swap(data, lo, end + lo);
            }
            int root = --start;
            while (2 * root + 1 < end) {
                int child = 2 * root + 1;
                if (child + 1 < end && compare[child + lo].compareTo(compare[child + 1 + lo]) < 0) {
                    ++child;
                }
                if (compare[root + lo].compareTo(compare[child + lo]) >= 0) continue block0;
                IxeArray.swap(compare, root + lo, child + lo);
                IxeArray.swap(data, root + lo, child + lo);
                root = child;
            }
        }
    }

    private static void num_sort(String[] compare, String[] data, int lo, int hi) {
        int length = hi - lo + 1;
        int start = length / 2;
        int end = length;
        block0: while (end > 1) {
            if (start <= 0) {
                IxeArray.swap(compare, lo, --end + lo);
                IxeArray.swap(data, lo, end + lo);
            }
            int root = --start;
            while (2 * root + 1 < end) {
                int child = 2 * root + 1;
                if (child + 1 < end && Sorter.num_compare(compare[child + lo], compare[child + 1 + lo]) < 0) {
                    ++child;
                }
                if (Sorter.num_compare(compare[root + lo], compare[child + lo]) >= 0) continue block0;
                IxeArray.swap(compare, root + lo, child + lo);
                IxeArray.swap(data, root + lo, child + lo);
                root = child;
            }
        }
    }

    private static void num_sort(String[] compare, int lo, int hi) {
        int length = hi - lo + 1;
        int start = length / 2;
        int end = length;
        block0: while (end > 1) {
            if (start <= 0) {
                IxeArray.swap(compare, lo, --end + lo);
            }
            int root = --start;
            while (2 * root + 1 < end) {
                int child = 2 * root + 1;
                if (child + 1 < end && Sorter.num_compare(compare[child + lo], compare[child + 1 + lo]) < 0) {
                    ++child;
                }
                if (Sorter.num_compare(compare[root + lo], compare[child + lo]) >= 0) continue block0;
                IxeArray.swap(compare, root + lo, child + lo);
                root = child;
            }
        }
    }

    private static int num_compare(String v1, String v2) {
        if (v1.length() == v2.length()) {
            return v1.compareTo(v2);
        }
        return v1.length() > v2.length() ? 1 : -1;
    }

    private static void val_sort(double[] compare1, String[] compare2, String[] data, int lo, int hi) {
        int length = hi - lo + 1;
        int start = length / 2;
        int end = length;
        block0: while (end > 1) {
            if (start <= 0) {
                IxeArray.swap(compare1, lo, --end + lo);
                IxeArray.swap(compare2, lo, end + lo);
                IxeArray.swap(data, lo, end + lo);
            }
            int root = --start;
            while (2 * root + 1 < end) {
                int child = 2 * root + 1;
                if (child + 1 < end && Sorter.val_compare(compare1[child + lo], compare1[child + 1 + lo], compare2[child + lo], compare2[child + 1 + lo]) < 0) {
                    ++child;
                }
                if (Sorter.val_compare(compare1[root + lo], compare1[child + lo], compare2[root + lo], compare2[child + lo]) >= 0) continue block0;
                IxeArray.swap(compare1, root + lo, child + lo);
                IxeArray.swap(compare2, root + lo, child + lo);
                IxeArray.swap(data, root + lo, child + lo);
                root = child;
            }
        }
    }

    private static int val_compare(double d1, double d2, String s1, String s2) {
        if (d1 == d2) {
            return s1.compareTo(s2);
        }
        return d1 < d2 ? -1 : 1;
    }

    public static enum SORT {
        LEXICOGRAPHIC,
        NUMERIC,
        VALUE,
        INVERT,
        SHUFFLE,
        NOSORT;

    }
}

