/*
 * Decompiled with CFR 0.152.
 */
package pkg_ixe;

public class IxeRadix {
    private static StringBuilder builder = new StringBuilder();

    public static double read_double(String number, int radix) throws Exception {
        int digit;
        char c;
        int i;
        if (radix < 2 || radix > 36) {
            throw new Exception("radix out of bounds");
        }
        if (number == null || number.isEmpty()) {
            throw new Exception("number is null");
        }
        double pow = 1.0 / (double)radix;
        double builder = 0.0;
        int fraction_index = number.indexOf(46);
        if (fraction_index == -1) {
            fraction_index = number.length();
        }
        for (i = fraction_index + 1; i < number.length(); ++i) {
            c = number.charAt(i);
            if (!IxeRadix.valid_digit(c, radix)) {
                throw new Exception("not a valid number digit: '" + c + "'");
            }
            digit = IxeRadix.digit(number.charAt(i));
            builder += pow * (double)digit;
            pow /= (double)radix;
        }
        pow = 1.0;
        for (i = fraction_index - 1; i >= 0; --i) {
            c = number.charAt(i);
            if (i == 0 && c == '-') {
                builder = -builder;
                break;
            }
            if (!IxeRadix.valid_digit(c, radix)) {
                throw new Exception("not a valid number digit: '" + c + "'");
            }
            digit = IxeRadix.digit(number.charAt(i));
            builder += pow * (double)digit;
            pow *= (double)radix;
        }
        return builder;
    }

    public static int read(String number) throws Exception {
        return IxeRadix.read(number, 16);
    }

    public static int read(String number, int radix) throws Exception {
        if (radix < 2 || radix > 36) {
            throw new Exception("radix out of bounds");
        }
        if (number == null || number.isEmpty()) {
            throw new Exception("number is null");
        }
        int pow = 1;
        int builder = 0;
        for (int i = number.length() - 1; i >= 0; --i) {
            char c = number.charAt(i);
            if (i == 0 && c == '-') {
                builder = -builder;
                break;
            }
            if (!IxeRadix.valid_digit(c, radix)) {
                throw new Exception("not a valid number digit: '" + c + "'");
            }
            int digit = IxeRadix.digit(number.charAt(i));
            builder += pow * digit;
            pow *= radix;
        }
        return builder;
    }

    public static String write(int number) {
        String write;
        try {
            write = IxeRadix.write(number, 16);
        }
        catch (Exception e) {
            write = "";
        }
        return write;
    }

    public static String write(int number, int radix) throws Exception {
        boolean sign;
        if (radix < 2 || radix > 36) {
            throw new Exception("radix out of bounds");
        }
        if (number == 0) {
            return "0";
        }
        builder.delete(0, builder.length());
        boolean bl = sign = number < 0;
        if (sign) {
            number = -number;
            builder.append('-');
        }
        int max = (int)Math.floor(Math.log(number) / Math.log(radix));
        int pow = (int)Math.pow(radix, max);
        for (int i = 0; i <= max; ++i) {
            int digit = number / pow;
            number %= pow;
            pow /= radix;
            builder.append(IxeRadix.digit(digit));
        }
        return builder.toString();
    }

    private static char digit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    private static int digit(char value) {
        return value <= '9' ? value - 48 : value + 10 - (value <= 'Z' ? 65 : 97);
    }

    public static boolean valid_digit(char digit, int radix) {
        int valid = IxeRadix.digit(digit);
        return valid >= 0 && valid < radix;
    }
}

