/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_graphic.Frame;
import pkg_graphic.Menubar;
import pkg_graphic.ThinButton;
import pkg_ixe.IxeRadix;
import pkg_logic.Sorter;

public class Window
extends Frame {
    private JTextArea area_unsorted = new JTextArea();
    private JTextArea area_sorted = new JTextArea();
    private boolean order = false;
    private boolean replace = false;
    private boolean value_radix = false;
    private JCheckBox box_no_duplicates = new JCheckBox();
    private JCheckBox box_no_empty = new JCheckBox();
    private JCheckBox box_only_sort_col = new JCheckBox();
    private JCheckBox box_append_sorted = new JCheckBox();
    private JCheckBox box_append_unsorted = new JCheckBox();
    private JCheckBox box_ignore_case = new JCheckBox();
    private JCheckBox box_trim_row = new JCheckBox();
    private JCheckBox box_trim_col = new JCheckBox();
    private JLabel line_nb_unsorted = new JLabel("0");
    private JLabel line_nb_sorted = new JLabel("0");
    private JComboBox box_col_split = new JComboBox<String>(new String[]{"NONE", "WHITESPACE", "TAB", "COMMA", "PERIOD", "PUNCTUATION", "DIGIT"});
    private String col_regex = "";
    private JTextField txt_col_regex = new JTextField();
    private JTextField txt_col_selected = new JTextField("0");
    private JLabel lbl_col_selected_indicator = new JLabel("/0");
    private JTextField txt_separator = new JTextField(" ");
    private JCheckBox box_separator = new JCheckBox();
    private JPanel panel_body = new JPanel(new GridLayout(1, 3));
    private JTextField txt_prefix = new JTextField();
    private JTextField txt_suffix = new JTextField();

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.build_controls();
        this.build_areas();
        this.add((Component)this.panel_body, "Center");
        this.build_actions();
        this.setJMenuBar(new Menubar(this));
        this.fullscreen();
        this.setVisible(true);
        this.area_unsorted.requestFocusInWindow();
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    private void build_controls() {
        int label_padding_right = 10;
        int label_align = 4;
        this.box_col_split.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = true;
                switch (Window.this.box_col_split.getSelectedIndex()) {
                    case 0: {
                        Window.this.col_regex = "";
                        enabled = false;
                        break;
                    }
                    case 1: {
                        Window.this.col_regex = "\\s+";
                        break;
                    }
                    case 2: {
                        Window.this.col_regex = "\t";
                        break;
                    }
                    case 3: {
                        Window.this.col_regex = ",";
                        break;
                    }
                    case 4: {
                        Window.this.col_regex = "\\.";
                        break;
                    }
                    case 5: {
                        Window.this.col_regex = "[^A-Za-z0-9_]";
                        break;
                    }
                    case 6: {
                        Window.this.col_regex = "[0-9]";
                    }
                }
                Window.this.txt_col_regex.setText(Window.this.col_regex.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\t", "\\\\t"));
                Window.this.txt_col_selected.setEnabled(enabled);
                Window.this.txt_col_regex.setEnabled(enabled);
                Window.this.box_only_sort_col.setEnabled(enabled);
            }
        });
        this.box_col_split.setSelectedIndex(0);
        final ThinButton btn_order = new ThinButton("Ascendant");
        btn_order.addActionListener(new ActionListener(){
            final /* synthetic */ Window this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.order = !this.this$0.order;
                btn_order.setText(this.this$0.order ? "Descendant" : "Ascendant");
            }
        });
        final ThinButton btn_transfer = new ThinButton("Replace");
        btn_transfer.addActionListener(new ActionListener(){
            final /* synthetic */ Window this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.replace = !this.this$0.replace;
                btn_transfer.setText(this.this$0.replace ? "Concatenate" : "Replace");
            }
        });
        JPanel panel_ctl = new JPanel(new GridLayout(16, 2));
        JLabel lbl_transfer = new JLabel("Transfer", label_align);
        lbl_transfer.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_transfer);
        panel_ctl.add(btn_transfer);
        JLabel lbl_order = new JLabel("Order", label_align);
        lbl_order.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_order);
        panel_ctl.add(btn_order);
        JLabel lbl_case = new JLabel("Ignore letter case", label_align);
        lbl_case.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_case);
        panel_ctl.add(this.box_ignore_case);
        JLabel lbl_duplicate = new JLabel("Remove duplicates", label_align);
        lbl_duplicate.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_duplicate);
        panel_ctl.add(this.box_no_duplicates);
        JLabel lbl_empty = new JLabel("Remove empty rows", label_align);
        lbl_empty.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_empty);
        panel_ctl.add(this.box_no_empty);
        JLabel lbl_split = new JLabel("Split columns", label_align);
        lbl_split.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_split);
        JPanel col_regex_panel = new JPanel(new GridLayout(1, 2));
        col_regex_panel.add(this.box_col_split);
        col_regex_panel.add(this.txt_col_regex);
        panel_ctl.add(col_regex_panel);
        JLabel lbl_colsort = new JLabel("Sort by column", label_align);
        lbl_colsort.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_colsort);
        JPanel col_select_panel = new JPanel(new GridLayout(1, 2));
        col_select_panel.add(this.txt_col_selected);
        col_select_panel.add(this.lbl_col_selected_indicator);
        panel_ctl.add(col_select_panel);
        JLabel lbl_only = new JLabel("Keep only sort column", label_align);
        lbl_only.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_only);
        panel_ctl.add(this.box_only_sort_col);
        JLabel lbl_sorted_separator = new JLabel("Sorted column separator", label_align);
        lbl_sorted_separator.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_sorted_separator);
        this.box_separator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.txt_separator.setEnabled(Window.this.box_separator.isSelected());
            }
        });
        this.box_separator.setSelected(false);
        JPanel panel_separator = new JPanel(new GridLayout(1, 2));
        panel_separator.add(this.box_separator);
        panel_separator.add(this.txt_separator);
        panel_ctl.add(panel_separator);
        JLabel lbl_prefix = new JLabel("Append prefix", label_align);
        lbl_prefix.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_prefix);
        panel_ctl.add(this.txt_prefix);
        JLabel lbl_suffix = new JLabel("Append suffix", label_align);
        lbl_suffix.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_suffix);
        panel_ctl.add(this.txt_suffix);
        JLabel lbl_trim_rows = new JLabel("Trim rows", label_align);
        lbl_trim_rows.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_trim_rows);
        panel_ctl.add(this.box_trim_row);
        JLabel lbl_trim_cols = new JLabel("Trim columns", label_align);
        lbl_trim_cols.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_trim_cols);
        panel_ctl.add(this.box_trim_col);
        JLabel lbl_unsort_index = new JLabel("Append unsorted index", label_align);
        lbl_unsort_index.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_unsort_index);
        panel_ctl.add(this.box_append_unsorted);
        JLabel lbl_sort_index = new JLabel("Append sorted index", label_align);
        lbl_sort_index.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_sort_index);
        panel_ctl.add(this.box_append_sorted);
        JLabel lbl_radix = new JLabel("Value radix", label_align);
        lbl_radix.setBorder(new EmptyBorder(0, 0, 0, label_padding_right));
        panel_ctl.add(lbl_radix);
        final JButton btn_value_radix = new JButton("Decimal");
        btn_value_radix.addActionListener(new ActionListener(){
            final /* synthetic */ Window this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.value_radix = !this.this$0.value_radix;
                btn_value_radix.setText(this.this$0.value_radix ? "Hexadecimal" : "Decimal");
            }
        });
        panel_ctl.add(btn_value_radix);
        JPanel panel_align_top = new JPanel(new BorderLayout());
        panel_align_top.add((Component)panel_ctl, "North");
        this.panel_body.add(panel_align_top);
    }

    private void build_areas() {
        this.area_unsorted.setLineWrap(false);
        this.area_unsorted.setWrapStyleWord(false);
        this.area_sorted.setLineWrap(false);
        this.area_sorted.setWrapStyleWord(false);
        JScrollPane scroller_unsorted = new JScrollPane(this.area_unsorted);
        JScrollPane scroller_sorted = new JScrollPane(this.area_sorted);
        scroller_unsorted.setHorizontalScrollBarPolicy(30);
        scroller_unsorted.setVerticalScrollBarPolicy(22);
        scroller_sorted.setHorizontalScrollBarPolicy(30);
        scroller_sorted.setVerticalScrollBarPolicy(22);
        JPanel panel_unsorted = new JPanel(new BorderLayout());
        JPanel panel_sorted = new JPanel(new BorderLayout());
        panel_unsorted.add((Component)new JLabel("Unsorted", 0), "North");
        panel_unsorted.add((Component)scroller_unsorted, "Center");
        panel_unsorted.add((Component)this.line_nb_unsorted, "South");
        panel_sorted.add((Component)new JLabel("Sorted", 0), "North");
        panel_sorted.add((Component)scroller_sorted, "Center");
        panel_sorted.add((Component)this.line_nb_sorted, "South");
        this.panel_body.add(panel_unsorted);
        this.panel_body.add(panel_sorted);
    }

    private void build_actions() {
        JPanel panel_actions = new JPanel(new GridLayout(1, 5));
        ThinButton btn_sort_lex = new ThinButton("Lexicographic sort");
        ThinButton btn_sort_num = new ThinButton("Numeric sort");
        ThinButton btn_sort_val = new ThinButton("Value sort");
        ThinButton btn_invert = new ThinButton("Invert sort");
        ThinButton btn_shuffle = new ThinButton("Shuffle sort");
        ThinButton btn_nosort = new ThinButton("Nosort");
        btn_sort_lex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.sort(Sorter.SORT.LEXICOGRAPHIC);
            }
        });
        btn_sort_num.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.sort(Sorter.SORT.NUMERIC);
            }
        });
        btn_sort_val.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.sort(Sorter.SORT.VALUE);
            }
        });
        btn_invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.sort(Sorter.SORT.INVERT);
            }
        });
        btn_shuffle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.sort(Sorter.SORT.SHUFFLE);
            }
        });
        btn_nosort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.sort(Sorter.SORT.NOSORT);
            }
        });
        panel_actions.add(btn_sort_lex);
        panel_actions.add(btn_sort_num);
        panel_actions.add(btn_sort_val);
        panel_actions.add(btn_invert);
        panel_actions.add(btn_shuffle);
        panel_actions.add(btn_nosort);
        this.add((Component)panel_actions, "South");
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        this.update_line_nb();
        this.update_column_indicator();
    }

    private void update_column_indicator() {
        int max = 1;
        if (!this.col_regex.isEmpty()) {
            for (String s : this.area_unsorted.getText().split("\n")) {
                String[] split = s.split(this.col_regex);
                if (split.length <= max) continue;
                max = split.length;
            }
        }
        this.lbl_col_selected_indicator.setText("/" + IxeRadix.write(max - 1));
    }

    private void update_line_nb() {
        int i;
        int c;
        String suffix = " rows";
        String t = this.area_unsorted.getText();
        if (t.isEmpty()) {
            c = 0;
        } else {
            c = 1;
            for (i = 0; i < t.length(); ++i) {
                if (t.charAt(i) != '\n') continue;
                ++c;
            }
        }
        this.line_nb_unsorted.setText(IxeRadix.write(c) + suffix);
        t = this.area_sorted.getText();
        if (t.isEmpty()) {
            c = 0;
        } else {
            c = 1;
            for (i = 0; i < t.length(); ++i) {
                if (t.charAt(i) != '\n') continue;
                ++c;
            }
        }
        this.line_nb_sorted.setText(IxeRadix.write(c) + suffix);
    }

    public void sort(Sorter.SORT type) {
        this.sort(type, false);
    }

    public void sort(Sorter.SORT type, boolean override_no_duplicates) {
        int split_index = 0;
        try {
            split_index = IxeRadix.read(this.txt_col_selected.getText());
        }
        catch (Exception e) {
            this.txt_col_selected.setText("0");
        }
        this.txt_col_regex.setText(this.col_regex.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\t", "\\\\t"));
        String split_regex = this.escape(this.txt_col_regex.getText());
        this.area_sorted.setText(Sorter.solve(type, this.area_unsorted.getText(), this.area_sorted.getText(), this.order, this.replace, override_no_duplicates || this.box_no_duplicates.isSelected(), this.box_no_empty.isSelected(), this.box_only_sort_col.isSelected(), this.box_append_sorted.isSelected(), this.box_append_unsorted.isSelected(), this.box_ignore_case.isSelected(), this.box_trim_row.isSelected(), this.box_trim_col.isSelected(), split_index, split_regex, this.box_separator.isSelected(), this.box_separator.isSelected() ? this.escape(this.txt_separator.getText()) : " ", this.value_radix ? 16 : 10, this.txt_prefix.getText(), this.txt_suffix.getText()));
    }

    private String escape(String s) {
        return s.replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r").replaceAll("\\\\b", "\b").replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'").replaceAll("\\\\\\\\", "\\\\");
    }

    public void swap() {
        String swap = this.area_unsorted.getText();
        this.area_unsorted.setText(this.area_sorted.getText());
        this.area_sorted.setText(swap);
    }
}

