/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import pkg_ixe.Ixe;

public class PasswordStrength {
    public static double check(String password) {
        if (password.length() < 6) {
            return 1.0;
        }
        boolean has_lower = false;
        boolean has_upper = false;
        boolean has_digit = false;
        boolean has_special = false;
        int count = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (c >= 'a' && c <= 'z') {
                if (has_lower) continue;
                has_lower = true;
                if (count++ != 4) continue;
                break;
            }
            if (c >= 'A' && c <= 'Z') {
                if (has_upper) continue;
                has_upper = true;
                if (count++ != 4) continue;
                break;
            }
            if (c >= '0' && c <= '9') {
                if (has_digit) continue;
                has_digit = true;
                if (count++ != 4) continue;
                break;
            }
            if (has_special) continue;
            has_special = true;
            if (count++ == 4) break;
        }
        double check = 1.0;
        double probability = (has_lower ? 26 : 0) + (has_upper ? 26 : 0) + (has_digit ? 10 : 0) + (has_special ? 32 : 0);
        char prev_c = '\u0000';
        int prev_diff = Integer.MAX_VALUE;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            int diff = c - prev_c;
            if (prev_c != c && diff != prev_diff) {
                check *= probability;
            }
            prev_c = c;
            prev_diff = diff;
        }
        return Math.log(check) / Math.log(16.0);
    }

    public static String str(double check) {
        return Ixe.rax(check, 16, 2);
    }

    public static String str_check(String output) {
        return PasswordStrength.str(PasswordStrength.check(output));
    }
}

