/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.util.Random;

public class PasswordPattern {
    private static final Random constructor_random = new Random();
    private static final char[][] slip = new char[][]{{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', '`'}, {'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', '\\'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\''}, {'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/'}};
    private static final char[][] slip_alt = new char[][]{{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '~'}, {'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', '|'}, {'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', '\"'}, {'Z', 'X', 'C', 'V', 'B', 'N', 'M', '<', '>', '?'}};
    private static final char[] characters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '2', '4', '6', '8', '1', '3', '5', '7', '9', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~'};
    private static final int[] ascii_offset = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 52, 57, 53, 58, 54, 59, 55, 60, 56, 61, 77, 78, 79, 80, 81, 82, 83, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 84, 85, 86, 87, 88, 89, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 90, 91, 92, 93, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final int NUM_LOWER = 26;
    public static final int NUM_UPPER = 26;
    public static final int NUM_DIGIT = 10;
    public static final int NUM_SPECIAL = 32;
    public static final int CASE_DIST = 32;
    public static final int MAX_CHAR = characters.length;
    private Random random = new Random();
    private Random random_lower = new Random();
    private Random random_upper = new Random();
    private Random random_digit = new Random();
    private Random random_special = new Random();
    private StringBuilder builder_through = new StringBuilder();
    private StringBuilder builder_out = new StringBuilder();
    private int mask_count = 0;
    private int similar_count = 0;
    private final long timestamp;
    private boolean[] masked_character = new boolean[characters.length];
    private boolean[] similar_character = new boolean[characters.length];
    private String name = "";
    private int min_length = 0;
    private double length_balance = 0.5;
    private boolean use_input = true;
    private long seed_offset;
    private boolean use_seed_lower = false;
    private boolean use_seed_upper = false;
    private boolean use_seed_digit = false;
    private boolean use_seed_digit_odd = false;
    private boolean use_seed_digit_even = false;
    private boolean use_seed_special = false;
    private boolean invert_case = false;
    private boolean allow_repeat = true;
    private int offset_upper = 0;
    private int offset_lower = 0;
    private int offset_digit = 0;
    private int offset_special = 0;
    private boolean invert_sequence = false;
    private boolean allow_all_characters_in_input = false;
    private double slipping_factor = 0.0;
    private double lower_rate = 0.5;
    private double upper_rate = 0.5;
    private double digit_rate = 0.5;
    private double special_rate = 0.5;
    private String prefix_str = "";
    private String suffix_str = "";

    public PasswordPattern(long timestamp) {
        this.timestamp = timestamp;
        this.seed_offset = Math.abs(constructor_random.nextLong());
        this.eval();
    }

    public PasswordPattern(long timestamp, String name, int min_length, long seed_offset, int offset_upper, int offset_lower, int offset_digit, int offset_special, boolean use_input, boolean use_seed_lower, boolean use_seed_upper, boolean use_seed_digit, boolean use_seed_digit_odd, boolean use_seed_digit_even, boolean use_seed_special, boolean invert_case, boolean allow_repeat, boolean invert_sequence, boolean allow_all_characters_in_input, boolean[] blocked, boolean[] similar, double slipping_factor, double length_balance, double rate_lower, double rate_upper, double rate_digit, double rate_special, String prefix_str, String suffix_str) {
        this(timestamp);
        this.name = name;
        this.min_length = min_length;
        this.seed_offset = seed_offset;
        this.offset_upper = offset_upper;
        this.offset_lower = offset_lower;
        this.offset_digit = offset_digit;
        this.offset_special = offset_special;
        this.use_input = use_input;
        this.use_seed_lower = use_seed_lower;
        this.use_seed_upper = use_seed_upper;
        this.use_seed_digit = use_seed_digit;
        this.use_seed_digit_odd = use_seed_digit_odd;
        this.use_seed_digit_even = use_seed_digit_even;
        this.use_seed_special = use_seed_special;
        this.invert_case = invert_case;
        this.allow_repeat = allow_repeat;
        this.invert_sequence = invert_sequence;
        this.allow_all_characters_in_input = allow_all_characters_in_input;
        this.slipping_factor = slipping_factor;
        this.length_balance = length_balance;
        this.lower_rate = rate_lower;
        this.upper_rate = rate_upper;
        this.digit_rate = rate_digit;
        this.special_rate = rate_special;
        this.prefix_str = prefix_str;
        this.suffix_str = suffix_str;
        for (int i = 0; i < this.masked_character.length; ++i) {
            this.masked_character[i] = blocked[i];
            this.similar_character[i] = similar[i];
        }
        this.eval();
    }

    public double get_lower_rate() {
        return this.lower_rate;
    }

    public double get_upper_rate() {
        return this.upper_rate;
    }

    public double get_digit_rate() {
        return this.digit_rate;
    }

    public double get_special_rate() {
        return this.special_rate;
    }

    public String get_name() {
        return this.name;
    }

    public void set_name(String name) {
        this.name = name;
    }

    public int get_min_length() {
        return this.min_length;
    }

    public double get_length_balance() {
        return this.length_balance;
    }

    public boolean is_use_input() {
        return this.use_input;
    }

    public long get_seed_offset() {
        return this.seed_offset;
    }

    public boolean is_use_seed_lower() {
        return this.use_seed_lower;
    }

    public boolean is_use_seed_upper() {
        return this.use_seed_upper;
    }

    public boolean is_use_seed_digit() {
        return this.use_seed_digit;
    }

    public boolean is_use_seed_digit_odd() {
        return this.use_seed_digit_odd;
    }

    public boolean is_use_seed_digit_even() {
        return this.use_seed_digit_even;
    }

    public boolean is_use_seed_special() {
        return this.use_seed_special;
    }

    public boolean is_invert_case() {
        return this.invert_case;
    }

    public boolean is_allow_repeat() {
        return this.allow_repeat;
    }

    public int get_offset_upper() {
        return this.offset_upper;
    }

    public int get_offset_lower() {
        return this.offset_lower;
    }

    public int get_offset_digit() {
        return this.offset_digit;
    }

    public int get_offset_special() {
        return this.offset_special;
    }

    public boolean is_invert_sequence() {
        return this.invert_sequence;
    }

    public boolean is_allow_all_characters_in_input() {
        return this.allow_all_characters_in_input;
    }

    public double get_slipping_factor() {
        return this.slipping_factor;
    }

    public long get_timestamp() {
        return this.timestamp;
    }

    public String get_suffix_str() {
        return this.suffix_str;
    }

    public String get_prefix_str() {
        return this.prefix_str;
    }

    public String out(String in) {
        int i;
        char c;
        int i2;
        this.builder_through.delete(0, this.builder_through.length());
        this.builder_out.delete(0, this.builder_out.length());
        long seed = 0L;
        long seed_lower = 0L;
        long seed_upper = 0L;
        long seed_digit = 0L;
        long seed_special = 0L;
        block12: for (i2 = 0; i2 < in.length(); ++i2) {
            c = in.charAt(i2);
            seed += (long)c;
            switch (this.type(c)) {
                case 0: {
                    seed_lower += (long)c;
                    continue block12;
                }
                case 1: {
                    seed_upper += (long)c;
                    continue block12;
                }
                case 2: {
                    seed_digit += (long)c;
                    continue block12;
                }
                case 3: {
                    seed_special += (long)c;
                }
            }
        }
        this.random.setSeed(seed + this.seed_offset);
        this.random_lower.setSeed(seed_lower + this.seed_offset);
        this.random_upper.setSeed(seed_upper + this.seed_offset);
        this.random_digit.setSeed(seed_digit + this.seed_offset);
        this.random_special.setSeed(seed_special + this.seed_offset);
        if (this.use_input && this.allow_all_characters_in_input) {
            this.builder_through.append(in);
        } else if (this.use_input) {
            for (i2 = 0; i2 < in.length(); ++i2) {
                c = in.charAt(i2);
                if (this.random.nextDouble() < this.slipping_factor) {
                    c = this.slip(c);
                }
                int low = 0;
                int range = MAX_CHAR;
                Random rand = null;
                switch (this.type(c)) {
                    case 0: {
                        if (!this.use_seed_lower) break;
                        rand = this.random_lower;
                        low = 0;
                        range = 26;
                        break;
                    }
                    case 1: {
                        if (!this.use_seed_upper) break;
                        rand = this.random_upper;
                        low = 26;
                        range = 26;
                        break;
                    }
                    case 2: {
                        boolean even;
                        boolean bl = even = (c - 48) % 2 == 0;
                        if (this.use_seed_digit) {
                            rand = this.random_digit;
                            low = 52;
                            range = 10;
                            break;
                        }
                        if (!even && this.use_seed_digit_odd) {
                            rand = this.random_digit;
                            low = 57;
                            range = 5;
                            break;
                        }
                        if (!even || !this.use_seed_digit_even) break;
                        rand = this.random_digit;
                        low = 52;
                        range = 5;
                        break;
                    }
                    case 3: {
                        if (!this.use_seed_special) break;
                        rand = this.random_special;
                        low = 62;
                        range = 32;
                    }
                }
                if (rand != null) {
                    c = this.allowed_character(rand, low, range);
                }
                this.builder_through.append(c);
            }
        }
        int l = this.min_length - this.builder_through.length() - this.prefix_str.length() - this.suffix_str.length();
        int input_start = this.use_input ? 0 : l;
        int input_length = this.builder_through.length();
        char c_prefix = '\u0000';
        char c_suffix = '\u0000';
        if (this.mask_count < characters.length) {
            for (i = 0; i < l; ++i) {
                char c2;
                char c_compare;
                boolean compare = this.random.nextDouble() < this.length_balance;
                char c3 = c_compare = compare ? c_suffix : c_prefix;
                if (this.mask_count == characters.length - 1 || this.allow_repeat) {
                    c2 = this.allowed_character(this.random, 0, MAX_CHAR);
                } else {
                    while ((c2 = this.allowed_character(this.random, 0, MAX_CHAR)) == c_compare) {
                    }
                }
                if (compare) {
                    this.builder_through.append(c2);
                    c_suffix = c2;
                    continue;
                }
                this.builder_through.insert(0, c2);
                c_prefix = c2;
                ++input_start;
            }
        }
        for (i = 0; i < this.builder_through.length(); ++i) {
            char c4 = this.builder_through.charAt(i);
            if (this.upper(c4)) {
                c4 = characters[(ascii_offset[c4] - ascii_offset[65] + 26 + this.offset_upper) % 26 + ascii_offset[65]];
                if (this.invert_case) {
                    c4 = (char)(c4 + 32);
                }
            } else if (this.lower(c4)) {
                c4 = characters[(ascii_offset[c4] - ascii_offset[97] + 26 + this.offset_lower) % 26 + ascii_offset[97]];
                if (this.invert_case) {
                    c4 = (char)(c4 - 32);
                }
            } else if (this.digit(c4)) {
                c4 = characters[(ascii_offset[c4] - ascii_offset[48] + 10 + this.offset_digit) % 10 + ascii_offset[48]];
            } else if (ascii_offset[c4] >= 0) {
                c4 = characters[(ascii_offset[c4] - ascii_offset[33] + 32 + this.offset_special) % 32 + ascii_offset[33]];
            }
            if (!this.ascii(c4)) continue;
            if (this.similar_character[ascii_offset[c4]]) {
                c4 = this.similar(c4);
            }
            if (this.masked_character[ascii_offset[c4]] && (!this.allow_all_characters_in_input || i < input_start || i >= input_start + input_length)) continue;
            this.builder_out.append(c4);
        }
        if (this.invert_sequence) {
            this.builder_out.reverse();
        }
        return this.prefix_str + this.builder_out.toString() + this.suffix_str;
    }

    private char similar(char c) {
        if (this.similar_count == 0) {
            return c;
        }
        int r = this.similar_count == 1 ? 0 : this.random.nextInt(this.similar_count);
        for (int i = 0; i < this.similar_character.length; ++i) {
            if (!this.similar_character[i]) continue;
            if (r <= 0) {
                return characters[i];
            }
            --r;
        }
        return c;
    }

    private char character(Random random, int min, int max) {
        int count = max - min + 1;
        if (count == 0) {
            return '\u0000';
        }
        int r = count == 1 ? 0 : random.nextInt(count);
        return characters[r + min];
    }

    private char allowed_character(Random random, int min, int range_max) {
        int count_lower = this.count_allowed(Math.max(min, 0), Math.min(min + range_max, 26));
        int count_upper = this.count_allowed(Math.max(min, 26), Math.min(min + range_max, 52));
        int count_digit = this.count_allowed(Math.max(min, 52), Math.min(min + range_max, 62));
        int count_special = this.count_allowed(Math.max(min, 62), Math.min(min + range_max, 94));
        double l = this.lower_rate * (double)count_lower;
        double u = this.upper_rate * (double)count_upper;
        double d = this.digit_rate * (double)count_digit;
        double s = this.special_rate * (double)count_special;
        int select = -1;
        double total = l + u + d + s;
        if (total <= 0.0) {
            return '\u0000';
        }
        double r = random.nextDouble() * total;
        int start = 0;
        int end = 0;
        if (count_lower > 0 && r < l) {
            select = count_lower == 1 ? 0 : random.nextInt(count_lower);
            start = 0;
            end = start + 26;
        } else if (count_upper > 0 && r < l + u) {
            select = count_upper == 1 ? 0 : random.nextInt(count_upper);
            start = 26;
            end = start + 26;
        } else if (count_digit > 0 && r < l + u + d) {
            select = count_digit == 1 ? 0 : random.nextInt(count_digit);
            start = 52;
            end = start + 10;
        } else if (count_special > 0 && r < l + u + d + s) {
            select = count_special == 1 ? 0 : random.nextInt(count_special);
            start = 62;
            end = start + 32;
        }
        start = Math.max(start, min);
        end = Math.min(end, min + range_max);
        for (int i = start; i < end; ++i) {
            if (this.masked_character[i]) continue;
            if (select == 0) {
                return characters[i];
            }
            --select;
        }
        return '\u0000';
    }

    private int count_allowed(int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            if (this.masked_character[i]) continue;
            ++count;
        }
        return count;
    }

    private boolean allowed(char c) {
        if (!this.ascii(c)) {
            return false;
        }
        return !this.masked_character[ascii_offset[c]];
    }

    private int type(char c) {
        int type = this.lower(c) ? 0 : (this.upper(c) ? 1 : (this.digit(c) ? 2 : 3));
        return type;
    }

    private boolean digit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean upper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private boolean lower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private char slip(char c) {
        char[][] a = null;
        for (int i = 0; i < slip.length; ++i) {
            for (int j = 0; j < slip[i].length; ++j) {
                if (c == slip[i][j]) {
                    a = slip;
                } else if (c == slip_alt[i][j]) {
                    a = slip_alt;
                }
                if (a == null) continue;
                int r = (i == 0 ? 0 : 1) + (i == slip.length - 1 ? 0 : 1) + (j == 0 ? 0 : 1) + (j == slip[i].length - 1 ? 0 : 1);
                if (r != 0) {
                    int n = r = r == 1 ? 0 : this.random.nextInt(r);
                    if (i != 0 && r-- == 0) {
                        c = a[i - 1][j < slip[i - 1].length ? j : slip[i - 1].length - 1];
                    } else if (i != slip.length - 1 && r-- == 0) {
                        c = a[i + 1][j < slip[i + 1].length ? j : slip[i + 1].length - 1];
                    } else if (j != 0 && r-- == 0) {
                        c = a[i][j - 1];
                    } else if (j != slip[i].length - 1 && r-- == 0) {
                        c = a[i][j + 1];
                    }
                }
                return c;
            }
        }
        return c;
    }

    public void set(PasswordPattern copy) {
        this.name = copy.name;
        this.min_length = copy.min_length;
        this.seed_offset = copy.seed_offset;
        this.offset_upper = copy.offset_upper;
        this.offset_lower = copy.offset_lower;
        this.offset_digit = copy.offset_digit;
        this.offset_special = copy.offset_special;
        this.use_input = copy.use_input;
        this.use_seed_lower = copy.use_seed_lower;
        this.use_seed_upper = copy.use_seed_upper;
        this.use_seed_digit = copy.use_seed_digit;
        this.use_seed_digit_odd = copy.use_seed_digit_odd;
        this.use_seed_digit_even = copy.use_seed_digit_even;
        this.use_seed_special = copy.use_seed_special;
        this.invert_case = copy.invert_case;
        this.allow_repeat = copy.allow_repeat;
        this.invert_sequence = copy.invert_sequence;
        this.allow_all_characters_in_input = copy.allow_all_characters_in_input;
        this.slipping_factor = copy.slipping_factor;
        this.length_balance = copy.length_balance;
        this.lower_rate = copy.lower_rate;
        this.upper_rate = copy.upper_rate;
        this.digit_rate = copy.digit_rate;
        this.special_rate = copy.special_rate;
        this.prefix_str = copy.prefix_str;
        this.suffix_str = copy.suffix_str;
        for (int i = 0; i < this.masked_character.length; ++i) {
            this.masked_character[i] = copy.masked_character[i];
            this.similar_character[i] = copy.similar_character[i];
        }
    }

    public void set(String name, int min_length, long seed_offset, int offset_upper, int offset_lower, int offset_digit, int offset_special, boolean use_input, boolean use_seed_lower, boolean use_seed_upper, boolean use_seed_digit, boolean use_seed_digit_odd, boolean use_seed_digit_even, boolean use_seed_special, boolean invert_case, boolean allow_repeat, boolean invert_sequence, boolean allow_all_characters_in_input, String blocked, String similar, double slipping_factor, double length_balance, double rate_lower, double rate_upper, double rate_digit, double rate_special, String prefix_str, String suffix_str) {
        char c;
        int i;
        this.name = name;
        this.min_length = min_length;
        this.seed_offset = seed_offset;
        this.offset_upper = offset_upper;
        this.offset_lower = offset_lower;
        this.offset_digit = offset_digit;
        this.offset_special = offset_special;
        this.use_input = use_input;
        this.use_seed_lower = use_seed_lower;
        this.use_seed_upper = use_seed_upper;
        this.use_seed_digit = use_seed_digit;
        this.use_seed_digit_odd = use_seed_digit_odd;
        this.use_seed_digit_even = use_seed_digit_even;
        this.use_seed_special = use_seed_special;
        this.invert_case = invert_case;
        this.allow_repeat = allow_repeat;
        this.invert_sequence = invert_sequence;
        this.allow_all_characters_in_input = allow_all_characters_in_input;
        this.slipping_factor = slipping_factor;
        this.length_balance = length_balance;
        this.lower_rate = rate_lower;
        this.upper_rate = rate_upper;
        this.digit_rate = rate_digit;
        this.special_rate = rate_special;
        this.prefix_str = prefix_str;
        this.suffix_str = suffix_str;
        for (i = 0; i < this.masked_character.length; ++i) {
            this.masked_character[i] = false;
            this.similar_character[i] = false;
        }
        for (i = 0; i < blocked.length(); ++i) {
            c = blocked.charAt(i);
            if (!this.ascii(c)) continue;
            this.masked_character[PasswordPattern.ascii_offset[c]] = true;
        }
        for (i = 0; i < similar.length(); ++i) {
            c = similar.charAt(i);
            if (!this.ascii(c)) continue;
            this.similar_character[PasswordPattern.ascii_offset[c]] = true;
        }
        this.eval();
    }

    private void eval() {
        this.mask_count = 0;
        this.similar_count = 0;
        for (int i = 0; i < this.masked_character.length; ++i) {
            if (this.masked_character[i]) {
                ++this.mask_count;
            }
            if (!this.similar_character[i]) continue;
            ++this.similar_count;
        }
    }

    private boolean ascii(char c) {
        return c < ascii_offset.length && ascii_offset[c] >= 0;
    }

    public String get_blocked() {
        String blocked = "";
        for (int i = 0; i < this.masked_character.length; ++i) {
            if (!this.masked_character[i]) continue;
            blocked = blocked + characters[i];
        }
        return blocked;
    }

    public String get_similar() {
        String str = "";
        for (int i = 0; i < this.similar_character.length; ++i) {
            if (!this.similar_character[i]) continue;
            str = str + characters[i];
        }
        return str;
    }

    public boolean is_masked(int index) {
        return this.masked_character[index];
    }

    public boolean is_similar(int index) {
        return this.similar_character[index];
    }
}

