/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_graphic.DifficultyLabel;
import pkg_layout.Frame;
import pkg_layout.Menubar;
import pkg_layout.PatternEditor;
import pkg_layout.PatternTable;
import pkg_logic.PasswordPattern;

public class Window
extends Frame {
    public JTextField input = new JTextField();
    public PatternTable table;
    public PatternEditor editor = new PatternEditor();
    public DifficultyLabel difficulty = new DifficultyLabel();

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(new Menubar(this));
        this.table = new PatternTable(this);
        this.editor.set_ref_table(this.table);
        JPanel north = new JPanel(new BorderLayout());
        JPanel input_panel = new JPanel(new BorderLayout());
        this.input.setBorder(BorderFactory.createTitledBorder("Query"));
        this.table.setBorder(BorderFactory.createTitledBorder("Pattern List"));
        this.editor.setBorder(BorderFactory.createTitledBorder("Pattern Editor"));
        JPanel panel_grid = new JPanel(new GridLayout(2, 1));
        input_panel.add((Component)this.input, "Center");
        input_panel.add((Component)this.difficulty, "East");
        north.add((Component)input_panel, "North");
        north.add((Component)this.table, "Center");
        panel_grid.add(north);
        panel_grid.add(this.editor);
        this.input();
        this.add((Component)panel_grid, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }
        });
        this.auto();
        this.fullscreen();
        this.setVisible(true);
    }

    private void input() {
        this.input.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                Window.this.update_input();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Window.this.update_input();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Window.this.update_input();
            }
        });
    }

    private void update_input() {
        this.table.update_input();
        this.difficulty.set(this.input.getText());
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        this.editor.update();
    }

    @Override
    public void new_file() {
    }

    @Override
    public void save(File file) {
        if (file == null) {
            return;
        }
        boolean success = this.write(file, this.table.get_data());
        if (success) {
            this.file = file;
        }
    }

    @Override
    public void load(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return;
        }
        ArrayList<PasswordPattern> data = this.read(file);
        if (data != null) {
            this.table.set_data(data);
            this.file = file;
        }
    }
}

