/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import pkg_ixe.IxeSys;
import pkg_ixe.IxeTime;
import pkg_layout.PatternModel;
import pkg_layout.Window;
import pkg_logic.PasswordPattern;

public class PatternTable
extends JPanel {
    private PatternModel table_model;
    private JTable table;
    private JPopupMenu popup = new JPopupMenu();
    private int min_col_width = 80;
    private int max_col_width = 200;
    private int[] column_size = new int[]{120, 80, 50, 100, Integer.MAX_VALUE};
    private Window window;

    public PatternTable(final Window window) {
        this.setLayout(new BorderLayout());
        this.window = window;
        this.table_model = new PatternModel();
        this.table = new JTable(this.table_model);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(3);
        this.table.setAutoCreateRowSorter(true);
        ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
        DefaultRowSorter sorter = (DefaultRowSorter)this.table.getRowSorter();
        sorter.setSortsOnUpdates(true);
        list.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
        sorter.setSortKeys(list);
        sorter.sort();
        DefaultTableCellRenderer align_center_renderer_renderer = new DefaultTableCellRenderer();
        align_center_renderer_renderer.setHorizontalAlignment(0);
        JTextField password_selector = new JTextField();
        password_selector.setEditable(false);
        DefaultCellEditor password_editor = new DefaultCellEditor(password_selector);
        TableColumn column = null;
        for (int i = 0; i < this.table_model.col_nb; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            if (i != 4) {
                column.setCellRenderer(align_center_renderer_renderer);
            } else if (i == 4) {
                column.setCellEditor(password_editor);
            }
            column.setPreferredWidth(this.column_size[i]);
            column.setMinWidth(i == 0 ? this.column_size[i] : Math.min(this.min_col_width, this.column_size[i]));
            column.setMaxWidth(Math.max(this.max_col_width, this.column_size[i]));
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ PatternTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PasswordPattern x = null;
                int index = this.this$0.table.getSelectedRow();
                if (index >= 0) {
                    x = this.this$0.table_model.get_at(this.this$0.table.convertRowIndexToView(index));
                }
                window.editor.set(x);
            }
        });
        this.popup();
        JScrollPane scroller = new JScrollPane(this.table, 20, 30);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scroller, "Center");
        this.table_model.ref(window.input, window.editor);
    }

    private void popup() {
        JMenuItem popup_add = new JMenuItem("Add pattern");
        final JMenuItem popup_copy = new JMenuItem("Copy pattern");
        final JMenuItem popup_pastebin = new JMenuItem("Copy output to pastebin");
        final JMenuItem popup_delete = new JMenuItem("Delete pattern");
        final JMenuItem popup_delete_all = new JMenuItem("Delete all");
        popup_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternTable.this.add_row();
            }
        });
        popup_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternTable.this.copy_row();
            }
        });
        popup_pastebin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PatternTable.this.table.getSelectedRow();
                if (index >= 0) {
                    IxeSys.copy_to_clipboard((String)PatternTable.this.table_model.getValueAt(PatternTable.this.table.convertRowIndexToView(index), 4));
                }
            }
        });
        popup_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternTable.this.delete_row(PatternTable.this.table.getSelectedRow());
            }
        });
        popup_delete_all.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternTable.this.delete_all();
            }
        });
        this.popup.add(popup_add);
        this.popup.add(popup_copy);
        this.popup.addSeparator();
        this.popup.add(popup_pastebin);
        this.popup.addSeparator();
        this.popup.add(popup_delete);
        this.popup.add(popup_delete_all);
        this.table.setComponentPopupMenu(this.popup);
        this.popup.addPopupMenuListener(new PopupMenuListener(){
            final /* synthetic */ PatternTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean has_selection;
                        int rowAtPoint = this$0.table.rowAtPoint(SwingUtilities.convertPoint(this$0.popup, new Point(0, 0), this$0.table));
                        boolean bl = has_selection = rowAtPoint > -1;
                        if (has_selection) {
                            this$0.table.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                        }
                        popup_copy.setEnabled(has_selection);
                        popup_pastebin.setEnabled(has_selection);
                        popup_delete.setEnabled(has_selection);
                        popup_delete_all.setEnabled(!this$0.table_model.get_data().isEmpty());
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void add_row() {
        this.table_model.addRow(new PasswordPattern(IxeTime.timestamp()));
        int index = this.table.convertRowIndexToView(this.table_model.get_data().size() - 1);
        this.table.setRowSelectionInterval(index, index);
    }

    public void copy_row() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            index = this.table.convertRowIndexToView(index);
            this.table_model.copy(index);
            this.table.setRowSelectionInterval(index, index);
        }
    }

    public void delete_row(int index) {
        if (index >= 0) {
            index = this.table.convertRowIndexToView(index);
            this.table_model.delete(index);
            this.table_model.fireTableDataChanged();
            if (index > 0) {
                --index;
            }
            if (index < this.table_model.get_data().size()) {
                this.table.setRowSelectionInterval(index, index);
            }
        }
    }

    public void delete(PasswordPattern p) {
        this.table_model.get_data().remove(p);
        this.table_model.fireTableDataChanged();
    }

    public void delete_all() {
        this.table_model.get_data().clear();
        this.table_model.fireTableDataChanged();
    }

    public void update_input() {
        if (this.table_model.get_data().isEmpty()) {
            return;
        }
        this.table_model.fireTableRowsUpdated(0, this.table_model.get_data().size() - 1);
    }

    public ArrayList<PasswordPattern> get_data() {
        return this.table_model.get_data();
    }

    public void set_data(ArrayList<PasswordPattern> data) {
        this.table_model.get_data().clear();
        this.table_model.get_data().addAll(data);
        this.table_model.fireTableDataChanged();
    }
}

