/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import pkg_ixe.Ixe;
import pkg_ixe.IxeTime;
import pkg_layout.PatternEditor;
import pkg_logic.PasswordPattern;
import pkg_logic.PasswordStrength;

public class PatternModel
extends AbstractTableModel {
    private String[] columns = new String[]{"Timestamp", "Strength", "Length", "Name", "Output"};
    private Object[] classes = new Object[]{new String(""), new String(""), new String(""), new String(""), new String("")};
    public int col_nb = this.columns.length;
    private boolean[] editable = new boolean[]{false, false, false, false, true};
    private ArrayList<PasswordPattern> data = new ArrayList();
    private PatternEditor editor = null;
    private JTextField input;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.data.size() || this.editor == null || this.input == null) {
            return null;
        }
        String value = null;
        PasswordPattern x = this.data.get(row);
        String output = x.out(this.input.getText());
        switch (column) {
            case 0: {
                value = IxeTime.str(x.get_timestamp());
                break;
            }
            case 1: {
                value = PasswordStrength.str_check(output);
                break;
            }
            case 2: {
                value = Ixe.rax(output.length());
                break;
            }
            case 3: {
                value = x.get_name();
                break;
            }
            case 4: {
                value = output;
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column >= 0 && column < this.editable.length && this.editable[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex].getClass();
    }

    public void addRow(PasswordPattern row) {
        this.data.add(row);
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public void delete(int index) {
        if (index >= 0 && index < this.data.size()) {
            this.data.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void delete_all() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public ArrayList<PasswordPattern> get_data() {
        return this.data;
    }

    public PasswordPattern get_at(int index) {
        if (index >= 0 && index < this.data.size()) {
            return this.data.get(index);
        }
        return null;
    }

    public void ref(JTextField input, PatternEditor editor) {
        this.input = input;
        this.editor = editor;
    }

    public void copy(int index) {
        PasswordPattern p = new PasswordPattern(IxeTime.timestamp());
        p.set(this.data.get(index));
        this.data.add(index, p);
        this.fireTableRowsInserted(index, index);
    }
}

