/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import pkg_graphic.DifficultyLabel;
import pkg_ixe.Ixe;
import pkg_ixe.IxeTime;
import pkg_layout.PatternTable;
import pkg_logic.PasswordPattern;

public class PatternEditor
extends JPanel {
    public boolean request_update = false;
    private final int MAX_MIN_LENGTH = 100;
    boolean sampler_override = false;
    private static final int SLIDER_MAX = 255;
    private int text_width = 70;
    private int text_height = 24;
    public Dimension text_dimension = new Dimension(this.text_width, this.text_height);
    public Dimension slider_dimension = new Dimension(this.text_width, this.text_height);
    private int sampler_nb = 10;
    SamplerText[] sampler_inputs = new SamplerText[this.sampler_nb];
    JLabel[] sampler_outputs = new JLabel[this.sampler_nb];
    DifficultyLabel[] sampler_difficulty = new DifficultyLabel[this.sampler_nb];
    private ItemListener item_listener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            PatternEditor.this.update_sampler();
        }
    };
    private DocumentListener document_listener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            PatternEditor.this.update_sampler();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PatternEditor.this.update_sampler();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PatternEditor.this.update_sampler();
        }
    };
    private JTextArea g_name = new JTextArea();
    private PatternText g_min_length = new PatternText();
    private PatternText g_seed_offset = new PatternText();
    private PatternCheckbox g_use_input = new PatternCheckbox();
    private PatternCheckbox g_use_seed_lower = new PatternCheckbox();
    private PatternCheckbox g_use_seed_upper = new PatternCheckbox();
    private PatternCheckbox g_use_seed_digit = new PatternCheckbox();
    private PatternCheckbox g_use_seed_digit_odd = new PatternCheckbox();
    private PatternCheckbox g_use_seed_digit_even = new PatternCheckbox();
    private PatternCheckbox g_use_seed_special = new PatternCheckbox();
    private PatternCheckbox g_invert_case = new PatternCheckbox();
    private PatternCheckbox g_allow_repeat = new PatternCheckbox();
    private PatternCheckbox g_invert_sequence = new PatternCheckbox();
    private PatternCheckbox g_allow_all_characters_in_input = new PatternCheckbox();
    private PatternText g_offset_upper = new PatternText();
    private PatternText g_offset_lower = new PatternText();
    private PatternText g_offset_digit = new PatternText();
    private PatternText g_offset_special = new PatternText();
    private JLabel g_timestamp = new JLabel("", 2);
    private PatternSlider g_slipping_factor = new PatternSlider(0.0);
    private PatternSlider g_length_balance = new PatternSlider(0.5);
    private PatternSlider g_rate_lower = new PatternSlider(1.0);
    private PatternSlider g_rate_upper = new PatternSlider(1.0);
    private PatternSlider g_rate_special = new PatternSlider(1.0);
    private PatternSlider g_rate_digit = new PatternSlider(1.0);
    private JButton btn_save = new JButton("Save");
    private JButton btn_delete = new JButton("Delete");
    private JButton btn_reset = new JButton("Reset");
    private SamplerText g_blocked_characters = new SamplerText();
    private SamplerText g_similar_characters = new SamplerText();
    private SamplerText g_prefix_str = new SamplerText();
    private SamplerText g_suffix_str = new SamplerText();
    private PasswordPattern pattern = null;
    private PasswordPattern sampler = new PasswordPattern(0L);
    private PatternTable ref_table = null;

    public PatternEditor() {
        super(new BorderLayout());
        JPanel grid = new JPanel(new BorderLayout());
        JPanel west = new JPanel(new BorderLayout());
        west.add((Component)this.make_info(), "North");
        west.add((Component)this.make_sampler(), "Center");
        grid.add((Component)west, "Center");
        grid.add((Component)this.make_options(), "East");
        this.add((Component)grid, "Center");
        this.listeners();
        this.set(null);
    }

    private JPanel make_info() {
        JPanel info = new JPanel(new GridLayout(3, 1));
        JPanel pnl_name = new JPanel(new BorderLayout());
        JPanel pnl_timestamp = new JPanel(new BorderLayout());
        JPanel pnl_button = new JPanel(new GridLayout(1, 3));
        JLabel lbl_name = new JLabel("Name", 0);
        lbl_name.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        pnl_name.add((Component)lbl_name, "West");
        this.g_name.setPreferredSize(this.text_dimension);
        this.g_name.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        pnl_name.add((Component)this.g_name, "Center");
        JLabel lbl_timestamp = new JLabel("Timestamp");
        lbl_timestamp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        pnl_timestamp.add((Component)lbl_timestamp, "West");
        pnl_timestamp.add((Component)this.g_timestamp, "Center");
        pnl_button.add(this.btn_delete);
        pnl_button.add(this.btn_reset);
        pnl_button.add(this.btn_save);
        info.add(pnl_name);
        info.add(pnl_timestamp);
        info.add(pnl_button);
        JPanel west = new JPanel(new BorderLayout());
        west.add((Component)info, "West");
        return west;
    }

    public void set_ref_table(PatternTable ref_table) {
        this.ref_table = ref_table;
    }

    private JScrollPane make_sampler() {
        JPanel sampler = new JPanel(new GridLayout(this.sampler_nb, 2));
        for (int i = 0; i < this.sampler_nb; ++i) {
            this.sampler_inputs[i] = new SamplerText();
            this.sampler_outputs[i] = new JLabel();
            this.sampler_difficulty[i] = new DifficultyLabel();
            sampler.add(this.sampler_inputs[i]);
            JPanel border = new JPanel(new BorderLayout());
            border.add((Component)this.sampler_outputs[i], "Center");
            border.add((Component)this.sampler_difficulty[i], "East");
            sampler.add(border);
        }
        JScrollPane pane = new JScrollPane(sampler);
        pane.setBorder(BorderFactory.createTitledBorder("Sampler"));
        return pane;
    }

    private JScrollPane make_options() {
        int row_nb = 20;
        JPanel grid_content = new JPanel(new GridLayout(row_nb, 1));
        JPanel grid_title = new JPanel(new GridLayout(row_nb, 1));
        grid_content.setPreferredSize(new Dimension(this.text_width, (this.text_height + 4) * row_nb));
        int align = 4;
        grid_title.add(new JLabel("Minimum Length", align));
        grid_content.add(this.g_min_length);
        grid_title.add(new JLabel("Length Balance", align));
        grid_content.add(this.slider_panel(this.g_length_balance, "Prefix", "Suffix"));
        grid_title.add(new JLabel("-Rate Lower", align));
        grid_title.add(new JLabel("-Rate Upper", align));
        grid_title.add(new JLabel("-Rate Digit", align));
        grid_title.add(new JLabel("-Rate Special", align));
        grid_content.add(this.slider_panel(this.g_rate_lower, "Low", "High"));
        grid_content.add(this.slider_panel(this.g_rate_upper, "Low", "High"));
        grid_content.add(this.slider_panel(this.g_rate_digit, "Low", "High"));
        grid_content.add(this.slider_panel(this.g_rate_special, "Low", "High"));
        grid_title.add(new JLabel("Seed options", align));
        grid_title.add(new JLabel(""));
        JPanel seed_options = new JPanel();
        this.g_use_seed_lower.setText("Lower Case");
        this.g_use_seed_upper.setText("Upper Case");
        this.g_use_seed_digit.setText("Digit");
        this.g_use_seed_digit_even.setText("Even Digit");
        this.g_use_seed_digit_odd.setText("Odd Digit");
        this.g_use_seed_special.setText("Special Character");
        seed_options.add(this.g_use_seed_lower);
        seed_options.add(this.g_use_seed_upper);
        seed_options.add(this.g_use_seed_special);
        grid_content.add(seed_options);
        JPanel seed_options2 = new JPanel();
        seed_options2.add(this.g_use_seed_digit);
        seed_options2.add(this.g_use_seed_digit_even);
        seed_options2.add(this.g_use_seed_digit_odd);
        grid_content.add(seed_options2);
        grid_title.add(new JLabel("Seed Offset", align));
        grid_content.add(this.g_seed_offset);
        grid_title.add(new JLabel("Input options", align));
        this.g_use_input.setText("Conserve Input");
        this.g_allow_all_characters_in_input.setText("Intact Input");
        JPanel input_options = new JPanel();
        input_options.add(this.g_use_input);
        input_options.add(this.g_allow_all_characters_in_input);
        grid_content.add(input_options);
        grid_title.add(new JLabel("Offset Lower", align));
        grid_content.add(this.g_offset_lower);
        grid_title.add(new JLabel("Offset Upper", align));
        grid_content.add(this.g_offset_upper);
        grid_title.add(new JLabel("Offset Digit", align));
        grid_content.add(this.g_offset_digit);
        grid_title.add(new JLabel("Offset Special", align));
        grid_content.add(this.g_offset_special);
        grid_title.add(new JLabel("Slipping", align));
        grid_content.add(this.slider_panel(this.g_slipping_factor, "Never", "Always"));
        grid_title.add(new JLabel("Output options", align));
        JPanel output_options = new JPanel();
        this.g_invert_case.setText("Invert Case");
        this.g_allow_repeat.setText("Allow Repeats");
        this.g_invert_sequence.setText("Invert");
        output_options.add(this.g_invert_sequence);
        output_options.add(this.g_invert_case);
        output_options.add(this.g_allow_repeat);
        grid_content.add(output_options);
        grid_title.add(new JLabel("Blocked Characters", align));
        grid_content.add(this.g_blocked_characters);
        grid_title.add(new JLabel("Similarity Group", align));
        grid_content.add(this.g_similar_characters);
        grid_title.add(new JLabel("Prefix String", align));
        grid_content.add(this.g_prefix_str);
        grid_title.add(new JLabel("Suffix String", align));
        grid_content.add(this.g_suffix_str);
        JPanel options = new JPanel(new BorderLayout());
        grid_title.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        options.add((Component)grid_title, "West");
        options.add((Component)grid_content, "Center");
        JScrollPane pane = new JScrollPane(options);
        pane.setPreferredSize(new Dimension(475, (this.text_height + 4) * row_nb));
        pane.setBorder(BorderFactory.createTitledBorder("Options"));
        return pane;
    }

    private Component slider_panel(PatternSlider slider, String low_str, String high_str) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(low_str), "West");
        panel.add((Component)slider, "Center");
        panel.add((Component)new JLabel(high_str), "East");
        return panel;
    }

    private void listeners() {
        this.btn_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternEditor.this.save_pattern();
            }
        });
        this.btn_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternEditor.this.delete_pattern();
            }
        });
        this.btn_reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternEditor.this.set(PatternEditor.this.pattern);
            }
        });
    }

    private void save_pattern() {
        if (!this.sampler_override) {
            this.sampler_override = true;
            this.g_min_length.setText(Ixe.rax(this.g_min_length.val_int(0, 100)));
            this.g_seed_offset.setText(Ixe.rax(this.g_seed_offset.val_long()));
            this.g_offset_upper.setText(Ixe.rax(this.g_offset_upper.val_int(-26, 26)));
            this.g_offset_lower.setText(Ixe.rax(this.g_offset_lower.val_int(-26, 26)));
            this.g_offset_digit.setText(Ixe.rax(this.g_offset_digit.val_int(-10, 10)));
            this.g_offset_special.setText(Ixe.rax(this.g_offset_special.val_int(-32, 32)));
            this.sampler_override = false;
        }
        this.update_sampler();
        this.pattern.set(this.sampler);
        this.ref_table.update_input();
    }

    private void delete_pattern() {
        this.ref_table.delete(this.pattern);
    }

    private void update_sampler() {
        if (!this.sampler_override) {
            this.sampler.set(this.g_name.getText(), this.g_min_length.val_int(0, 100), this.g_seed_offset.val_long(), this.g_offset_upper.val_int(-26, 26), this.g_offset_lower.val_int(-26, 26), this.g_offset_digit.val_int(-10, 10), this.g_offset_special.val_int(-32, 32), this.g_use_input.isSelected(), this.g_use_seed_lower.isSelected(), this.g_use_seed_upper.isSelected(), this.g_use_seed_digit.isSelected(), this.g_use_seed_digit_odd.isSelected(), this.g_use_seed_digit_even.isSelected(), this.g_use_seed_special.isSelected(), this.g_invert_case.isSelected(), this.g_allow_repeat.isSelected(), this.g_invert_sequence.isSelected(), this.g_allow_all_characters_in_input.isSelected(), this.g_blocked_characters.getText(), this.g_similar_characters.getText(), (double)this.g_slipping_factor.getValue() / 255.0, (double)this.g_length_balance.getValue() / 255.0, (double)this.g_rate_lower.getValue() / 255.0, (double)this.g_rate_upper.getValue() / 255.0, (double)this.g_rate_digit.getValue() / 255.0, (double)this.g_rate_special.getValue() / 255.0, this.g_prefix_str.getText(), this.g_suffix_str.getText());
            this.update_enabled();
            this.request_update = true;
        }
    }

    private void update_enabled() {
        boolean enable_sliders = this.sampler.get_min_length() > 0;
        this.g_length_balance.setEnabled(enable_sliders);
        this.g_rate_lower.setEnabled(enable_sliders);
        this.g_rate_upper.setEnabled(enable_sliders);
        this.g_rate_digit.setEnabled(enable_sliders);
        this.g_rate_special.setEnabled(enable_sliders);
        this.g_allow_all_characters_in_input.setEnabled(this.g_use_input.isSelected());
    }

    public void update() {
        if (this.request_update) {
            this.evaluate_samples();
            this.request_update = false;
        }
    }

    private void evaluate_samples() {
        for (int i = 0; i < this.sampler_nb; ++i) {
            String input = this.sampler_inputs[i].getText();
            String password = this.sampler.out(input);
            this.sampler_difficulty[i].set(password);
            this.sampler_outputs[i].setText(password);
        }
    }

    public void set(PasswordPattern pattern) {
        this.pattern = pattern;
        boolean visible = this.pattern != null;
        this.setVisible(visible);
        if (visible) {
            this.sampler_override = true;
            this.sampler.set(pattern);
            this.update_enabled();
            this.g_name.setText(pattern.get_name());
            this.g_min_length.setText(Ixe.rax(pattern.get_min_length()));
            this.g_seed_offset.setText(Ixe.rax(pattern.get_seed_offset()));
            this.g_offset_upper.setText(Ixe.rax(pattern.get_offset_upper()));
            this.g_offset_lower.setText(Ixe.rax(pattern.get_offset_lower()));
            this.g_offset_digit.setText(Ixe.rax(pattern.get_offset_digit()));
            this.g_offset_special.setText(Ixe.rax(pattern.get_offset_special()));
            String time_str = "";
            long t = IxeTime.timestamp() / 131072L - pattern.get_timestamp() / 131072L;
            time_str = t == 0L ? "today" : (t < 365L ? Ixe.rax(t) + " days" : Ixe.rax(t / 365L) + " years");
            this.g_timestamp.setText(IxeTime.str(pattern.get_timestamp()) + " (" + time_str + ")");
            this.g_use_input.setSelected(pattern.is_use_input());
            this.g_use_seed_lower.setSelected(pattern.is_use_seed_lower());
            this.g_use_seed_upper.setSelected(pattern.is_use_seed_upper());
            this.g_use_seed_digit.setSelected(pattern.is_use_seed_digit());
            this.g_use_seed_digit_odd.setSelected(pattern.is_use_seed_digit_odd());
            this.g_use_seed_digit_even.setSelected(pattern.is_use_seed_digit_even());
            this.g_use_seed_special.setSelected(pattern.is_use_seed_special());
            this.g_invert_case.setSelected(pattern.is_invert_case());
            this.g_allow_repeat.setSelected(pattern.is_allow_repeat());
            this.g_invert_sequence.setSelected(pattern.is_invert_sequence());
            this.g_allow_all_characters_in_input.setSelected(pattern.is_allow_all_characters_in_input());
            this.g_blocked_characters.setText(pattern.get_blocked());
            this.g_similar_characters.setText(pattern.get_similar());
            this.g_slipping_factor.setValue((int)(pattern.get_slipping_factor() * 255.0));
            this.g_length_balance.setValue((int)(pattern.get_length_balance() * 255.0));
            this.g_rate_lower.setValue((int)(pattern.get_lower_rate() * 255.0));
            this.g_rate_upper.setValue((int)(pattern.get_upper_rate() * 255.0));
            this.g_rate_digit.setValue((int)(pattern.get_digit_rate() * 255.0));
            this.g_rate_special.setValue((int)(pattern.get_special_rate() * 255.0));
            this.g_prefix_str.setText(pattern.get_prefix_str());
            this.g_suffix_str.setText(pattern.get_suffix_str());
            this.sampler_override = false;
            this.evaluate_samples();
        }
    }

    private class SamplerText
    extends JTextField {
        public SamplerText() {
            this.setPreferredSize(PatternEditor.this.text_dimension);
            this.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.getDocument().addDocumentListener(PatternEditor.this.document_listener);
        }
    }

    private class PatternText
    extends JTextField {
        public PatternText() {
            this.setPreferredSize(PatternEditor.this.text_dimension);
            this.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.getDocument().addDocumentListener(PatternEditor.this.document_listener);
        }

        @Override
        protected Document createDefaultModel() {
            return new NumberDocument();
        }

        public long val_long() {
            long val = 0L;
            try {
                val = Long.parseLong(this.getText(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return val;
        }

        private int val_int(int min, int max) {
            int val = 0;
            try {
                val = Integer.parseInt(this.getText(), 16);
                if (val < min) {
                    val = min;
                }
                if (val > max) {
                    val = max;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return val;
        }

        private class NumberDocument
        extends PlainDocument {
            private NumberDocument() {
            }

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                super.insertString(offset, str.replaceAll("[^0-9a-fA-F]+", ""), attr);
            }
        }
    }

    private class PatternCheckbox
    extends JCheckBox {
        public PatternCheckbox() {
            this.addItemListener(PatternEditor.this.item_listener);
        }
    }

    private class PatternSlider
    extends JSlider {
        public PatternSlider(double progress) {
            super(0, 0, 255, (int)(progress * 255.0));
            this.setPreferredSize(PatternEditor.this.slider_dimension);
            this.setPaintLabels(false);
            this.setPaintTicks(false);
            this.addChangeListener(new ChangeListener(){
                final /* synthetic */ PatternSlider this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        this.this$1.PatternEditor.this.update_sampler();
                    }
                }
            });
        }
    }
}

