/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pkg_core.Screen;
import pkg_ixe.IxeDialog;
import pkg_list.ListDecoder;
import pkg_list.ListEncoder;
import pkg_list.ListPage;
import pkg_list.ListVals;
import pkg_list.Lists;
import pkg_logic.PasswordPattern;

public abstract class Frame
extends JFrame {
    protected static final JFileChooser fc = new JFileChooser();
    public boolean request_close = false;
    public boolean request_fullscreen = true;
    protected File file = null;
    protected File auto = null;

    public Frame(String title) {
        this.init_dialog();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame.this.request_close = true;
            }
        });
        this.setSize(Screen.w / 2, Screen.h / 2);
        this.setLocationRelativeTo(null);
        this.setTitle(title);
    }

    private void init_dialog() {
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ".list paginated key-value pairs";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".list");
            }
        });
    }

    protected void auto() {
        this.auto = new File("auto.list");
        if (this.auto.exists() && this.auto.isFile()) {
            this.file = this.auto;
            this.load(false);
        }
    }

    public void set_auto() {
        this.file = this.auto;
        this.save(false);
    }

    public abstract void update();

    protected File select_file(boolean save) {
        int returnVal;
        int n = returnVal = save ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            if (!f.getName().endsWith(".list")) {
                f = new File(f.getPath() + ".list");
                fc.setSelectedFile(f);
            }
            return f;
        }
        return null;
    }

    protected boolean write(File file, ArrayList<PasswordPattern> patterns) {
        try {
            Lists list = new Lists();
            int size = patterns.size();
            StringBuilder names = new StringBuilder();
            long[] timestamp = new long[size];
            int[] min_length = new int[size];
            double[] length_balance = new double[size];
            boolean[] use_input = new boolean[size];
            long[] seed_offset = new long[size];
            boolean[] use_seed_lower = new boolean[size];
            boolean[] use_seed_upper = new boolean[size];
            boolean[] use_seed_digit = new boolean[size];
            boolean[] use_seed_digit_odd = new boolean[size];
            boolean[] use_seed_digit_even = new boolean[size];
            boolean[] use_seed_special = new boolean[size];
            boolean[] invert_case = new boolean[size];
            boolean[] allow_repeat = new boolean[size];
            int[] offset_upper = new int[size];
            int[] offset_lower = new int[size];
            int[] offset_digit = new int[size];
            int[] offset_special = new int[size];
            boolean[] invert_sequence = new boolean[size];
            boolean[] allow_all_characters_in_input = new boolean[size];
            double[] slipping_factor = new double[size];
            boolean[] masked_character = new boolean[PasswordPattern.MAX_CHAR * size];
            boolean[] similar_character = new boolean[PasswordPattern.MAX_CHAR * size];
            double[] rate_lower = new double[size];
            double[] rate_upper = new double[size];
            double[] rate_digit = new double[size];
            double[] rate_special = new double[size];
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            for (int i = 0; i < patterns.size(); ++i) {
                PasswordPattern p = patterns.get(i);
                timestamp[i] = p.get_timestamp();
                names.append(p.get_name()).append('\u0000');
                prefix.append(p.get_prefix_str()).append('\u0000');
                suffix.append(p.get_suffix_str()).append('\u0000');
                min_length[i] = p.get_min_length();
                length_balance[i] = p.get_length_balance();
                use_input[i] = p.is_use_input();
                seed_offset[i] = p.get_seed_offset();
                use_seed_lower[i] = p.is_use_seed_lower();
                use_seed_upper[i] = p.is_use_seed_upper();
                use_seed_digit[i] = p.is_use_seed_digit();
                use_seed_digit_odd[i] = p.is_use_seed_digit_odd();
                use_seed_digit_even[i] = p.is_use_seed_digit_even();
                use_seed_special[i] = p.is_use_seed_special();
                invert_case[i] = p.is_invert_case();
                allow_repeat[i] = p.is_allow_repeat();
                offset_upper[i] = p.get_offset_upper();
                offset_lower[i] = p.get_offset_lower();
                offset_digit[i] = p.get_offset_digit();
                offset_special[i] = p.get_offset_special();
                invert_sequence[i] = p.is_invert_sequence();
                allow_all_characters_in_input[i] = p.is_allow_all_characters_in_input();
                slipping_factor[i] = p.get_slipping_factor();
                for (int j = 0; j < PasswordPattern.MAX_CHAR; ++j) {
                    masked_character[PasswordPattern.MAX_CHAR * i + j] = p.is_masked(j);
                    similar_character[PasswordPattern.MAX_CHAR * i + j] = p.is_similar(j);
                }
                rate_lower[i] = p.get_lower_rate();
                rate_upper[i] = p.get_upper_rate();
                rate_digit[i] = p.get_digit_rate();
                rate_special[i] = p.get_special_rate();
            }
            ListPage page = new ListPage(0L);
            list.add_page(page);
            long inc = 0L;
            page.put(inc++, timestamp);
            page.put(inc++, names.toString());
            page.put(inc++, min_length);
            page.put(inc++, length_balance);
            page.put(inc++, use_input);
            page.put(inc++, seed_offset);
            page.put(inc++, use_seed_lower);
            page.put(inc++, use_seed_upper);
            page.put(inc++, use_seed_digit);
            page.put(inc++, use_seed_digit_odd);
            page.put(inc++, use_seed_digit_even);
            page.put(inc++, use_seed_special);
            page.put(inc++, invert_case);
            page.put(inc++, allow_repeat);
            page.put(inc++, offset_upper);
            page.put(inc++, offset_lower);
            page.put(inc++, offset_digit);
            page.put(inc++, offset_special);
            page.put(inc++, invert_sequence);
            page.put(inc++, allow_all_characters_in_input);
            page.put(inc++, slipping_factor);
            page.put(inc++, masked_character);
            page.put(inc++, similar_character);
            page.put(inc++, rate_lower);
            page.put(inc++, rate_upper);
            page.put(inc++, rate_digit);
            page.put(inc++, rate_special);
            page.put(inc++, prefix.toString());
            page.put(inc++, suffix.toString());
            ListEncoder.open(file, false, list);
        }
        catch (IOException e) {
            IxeDialog.error("! could not save file '" + file + "' !");
            return false;
        }
        return true;
    }

    protected ArrayList<PasswordPattern> read(File file) {
        ArrayList<PasswordPattern> data = new ArrayList<PasswordPattern>();
        try {
            Lists list = ListDecoder.open(file);
            ListPage page = list.get_page(0L);
            if (page == null) {
                throw new Exception("! page not found !");
            }
            long inc = 0L;
            long[] timestamp = ListVals.getLongs(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            String[] names = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            int[] min_length = ListVals.getInts(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            double[] length_balance = ListVals.getDoubles(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_input = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            long[] seed_offset = ListVals.getLongs(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_seed_lower = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_seed_upper = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_seed_digit = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_seed_digit_odd = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_seed_digit_even = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] use_seed_special = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] invert_case = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] allow_repeat = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            int[] offset_upper = ListVals.getInts(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            int[] offset_lower = ListVals.getInts(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            int[] offset_digit = ListVals.getInts(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            int[] offset_special = ListVals.getInts(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] invert_sequence = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] allow_all_characters_in_input = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            double[] slipping_factor = ListVals.getDoubles(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] masked_character = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] similar_character = ListVals.getBooleans(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            double[] rate_lower = ListVals.getDoubles(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            double[] rate_upper = ListVals.getDoubles(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            double[] rate_digit = ListVals.getDoubles(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            double[] rate_special = ListVals.getDoubles(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            String[] prefix = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            String[] suffix = ListVals.getStrings(page.map.get((Object)Long.valueOf((long)inc++)).bytes);
            boolean[] blocked = new boolean[PasswordPattern.MAX_CHAR];
            boolean[] similar = new boolean[PasswordPattern.MAX_CHAR];
            for (int i = 0; i < timestamp.length; ++i) {
                for (int j = 0; j < PasswordPattern.MAX_CHAR; ++j) {
                    blocked[j] = masked_character[i * PasswordPattern.MAX_CHAR + j];
                    similar[j] = similar_character[i * PasswordPattern.MAX_CHAR + j];
                }
                data.add(new PasswordPattern(timestamp[i], names[i], min_length[i], seed_offset[i], offset_upper[i], offset_lower[i], offset_digit[i], offset_special[i], use_input[i], use_seed_lower[i], use_seed_upper[i], use_seed_digit[i], use_seed_digit_odd[i], use_seed_digit_even[i], use_seed_special[i], invert_case[i], allow_repeat[i], invert_sequence[i], allow_all_characters_in_input[i], blocked, similar, slipping_factor[i], length_balance[i], rate_lower[i], rate_upper[i], rate_digit[i], rate_special[i], prefix[i], suffix[i]));
            }
        }
        catch (Exception e) {
            IxeDialog.error("! cannot load '" + file + "' !");
            data = null;
        }
        return data;
    }

    public abstract void new_file();

    public void save(boolean change_file) {
        File to_save = this.file;
        if (this.file == null || change_file) {
            to_save = this.select_file(true);
        }
        this.save(to_save);
    }

    public abstract void save(File var1);

    public void load(boolean change_file) {
        File to_load = this.file;
        if (this.file == null || change_file) {
            to_load = this.select_file(false);
        }
        this.load(to_load);
    }

    public abstract void load(File var1);

    public void autosave() {
        if (this.file != null && this.file == this.auto) {
            this.save(false);
        }
    }
}

