/*
 * Decompiled with CFR 0.152.
 */
package pkg_ixe;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class IxeDate {
    public static final LocalDate first_day = LocalDate.of(1992, 3, 20);
    private static final int[] days_in_month = new int[]{31, 31, 31, 32, 31, 31, 28, 31, 31, 26, 31, 31};

    public static int days_in_month(long year, int month) {
        return IxeDate.days_in_month(IxeDate.is_leap_year(year), month);
    }

    public static int days_in_month(boolean leap, int month) {
        int d = days_in_month[month];
        if (month == 0 && leap) {
            ++d;
        }
        return d;
    }

    public static long day_of_time() {
        return IxeDate.day_of_time(LocalDate.now());
    }

    public static long day_of_time(LocalDate day) {
        return first_day.until(day, ChronoUnit.DAYS);
    }

    public static long day_of_time(long year, int month, int day) {
        long day_of_time = 0L;
        boolean sign = year < 0L;
        year = sign ? -year : year;
        int i = 0;
        while ((long)i < year) {
            boolean is_leap = IxeDate.is_leap_year(i);
            long year_length = 365 + (is_leap ? 1 : 0);
            day_of_time += year_length;
            ++i;
        }
        for (i = 0; i < month; ++i) {
            day_of_time += (long)IxeDate.days_in_month(year, i);
        }
        return (day_of_time + (long)day) * (long)(sign ? -1 : 1);
    }

    private static boolean is_leap_year(long year) {
        return year % 4L == 0L && year % 100L == 0L && year % 400L != 0L;
    }
}

