/*
 * Decompiled with CFR 0.152.
 */
package pkg_list;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import pkg_ixe.IxeList;

public class ListVal {
    public byte[] bytes;
    public byte type;

    public ListVal(byte[] bytes) {
        this(bytes, 0, 0, bytes.length);
    }

    public ListVal(byte[] bytes, int type) {
        this(bytes, (byte)type, 0, bytes.length);
    }

    public ListVal(VALTYPE type, byte[] bytes) {
        this(bytes, (byte)type.ordinal(), 0, bytes.length);
    }

    public ListVal(byte[] bytes, byte type, int offset, int length) {
        this.type = type;
        length = Math.min(length, bytes.length - offset);
        if (length < 0 || offset < 0) {
            return;
        }
        this.bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.bytes[i] = bytes[i + offset];
        }
    }

    public String str() {
        return new String(this.bytes, StandardCharsets.UTF_8);
    }

    public String str(Charset charset) {
        return new String(this.bytes, charset);
    }

    public String toString() {
        return IxeList.hex_str(this.bytes);
    }

    public static enum VALTYPE {
        BYTE,
        BOOL,
        SHORT,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        ASCII,
        UTF8,
        UTF16;

    }
}

