/*
 * Decompiled with CFR 0.152.
 */
package pkg_ixe;

import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import pkg_list.ListVal;
import pkg_list.ListVals;

public class IxeList {
    private static final String[] type_names = new String[]{"byte", "bool", "short", "int", "float", "long", "double", "ASCII", "UTF-8", "UTF-16"};
    private static StringBuilder content_builder = new StringBuilder();
    private static StringBuilder page_builder = new StringBuilder();

    public static String bool_str(boolean ... bools) {
        content_builder.delete(0, content_builder.length());
        for (int i = 0; i < bools.length; ++i) {
            content_builder.append(bools[i] ? (char)'1' : '0');
        }
        return content_builder.toString();
    }

    public static String hex_str(byte ... bytes) {
        content_builder.delete(0, content_builder.length());
        for (int i = 0; i < bytes.length; ++i) {
            content_builder.append(IxeList.hex((bytes[i] & 0xFF) / 16));
            content_builder.append(IxeList.hex((bytes[i] & 0xFF) % 16));
        }
        return content_builder.toString();
    }

    private static char hex(int h) {
        if (h < 10) {
            return (char)(48 + h);
        }
        return (char)(97 + (h - 10));
    }

    public static char nest_char(byte type) {
        char nest = '\'';
        switch (type) {
            case 0: {
                nest = '\'';
                break;
            }
            case 1: {
                nest = 'b';
                break;
            }
            case 2: {
                nest = 's';
                break;
            }
            case 3: {
                nest = 'i';
                break;
            }
            case 4: {
                nest = 'f';
                break;
            }
            case 5: {
                nest = 'l';
                break;
            }
            case 6: {
                nest = 'd';
                break;
            }
            case 7: {
                nest = '`';
                break;
            }
            case 8: {
                nest = '\"';
                break;
            }
            case 9: {
                nest = '#';
            }
        }
        return nest;
    }

    public static int nest_int(char c) {
        int nest = -1;
        switch (c) {
            case '\'': {
                nest = 0;
                break;
            }
            case 'b': {
                nest = 1;
                break;
            }
            case 's': {
                nest = 2;
                break;
            }
            case 'i': {
                nest = 3;
                break;
            }
            case 'f': {
                nest = 4;
                break;
            }
            case 'l': {
                nest = 5;
                break;
            }
            case 'd': {
                nest = 6;
                break;
            }
            case '`': {
                nest = 7;
                break;
            }
            case '\"': {
                nest = 8;
                break;
            }
            case '#': {
                nest = 9;
            }
        }
        return nest;
    }

    public static String content_str(byte[] bytes, byte type) {
        page_builder.delete(0, page_builder.length());
        page_builder.append(IxeList.nest_char(type));
        switch (type) {
            case 0: {
                for (int i = 0; i < bytes.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(IxeList.hex_str(bytes[i]));
                }
                break;
            }
            case 1: {
                boolean[] booleans = ListVals.getBooleans(bytes);
                for (int i = 0; i < booleans.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(IxeList.bool_str(booleans[i]));
                }
                break;
            }
            case 2: {
                short[] shorts = ListVals.getShorts(bytes);
                for (int i = 0; i < shorts.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(shorts[i]);
                }
                break;
            }
            case 3: {
                int[] ints = ListVals.getInts(bytes);
                for (int i = 0; i < ints.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(ints[i]);
                }
                break;
            }
            case 4: {
                float[] floats = ListVals.getFloats(bytes);
                for (int i = 0; i < floats.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(floats[i]);
                }
                break;
            }
            case 5: {
                long[] longs = ListVals.getLongs(bytes);
                for (int i = 0; i < longs.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(longs[i]);
                }
                break;
            }
            case 6: {
                double[] doubles = ListVals.getDoubles(bytes);
                for (int i = 0; i < doubles.length; ++i) {
                    if (i != 0) {
                        page_builder.append(' ');
                    }
                    page_builder.append(doubles[i]);
                }
                break;
            }
            case 7: {
                page_builder.append(ListVals.getString(bytes, StandardCharsets.US_ASCII));
                break;
            }
            case 8: {
                page_builder.append(ListVals.getString(bytes, StandardCharsets.UTF_8));
                break;
            }
            case 9: {
                page_builder.append(ListVals.getString(bytes, StandardCharsets.UTF_16));
            }
        }
        page_builder.append(IxeList.nest_char(type));
        return page_builder.toString();
    }

    public static void parse_page_content(TreeMap<Long, ListVal> map, String content) throws Exception {
        boolean read_key = false;
        boolean read_value = false;
        int at = -1;
        long key = 0L;
        int value_type = -1;
        String value = "";
        int log_entry_count = 0;
        boolean escape_char = false;
        StringBuilder value_builder = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (!read_key && !read_value) {
                if (c >= '0' && c <= '9' || c == '-') {
                    read_key = true;
                    at = i;
                }
            } else if (read_key && !read_value) {
                int type = IxeList.nest_int(c);
                if (type != -1) {
                    read_value = true;
                    value_type = type;
                    try {
                        key = Long.parseLong(content.substring(at, i).trim());
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Cannot parse key as a long at entry " + log_entry_count);
                    }
                    at = i + 1;
                }
            } else if (read_key && read_value) {
                if (escape_char) {
                    escape_char = false;
                    char escaped_char = c;
                    switch (c) {
                        case '\\': {
                            escaped_char = '\\';
                            break;
                        }
                        case 'n': {
                            escaped_char = '\n';
                            break;
                        }
                        case 't': {
                            escaped_char = '\t';
                            break;
                        }
                        case '\"': {
                            escaped_char = '\"';
                            break;
                        }
                        case '`': {
                            escaped_char = '`';
                            break;
                        }
                        case '#': {
                            escaped_char = '#';
                        }
                    }
                    value_builder.append(escaped_char);
                } else if (c == '\\') {
                    escape_char = true;
                } else if (IxeList.nest_int(c) == value_type) {
                    read_key = false;
                    value = value_builder.toString();
                    value_builder.delete(0, value_builder.length());
                } else {
                    value_builder.append(c);
                }
            }
            if (read_key || !read_value) continue;
            byte[] bytes = null;
            try {
                switch (value_type) {
                    case 0: {
                        bytes = ListVals.parseBytes_byte(value);
                        break;
                    }
                    case 1: {
                        bytes = ListVals.parseBytes_boolean(value);
                        break;
                    }
                    case 2: {
                        bytes = ListVals.parseBytes_short(value);
                        break;
                    }
                    case 3: {
                        bytes = ListVals.parseBytes_int(value);
                        break;
                    }
                    case 4: {
                        bytes = ListVals.parseBytes_float(value);
                        break;
                    }
                    case 5: {
                        bytes = ListVals.parseBytes_long(value);
                        break;
                    }
                    case 6: {
                        bytes = ListVals.parseBytes_double(value);
                        break;
                    }
                    case 7: {
                        bytes = ListVals.parseBytes_str(value, StandardCharsets.US_ASCII);
                        break;
                    }
                    case 8: {
                        bytes = ListVals.parseBytes_str(value, StandardCharsets.UTF_8);
                        break;
                    }
                    case 9: {
                        bytes = ListVals.parseBytes_str(value, StandardCharsets.UTF_16);
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new Exception("Cannot parse value as a " + type_names[value_type] + " at key " + key);
            }
            map.put(key, new ListVal(bytes, value_type));
            ++log_entry_count;
            value_type = -1;
            key = 0L;
            value = "";
            read_value = false;
        }
    }
}

