/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumn;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_graphic.BigLabel;
import pkg_graphic.Frame;
import pkg_graphic.Menubar;
import pkg_graphic.RowData;
import pkg_graphic.TableModel;
import pkg_ixe.IxeDialog;
import pkg_ixe.IxeTime;
import pkg_list.ListDecoder;
import pkg_list.ListPage;
import pkg_list.ListVal;
import pkg_list.ListVals;
import pkg_list.Lists;

public class Window
extends Frame {
    private JMenuItem popup_now = new JMenuItem("Now");
    private JMenuItem popup_lap = new JMenuItem("Lap");
    private JMenuItem popup_add = new JMenuItem("Add new row");
    private JMenuItem popup_delete = new JMenuItem("Delete row");
    private TableModel table_model;
    private JTable table;
    private JPopupMenu popup = new JPopupMenu();
    private int min_col_width = 50;
    private int max_col_width = 500;
    private int[] column_size = new int[]{200, 150, 150, 150, 150, 100, 100, 100};
    private BigLabel log = new BigLabel();
    private Menubar menu;

    public Window(String title) {
        super(title);
        IxeDialog.DialogWindow = this;
        this.setLayout(new BorderLayout());
        this.menu = new Menubar(this);
        this.setJMenuBar(this.menu);
        this.table_model = new TableModel();
        this.table = new JTable(this.table_model);
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateRowSorter(true);
        TableColumn column = null;
        for (int i = 0; i < this.table_model.col_nb; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.column_size[i]);
            column.setMaxWidth(this.max_col_width);
            column.setMinWidth(this.min_col_width);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = Window.this.table.getSelectedRow();
                if (index >= 0) {
                    Window.this.update_log(Window.this.table_model.get_log_at(Window.this.table.convertRowIndexToView(index)));
                }
            }
        });
        this.popup();
        JScrollPane scroller = new JScrollPane(this.table, 20, 30);
        this.table.setFillsViewportHeight(true);
        this.add((Component)scroller, "Center");
        JPanel log_panel = new JPanel(new GridLayout(1, 2));
        log_panel.add(this.log);
        log_panel.add(new JLabel());
        JScrollPane scroller_log = new JScrollPane(log_panel, 20, 31);
        this.add((Component)scroller_log, "East");
        this.auto();
        this.fullscreen();
        this.setVisible(true);
    }

    private void update_log(String str) {
        this.log.setText(str);
        this.revalidate();
        this.repaint();
    }

    public void clear_logs() {
        this.table_model.clear_logs();
        this.update_log("");
    }

    private void auto() {
        File f = new File("auto.list");
        if (f.exists() && f.isFile()) {
            try {
                this.file = f;
                this.load_data(ListDecoder.open(this.file));
            }
            catch (IOException e) {
                IxeDialog.error("Cannot load " + this.file + "\n" + e.getMessage());
                this.load_data(null);
            }
        }
    }

    private void popup() {
        this.popup_now.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.cycle_now();
            }
        });
        this.popup_lap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.cycle_lap();
            }
        });
        this.popup_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.cycle_add();
            }
        });
        this.popup_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.cycle_delete();
            }
        });
        this.table.setComponentPopupMenu(this.popup);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int rowAtPoint = Window.this.table.rowAtPoint(SwingUtilities.convertPoint(Window.this.popup, new Point(0, 0), Window.this.table));
                        if (rowAtPoint > -1) {
                            Window.this.table.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                        }
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.update_popup();
    }

    public void cycle_now() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            this.table_model.start(this.table.convertRowIndexToView(index));
            this.revalidate();
            this.repaint();
        } else if (!this.table_model.get_data().isEmpty()) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void cycle_lap() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            String str = this.table_model.lap(this.table.convertRowIndexToView(index));
            this.update_log(str);
        } else if (!this.table_model.get_data().isEmpty()) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void cycle_add() {
        this.table_model.addRow(new Object[]{"Untitled", IxeTime.now(), 4096L, 0L, 0L, true, new ArrayList()});
        this.update_popup();
    }

    public void cycle_delete() {
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            this.table_model.delete(this.table.convertRowIndexToView(index));
            this.update_popup();
        } else if (!this.table_model.get_data().isEmpty()) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void update_popup() {
        this.popup.removeAll();
        if (this.table.getModel().getRowCount() > 0) {
            this.popup.add(this.popup_now);
            this.popup.add(this.popup_lap);
            this.popup.addSeparator();
        }
        this.popup.add(this.popup_add);
        this.popup.add(this.popup_delete);
    }

    private Object[][] make_data(Lists data) throws Exception {
        if (data == null) {
            return null;
        }
        ListVal[] p0 = data.get_page((long)0L).map.values().toArray(new ListVal[0]);
        ListVal[] p1 = data.get_page((long)1L).map.values().toArray(new ListVal[0]);
        ListVal[] p2 = data.get_page((long)2L).map.values().toArray(new ListVal[0]);
        ListVal[] p3 = data.get_page((long)3L).map.values().toArray(new ListVal[0]);
        this.autosave = ListVals.getBooleans(p0[0].bytes)[0];
        if (p1.length != p2.length || p1.length != p3.length) {
            throw new Exception("Invalid data: uneven pages");
        }
        Object[][] o = new Object[p1.length][7];
        for (int i = 0; i < p1.length; ++i) {
            long[] l = ListVals.getLongs(p1[i].bytes);
            long[] l2 = ListVals.getLongs(p3[i].bytes);
            ArrayList<Long> log = new ArrayList<Long>();
            for (int j = 0; j < l2.length; ++j) {
                log.add(l2[j]);
            }
            o[i][0] = p2[i].str();
            o[i][1] = l[0];
            o[i][2] = l[1];
            o[i][3] = l[2];
            o[i][4] = l[3];
            o[i][5] = l[4] == 1L;
            o[i][6] = log;
        }
        return o;
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        this.table_model.update();
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void load_data(Lists data) {
        this.autosave = false;
        try {
            this.table_model.reset(this.make_data(data));
        }
        catch (Exception e) {
            IxeDialog.error(e.getMessage());
            this.table_model.reset(null);
        }
        this.table_model.fireTableDataChanged();
        this.menu.set(this.autosave);
        this.update_popup();
    }

    @Override
    public Lists parse() {
        Lists data = new Lists();
        ListPage p0 = new ListPage(0L);
        ListPage p1 = new ListPage(1L);
        ListPage p2 = new ListPage(2L);
        ListPage p3 = new ListPage(3L);
        data.add_page(p0);
        data.add_page(p1);
        data.add_page(p2);
        data.add_page(p3);
        ArrayList<RowData> rows = this.table_model.get_data();
        int i = 0;
        for (RowData r : rows) {
            byte[] log_bytes;
            p1.map.put(Long.valueOf(i), new ListVal(ListVal.VALTYPE.BYTE, r.get_meta()));
            p2.map.put(Long.valueOf(i), new ListVal(ListVal.VALTYPE.UTF8, ListVals.parseBytes_str((String)r.get(0), StandardCharsets.UTF_8)));
            ArrayList log_data = (ArrayList)r.get(6);
            if (log_data.isEmpty()) {
                log_bytes = ListVals.parseBytes_long(new long[0]);
            } else {
                long[] l = new long[log_data.size()];
                for (int j = 0; j < l.length; ++j) {
                    l[j] = (Long)log_data.get(j);
                }
                log_bytes = ListVals.parseBytes_long(l);
            }
            p3.map.put(Long.valueOf(i), new ListVal(ListVal.VALTYPE.LONG, log_bytes));
            ++i;
        }
        p0.put(0L, new ListVal(ListVal.VALTYPE.BOOL, ListVals.parseBytes_boolean(new boolean[]{this.autosave})));
        return data;
    }
}

