/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import pkg_graphic.RowData;
import pkg_ixe.IxeTime;

public class TableModel
extends AbstractTableModel {
    private String[] columns = new String[]{"Name", "Start", "Running", "Remaining", "Time", "Group", "Priority", "Enable log"};
    private Object[] classes = new Object[]{new String(""), new String(""), new String(""), new String(""), new String(""), new Long(0L), new Long(0L), new Boolean(false)};
    public int col_nb = this.columns.length;
    private boolean[] editable = new boolean[]{true, true, false, false, true, true, true, true};
    private ArrayList<RowData> data = new ArrayList();

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                value = this.data.get(rowIndex).get(0);
                break;
            }
            case 1: {
                value = IxeTime.str_major_raw((Long)this.data.get(rowIndex).get(1));
                break;
            }
            case 2: {
                long running = IxeTime.now() - (Long)this.data.get(rowIndex).get(1);
                if (running < 0L) {
                    running = 0L;
                }
                value = IxeTime.str_major(running);
                break;
            }
            case 3: {
                long remaining = (Long)this.data.get(rowIndex).get(2) - (IxeTime.now() - (Long)this.data.get(rowIndex).get(1));
                if (remaining < 0L) {
                    remaining = 0L;
                }
                value = IxeTime.str_major(remaining);
                break;
            }
            case 4: {
                value = IxeTime.str_major_raw((Long)this.data.get(rowIndex).get(2));
                break;
            }
            case 5: {
                value = this.data.get(rowIndex).get(3);
                break;
            }
            case 6: {
                value = this.data.get(rowIndex).get(4);
                break;
            }
            case 7: {
                value = this.data.get(rowIndex).get(5);
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.data.get(rowIndex).set(0, value);
                break;
            }
            case 1: {
                long start = (Long)this.data.get(rowIndex).get(1);
                try {
                    start = IxeTime.parse((String)value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.data.get(rowIndex).set(1, start);
                break;
            }
            case 4: {
                long time = (Long)this.data.get(rowIndex).get(2);
                try {
                    time = IxeTime.parse((String)value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.data.get(rowIndex).set(2, time);
                break;
            }
            case 5: {
                this.data.get(rowIndex).set(3, value);
                break;
            }
            case 6: {
                this.data.get(rowIndex).set(4, value);
                break;
            }
            case 7: {
                this.data.get(rowIndex).set(5, value);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column >= 0 && column < this.editable.length && this.editable[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex].getClass();
    }

    public void reset(Object[][] data) {
        this.data.clear();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                this.data.add(new RowData(data[i]));
            }
        }
    }

    public void addRow(Object[] row) {
        this.data.add(new RowData(row));
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public void delete(int index) {
        if (index >= 0 && index < this.data.size()) {
            this.data.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void start(int index) {
        if (index >= 0 && index < this.data.size()) {
            long now = IxeTime.now();
            this.data.get(index).set(1, now);
        }
    }

    public String lap(int index) {
        if (index >= 0 && index < this.data.size()) {
            long now = IxeTime.now();
            this.data.get(index).set(1, now);
            if (((Boolean)this.data.get(index).get(5)).booleanValue()) {
                this.data.get(index).log(now);
            }
            return this.data.get(index).log_str();
        }
        return "";
    }

    public ArrayList<RowData> get_data() {
        return this.data;
    }

    public String get_log_at(int index) {
        if (index >= 0 && index < this.data.size()) {
            return this.data.get(index).log_str();
        }
        return "";
    }

    public void clear_logs() {
        for (RowData row : this.data) {
            row.clear_log();
        }
    }

    public void update() {
        for (int i = 0; i < this.data.size(); ++i) {
            this.fireTableCellUpdated(i, 2);
            this.fireTableCellUpdated(i, 3);
        }
    }
}

