/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import pkg_core.HardInfo;
import pkg_graphic.Frame;
import pkg_graphic.Window;

public class Menubar
extends JMenuBar {
    private Frame frame;
    private JCheckBoxMenuItem mi_auto = new JCheckBoxMenuItem("Autosave");
    private boolean override = false;

    public Menubar(Frame frame) {
        this.frame = frame;
        this.gen_file_menu();
        this.gen_window_menu();
        this.gen_option_menu();
        this.gen_cycle_menu();
        this.build_version_label();
    }

    private void gen_file_menu() {
        JMenu menu = new JMenu("File");
        JMenuItem mi_new = new JMenuItem("New");
        JMenuItem mi_save = new JMenuItem("Save");
        JMenuItem mi_save_as = new JMenuItem("Save As...");
        JMenuItem mi_load = new JMenuItem("Load...");
        JMenuItem mi_exit = new JMenuItem("Exit program");
        mi_new.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.create_new_file();
            }
        });
        mi_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.save();
            }
        });
        mi_save_as.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.save_as();
            }
        });
        mi_load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menubar.this.frame.load();
            }
        });
        mi_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Menubar)Menubar.this).frame.request_close = true;
            }
        });
        mi_new.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        mi_save.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        mi_save_as.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        mi_load.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        mi_exit.setAccelerator(KeyStroke.getKeyStroke(27, 128));
        menu.add(mi_new);
        menu.add(mi_save);
        menu.add(mi_save_as);
        menu.add(mi_load);
        menu.addSeparator();
        menu.add(mi_exit);
        this.add(menu);
    }

    private void gen_window_menu() {
        JMenu menu = new JMenu("Window");
        final JCheckBoxMenuItem mi_fullscreen = new JCheckBoxMenuItem("Fullscreen");
        mi_fullscreen.setSelected(HardInfo.FULLSCREEN);
        mi_fullscreen.addActionListener(new ActionListener(){
            final /* synthetic */ Menubar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HardInfo.FULLSCREEN = mi_fullscreen.getState();
                ((Menubar)this.this$0).frame.request_fullscreen = true;
            }
        });
        mi_fullscreen.setAccelerator(KeyStroke.getKeyStroke(122, 128));
        menu.add(mi_fullscreen);
        this.add(menu);
    }

    private void gen_option_menu() {
        JMenu menu = new JMenu("Options");
        this.mi_auto.setSelected(false);
        JMenuItem mi_erase = new JMenuItem("Erase logs");
        this.mi_auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Menubar.this.override) {
                    Menubar.this.frame.toggle_autosave(Menubar.this.mi_auto.getState());
                }
            }
        });
        mi_erase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)Menubar.this.frame).clear_logs();
            }
        });
        menu.add(this.mi_auto);
        menu.addSeparator();
        menu.add(mi_erase);
        this.add(menu);
    }

    private void gen_cycle_menu() {
        JMenu menu = new JMenu("Cycle");
        JMenuItem mi_now = new JMenuItem("Cycle now");
        JMenuItem mi_lap = new JMenuItem("Cycle lap");
        JMenuItem mi_add = new JMenuItem("Add new row");
        JMenuItem mi_remove = new JMenuItem("Delete row");
        mi_now.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)Menubar.this.frame).cycle_now();
            }
        });
        mi_lap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)Menubar.this.frame).cycle_lap();
            }
        });
        mi_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("test");
                ((Window)Menubar.this.frame).cycle_add();
            }
        });
        mi_remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Window)Menubar.this.frame).cycle_delete();
            }
        });
        mi_now.setAccelerator(KeyStroke.getKeyStroke(49, 128));
        mi_lap.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        mi_add.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        mi_remove.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        menu.add(mi_now);
        menu.add(mi_lap);
        menu.addSeparator();
        menu.add(mi_add);
        menu.add(mi_remove);
        this.add(menu);
    }

    private void build_version_label() {
        this.add(Box.createHorizontalGlue());
        JLabel version_lbl = new JLabel("Version 1.2");
        version_lbl.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.add(version_lbl);
    }

    public void set(boolean auto) {
        this.override = true;
        this.mi_auto.setSelected(auto);
        this.override = false;
    }
}

