/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pkg_core.Screen;
import pkg_ixe.IxeDialog;
import pkg_list.ListDecoder;
import pkg_list.ListEncoder;
import pkg_list.Lists;

public abstract class Frame
extends JFrame {
    public boolean request_close = false;
    public boolean request_fullscreen = false;
    private static final JFileChooser fc = new JFileChooser();
    protected File file = null;
    protected boolean autosave = false;

    public Frame(String title) {
        this.init_dialog();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame.this.request_close = true;
            }
        });
        this.setSize(Screen.w / 2, Screen.h / 2);
        this.setLocationRelativeTo(null);
        this.setTitle(title);
    }

    private void init_dialog() {
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ".list paginated key-value pairs";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".list");
            }
        });
    }

    public void save() {
        if (this.file != null) {
            try {
                ListEncoder.open(this.file, false, this.parse());
            }
            catch (Exception e) {
                IxeDialog.error("Cannot save " + this.file + "\n" + e.getMessage());
            }
        } else {
            this.save_as();
        }
    }

    public void save_as() {
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String[] split = file.getName().split("\\.");
            if (!split[split.length - 1].equalsIgnoreCase("list")) {
                file = new File(file.getPath() + ".list");
            }
            try {
                ListEncoder.open(file, false, this.parse());
                this.file = file;
            }
            catch (Exception e) {
                IxeDialog.error("Cannot save " + file + "\n" + e.getMessage());
            }
        }
    }

    public void load() {
        this.autosave();
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.load_data(ListDecoder.open(file));
                this.file = file;
            }
            catch (Exception e) {
                IxeDialog.error("Cannot load " + file + "\n" + e.getMessage());
            }
        }
    }

    public abstract void update();

    public abstract void load_data(Lists var1);

    public abstract Lists parse();

    public void autosave() {
        if (this.file != null && this.autosave) {
            this.save();
        }
    }

    public void toggle_autosave(boolean autosave) {
        this.autosave = autosave;
    }

    public void create_new_file() {
        this.autosave();
        this.load_data(null);
        this.file = null;
    }
}

