/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_ixe.IxeArray;
import pkg_layout.Frame;
import pkg_layout.Menubar;
import pkg_layout.Merge;
import pkg_layout.Output;

public class Window
extends Frame {
    public JTextField query = new JTextField();
    public JTextField replace = new JTextField();
    private ArrayList<Merge> merges = new ArrayList();
    private JPanel panel = new JPanel(new GridBagLayout());
    private GridBagConstraints c = new GridBagConstraints();
    private Output output_combination = new Output();
    private Output output_splice = new Output();
    private JTabbedPane tabs = new JTabbedPane();

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.setJMenuBar(new Menubar(this));
        this.make_tabs();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }
        });
        this.fullscreen();
        this.setVisible(true);
    }

    private void make_tabs() {
        JPanel tab1 = new JPanel(new BorderLayout());
        this.add_merge();
        tab1.add((Component)this.panel, "Center");
        JButton btn_add = new JButton("+");
        JPanel pnl_add = new JPanel(new BorderLayout());
        pnl_add.add((Component)btn_add, "South");
        JPanel pnl_add2 = new JPanel(new GridLayout(2, 1));
        pnl_add2.add(pnl_add);
        tab1.add((Component)pnl_add2, "East");
        JPanel pnl_query = new JPanel(new GridLayout(1, 2));
        this.query.setBorder(BorderFactory.createTitledBorder("Query"));
        this.replace.setBorder(BorderFactory.createTitledBorder("Replace"));
        pnl_query.add(this.query);
        pnl_query.add(this.replace);
        tab1.add((Component)pnl_query, "North");
        btn_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.add_merge();
            }
        });
        JPanel tab2 = new JPanel(new BorderLayout());
        JScrollPane pane2 = new JScrollPane(this.output_combination);
        tab2.add((Component)pane2, "Center");
        JPanel tab3 = new JPanel(new BorderLayout());
        JScrollPane pane3 = new JScrollPane(this.output_splice);
        tab3.add((Component)pane3, "Center");
        this.tabs.addTab("Modules", tab1);
        this.tabs.addTab("Combination Output", tab2);
        this.tabs.addTab("Splice Output", tab3);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Window.this.tabs.getSelectedIndex() == 1) {
                    Window.this.combination_output();
                } else if (Window.this.tabs.getSelectedIndex() == 2) {
                    Window.this.splice_output();
                }
            }
        });
    }

    private void combination_output() {
        for (Merge m : this.merges) {
            m.validate();
        }
        this.output_combination.set(this.merge(0, ""));
    }

    private void splice_output() {
        for (Merge m : this.merges) {
            m.validate();
        }
        this.output_splice.set(this.splice());
    }

    private String splice() {
        String out = "";
        String[][] splits = new String[this.merges.size()][];
        Random[] randoms = new Random[this.merges.size()];
        int[] ranges = new int[this.merges.size()];
        int max_split = 0;
        for (int i = 0; i < this.merges.size(); ++i) {
            Merge m = this.merges.get(i);
            splits[i] = m.get_content().split("\n");
            ranges[i] = splits[i].length;
            if (m.is_sample_max() && ranges[i] > m.get_sample_max()) {
                ranges[i] = m.get_sample_max();
            }
            if (max_split < ranges[i]) {
                max_split = ranges[i];
            }
            randoms[i] = new Random(m.is_seed() ? m.get_seed() : 0L);
            if (!m.is_seed()) continue;
            IxeArray.shuffle(splits[i], randoms[i]);
        }
        for (int j = 0; j < max_split; ++j) {
            for (int i = 0; i < this.merges.size(); ++i) {
                Merge m = this.merges.get(i);
                if (j >= ranges[i]) continue;
                out = m.is_seed() && m.is_noise() ? out + splits[i][randoms[i].nextInt(splits[i].length)] + "\n" : out + splits[i][j] + "\n";
            }
        }
        return out;
    }

    private String merge(int index, String txt) {
        if (index >= this.merges.size()) {
            return txt + "\n";
        }
        Merge m = this.merges.get(index);
        String[] split = m.get_content().split("\n");
        int range = split.length;
        if (m.is_sample_max() && range > m.get_sample_max()) {
            range = m.get_sample_max();
        }
        Random random = new Random(m.is_seed() ? m.get_seed() : 0L);
        String out = "";
        if (m.is_seed() && m.is_noise()) {
            for (int i = 0; i < range; ++i) {
                out = out + this.merge(index + 1, txt + split[random.nextInt(split.length)]);
            }
        } else {
            if (m.is_seed()) {
                IxeArray.shuffle(split, random);
            }
            for (int i = 0; i < range; ++i) {
                out = out + this.merge(index + 1, txt + split[i]);
            }
        }
        return out;
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
    }

    private void add_merge() {
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.gridx = this.merges.size();
        this.c.gridy = 0;
        Merge m = new Merge(this);
        this.merges.add(m);
        this.panel.add((Component)m, this.c);
        this.ref();
        this.revalidate();
        this.repaint();
    }

    public void move_left(int index) {
        if (index < 0 || index > this.merges.size() - 1) {
            return;
        }
        this.merges.get(index).swap(this.merges.get(index - 1));
    }

    public void move_right(int index) {
        if (index < 0 || index > this.merges.size() - 1) {
            return;
        }
        this.merges.get(index).swap(this.merges.get(index + 1));
    }

    public void move_first(int index) {
        if (index < 0 || index > this.merges.size() - 1) {
            return;
        }
        for (int i = index; i >= 1; --i) {
            this.merges.get(i).swap(this.merges.get(i - 1));
        }
    }

    public void move_last(int index) {
        if (index < 0 || index > this.merges.size() - 1) {
            return;
        }
        for (int i = index; i < this.merges.size() - 1; ++i) {
            this.merges.get(i).swap(this.merges.get(i + 1));
        }
    }

    public void copy(int index) {
        if (index < 0 || index > this.merges.size() - 1) {
            return;
        }
        this.add_merge();
        this.merges.get(this.merges.size() - 1).set(this.merges.get(index));
        for (int i = this.merges.size() - 2; i > index; --i) {
            this.merges.get(i).swap(this.merges.get(i + 1));
        }
    }

    public void update_merges(int index) {
        for (int i = index; i < this.merges.size() - 1; ++i) {
            this.merges.get(i).swap(this.merges.get(i + 1));
        }
        Merge last = this.merges.remove(this.merges.size() - 1);
        this.panel.remove(last);
        this.ref();
        this.revalidate();
        this.repaint();
    }

    private void ref() {
        for (int i = 0; i < this.merges.size(); ++i) {
            this.merges.get(i).ref(i, this.merges.size());
        }
    }
}

