/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pkg_layout.LineNumber;

public class Output
extends JPanel {
    private String raw_content = "";
    private String only_unique_content = "";
    private JTextArea content = new JTextArea();
    private LineNumber line_nb = new LineNumber();
    private JCheckBox only_unique = new JCheckBox("Only Unique");

    public Output() {
        this.setLayout(new BorderLayout());
        this.content.setEditable(false);
        this.add((Component)this.line_nb, "West");
        this.add((Component)this.content, "Center");
        JPanel pnl_north = new JPanel(new BorderLayout());
        pnl_north.add((Component)this.only_unique, "East");
        this.add((Component)pnl_north, "North");
        this.only_unique.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Output.this.set();
            }
        });
        this.content.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                Output.this.line_nb.update(Output.this.content.getLineCount());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                Output.this.line_nb.update(Output.this.content.getLineCount());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                Output.this.line_nb.update(Output.this.content.getLineCount());
            }
        });
    }

    public void set(String str) {
        this.raw_content = str;
        this.only_unique_content = "";
        String[] split = str.split("\n");
        for (int i = 0; i < split.length; ++i) {
            String line = split[i].trim();
            if (line.isEmpty()) continue;
            boolean unique = true;
            for (int j = i - 1; j >= 0; --j) {
                if (!split[j].trim().equals(line)) continue;
                unique = false;
                break;
            }
            if (!unique) continue;
            this.only_unique_content = this.only_unique_content + line + "\n";
        }
        this.set();
    }

    private void set() {
        this.content.setText(this.only_unique.isSelected() ? this.only_unique_content : this.raw_content);
    }
}

