/*
 * Decompiled with CFR 0.152.
 */
package pkg_layout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import pkg_graphic.ThinButton;
import pkg_ixe.IxeArray;
import pkg_ixe.IxeConst;
import pkg_layout.LineNumber;
import pkg_layout.Window;

public class Merge
extends JPanel {
    private boolean use_seed;
    private long seed;
    private boolean use_sample_max;
    private int sample_max;
    private JTextArea content = new JTextArea();
    private LineNumber line_nb = new LineNumber();
    private JTextField txt_seed = new JTextField();
    private JTextField txt_sample_max = new JTextField();
    private JCheckBox noise_toggle = new JCheckBox("As Noise");
    private Window window;
    private int index;
    private ThinButton btn_right = new ThinButton("\u2192");
    private ThinButton btn_left = new ThinButton("\u2190");
    private ThinButton btn_last = new ThinButton("\u21e5");
    private ThinButton btn_first = new ThinButton("\u21e4");

    public void set(Merge m) {
        this.content.setText(m.content.getText());
        this.txt_seed.setText(m.txt_seed.getText());
        this.txt_sample_max.setText(m.txt_sample_max.getText());
        this.noise_toggle.setSelected(m.noise_toggle.isSelected());
    }

    public void swap(Merge m) {
        this._swap(this.content, m.content);
        this._swap(this.txt_seed, m.txt_seed);
        this._swap(this.txt_sample_max, m.txt_sample_max);
        boolean temp = this.noise_toggle.isSelected();
        this.noise_toggle.setSelected(m.noise_toggle.isSelected());
        m.noise_toggle.setSelected(temp);
    }

    private void _swap(JTextComponent c1, JTextComponent c2) {
        String temp = c1.getText();
        c1.setText(c2.getText());
        c2.setText(temp);
    }

    public Merge(final Window window) {
        this.setLayout(new BorderLayout());
        this.content.setLineWrap(false);
        this.window = window;
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        JPanel pnl_subnorth = new JPanel(new GridLayout(2, 1));
        JPanel pnl_seed = new JPanel(new GridLayout(1, 3));
        JLabel lbl_seed = new JLabel("Random seed", 2);
        pnl_seed.add(lbl_seed);
        pnl_seed.add(this.txt_seed);
        pnl_seed.add(this.noise_toggle);
        JPanel pnl_sample = new JPanel(new GridLayout(1, 3));
        pnl_sample.add(new JLabel("Max samples", 2));
        pnl_sample.add(this.txt_sample_max);
        pnl_sample.add(new JLabel(""));
        pnl_subnorth.add(pnl_seed);
        pnl_subnorth.add(pnl_sample);
        JPanel pnl_north = new JPanel(new BorderLayout());
        pnl_north.add((Component)pnl_subnorth, "West");
        JPanel pnl_center = new JPanel(new BorderLayout());
        this.content.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                Merge.this.line_nb.update(Merge.this.content.getLineCount());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                Merge.this.line_nb.update(Merge.this.content.getLineCount());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                Merge.this.line_nb.update(Merge.this.content.getLineCount());
            }
        });
        pnl_center.add((Component)this.content, "Center");
        pnl_center.add((Component)this.line_nb, "West");
        JScrollPane pane = new JScrollPane(pnl_center);
        JPanel pnl_south = new JPanel(new GridLayout(1, 3));
        this.btn_right.addActionListener(new ActionListener(){
            final /* synthetic */ Merge this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                window.move_right(this.this$0.index);
            }
        });
        this.btn_left.addActionListener(new ActionListener(){
            final /* synthetic */ Merge this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                window.move_left(this.this$0.index);
            }
        });
        this.btn_last.addActionListener(new ActionListener(){
            final /* synthetic */ Merge this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                window.move_last(this.this$0.index);
            }
        });
        this.btn_first.addActionListener(new ActionListener(){
            final /* synthetic */ Merge this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                window.move_first(this.this$0.index);
            }
        });
        pnl_south.add(this.btn_first);
        pnl_south.add(this.btn_left);
        pnl_south.add(this.btn_right);
        pnl_south.add(this.btn_last);
        this.popup();
        this.add((Component)pnl_north, "North");
        this.add((Component)pane, "Center");
        this.add((Component)pnl_south, "South");
    }

    private void popup() {
        JMenuItem popup_prefix = new JMenuItem("Insert as prefix");
        JMenuItem popup_suffix = new JMenuItem("Insert as suffix");
        JMenuItem popup_trim = new JMenuItem("Trim lines");
        JMenuItem popup_remove_empty = new JMenuItem("Remove empty lines");
        JMenuItem popup_copy = new JMenuItem("Duplicate");
        JMenuItem popup_replace1 = new JMenuItem("Replace all");
        JMenuItem popup_replace2 = new JMenuItem("Replace all (regex)");
        JMenuItem popup_delete = new JMenuItem("Delete");
        JMenuItem popup_sort1 = new JMenuItem("Sort (ascending)");
        JMenuItem popup_sort2 = new JMenuItem("Sort (descending)");
        JMenuItem popup_upper = new JMenuItem("Change case (upper)");
        JMenuItem popup_lower = new JMenuItem("Change case (lower)");
        JMenuItem popup_shuffle = new JMenuItem("Shuffle");
        popup_prefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = ((Merge)Merge.this).window.query.getText();
                Merge.this.content.setText(str + Merge.this.content.getText().replaceAll("\n", "\n" + str));
            }
        });
        popup_suffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = ((Merge)Merge.this).window.query.getText();
                Merge.this.content.setText(Merge.this.content.getText().replaceAll("\n", str + "\n") + str);
            }
        });
        popup_trim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.content.setText(Merge.this.content.getText().replaceAll("(^[ \t]*)|([ \t]*$)", ""));
            }
        });
        popup_remove_empty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.content.setText(Merge.this.content.getText().replaceAll("\n[ \t\n]+", "\n"));
            }
        });
        popup_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.window.copy(Merge.this.index);
            }
        });
        popup_delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.window.update_merges(Merge.this.index);
            }
        });
        popup_sort1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] split = Merge.this.content.getText().split("\n");
                Arrays.sort(split);
                String str = "";
                for (int i = 0; i < split.length; ++i) {
                    str = str + (String)split[i] + "\n";
                }
                Merge.this.content.setText(str);
            }
        });
        popup_sort2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] split = Merge.this.content.getText().split("\n");
                Arrays.sort(split);
                String str = "";
                for (int i = 0; i < split.length; ++i) {
                    str = str + (String)split[split.length - i - 1] + "\n";
                }
                Merge.this.content.setText(str);
            }
        });
        popup_upper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.content.setText(Merge.this.content.getText().toUpperCase());
            }
        });
        popup_lower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.content.setText(Merge.this.content.getText().toLowerCase());
            }
        });
        popup_shuffle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] split = Merge.this.content.getText().split("\n");
                IxeArray.shuffle(split, IxeConst.ixe_RANDOM);
                String str = "";
                for (int i = 0; i < split.length; ++i) {
                    str = str + split[i] + "\n";
                }
                Merge.this.content.setText(str);
            }
        });
        popup_replace1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.content.setText(Merge.this.content.getText().replace(((Merge)Merge.this).window.query.getText(), ((Merge)Merge.this).window.replace.getText()));
            }
        });
        popup_replace2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge.this.content.setText(Merge.this.content.getText().replaceAll(((Merge)Merge.this).window.query.getText(), ((Merge)Merge.this).window.replace.getText()));
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(popup_copy);
        popup.addSeparator();
        popup.add(popup_sort1);
        popup.add(popup_sort2);
        popup.add(popup_shuffle);
        popup.addSeparator();
        popup.add(popup_prefix);
        popup.add(popup_suffix);
        popup.add(popup_upper);
        popup.add(popup_lower);
        popup.add(popup_trim);
        popup.add(popup_remove_empty);
        popup.add(popup_replace1);
        popup.add(popup_replace2);
        popup.addSeparator();
        popup.add(popup_delete);
        this.content.setComponentPopupMenu(popup);
    }

    public String get_content() {
        return this.content.getText();
    }

    public void ref(int index, int size) {
        this.index = index;
        this.btn_first.setEnabled(index > 0);
        this.btn_left.setEnabled(index > 0);
        this.btn_right.setEnabled(index < size - 1);
        this.btn_last.setEnabled(index < size - 1);
    }

    @Override
    public void validate() {
        this.use_seed = false;
        this.seed = 0L;
        if (!this.txt_seed.getText().isEmpty()) {
            try {
                this.seed = Integer.parseInt(this.txt_seed.getText(), 16);
                this.use_seed = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sample_max = -1;
        this.use_sample_max = false;
        if (!this.txt_sample_max.getText().isEmpty()) {
            try {
                this.sample_max = Integer.parseInt(this.txt_sample_max.getText(), 16);
                this.use_sample_max = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean is_seed() {
        return this.use_seed;
    }

    public long get_seed() {
        return this.seed;
    }

    public boolean is_noise() {
        return this.noise_toggle.isSelected();
    }

    public boolean is_sample_max() {
        return this.use_sample_max;
    }

    public int get_sample_max() {
        return this.sample_max;
    }
}

