/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import pkg_graphic.RowData;
import pkg_graphic.Window;
import pkg_ixe.IxeColor;
import pkg_ixe.IxeMath;

public class ImageFinder
implements Runnable {
    boolean cancel;
    boolean skip;
    boolean terminated = false;
    public ArrayList<File> queries = new ArrayList();
    public ArrayList<File> searches = new ArrayList();
    Window window;
    public ArrayList<RowData> out;
    public int search_index;
    boolean[] allowed_chan = new boolean[4];
    int chan_nb;
    int[] allowed_chan_index;
    int match_type;
    boolean flip_v;
    boolean flip_h;
    boolean quarter_rot;

    public ImageFinder(Window window) {
        this.window = window;
        this.out = window.table_ref();
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean pick_terminated() {
        if (this.terminated) {
            this.terminated = false;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.set();
        if (this.chan_nb < 1) {
            return;
        }
        this.search_index = 0;
        this.cancel = false;
        this.skip = false;
        this.terminated = false;
        ArrayList<Object> new_queries = new ArrayList();
        boolean first_search = true;
        ArrayList<File> best_matches = new ArrayList<File>();
        while (!this.queries.isEmpty()) {
            ArrayList<File> temp;
            for (File query : this.queries) {
                if (query == null) continue;
                if (query.isDirectory() && query.listFiles() != null) {
                    new_queries.addAll(Arrays.asList(query.listFiles()));
                } else if (query.isFile()) {
                    RowData row_progress = new RowData(query, null, 0.0);
                    this.out.add(row_progress);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImageFinder.this.window.out();
                        }
                    });
                    BufferedImage img_ref = null;
                    try {
                        img_ref = ImageIO.read(query);
                    }
                    catch (IOException e) {
                        return;
                    }
                    if (img_ref == null) continue;
                    float[][][] w1 = this.img_to_array(img_ref);
                    double best_match = 0.0;
                    best_matches.clear();
                    if (first_search) {
                        ArrayList<File> final_search = new ArrayList<File>();
                        ArrayList<Object> new_search = new ArrayList<File>();
                        while (!this.searches.isEmpty()) {
                            for (File search : this.searches) {
                                if (search == null) continue;
                                if (search.isDirectory() && search.listFiles() != null) {
                                    new_search.addAll(Arrays.asList(search.listFiles()));
                                } else if (search.isFile()) {
                                    final_search.add(search);
                                    this.window.visited_files = final_search.size();
                                    this.window.total_files = final_search.size();
                                    if (query.getAbsolutePath().equalsIgnoreCase(search.getAbsolutePath())) continue;
                                    BufferedImage img_search = null;
                                    try {
                                        img_search = ImageIO.read(search);
                                    }
                                    catch (IOException e) {
                                        return;
                                    }
                                    if (img_search == null) continue;
                                    float[][][] w2 = this.img_to_array(img_search);
                                    double match = this.match(this.match_type, w1, w2, best_match);
                                    if (match > best_match) {
                                        best_match = match;
                                        best_matches.clear();
                                        best_matches.add(search);
                                        row_progress.match = search;
                                        row_progress.fitness = best_match;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                ImageFinder.this.window.out();
                                            }
                                        });
                                    } else if (match > 0.0 && match == best_match) {
                                        best_matches.add(search);
                                    }
                                }
                                if (!this.cancel && !this.skip) continue;
                                this.cancel = true;
                                break;
                            }
                            if (this.cancel || this.skip) {
                                this.cancel = true;
                                break;
                            }
                            temp = this.searches;
                            this.searches = new_search;
                            new_search = temp;
                            new_search.clear();
                        }
                        this.searches = final_search;
                        first_search = false;
                    } else {
                        for (int i = 0; i < this.searches.size(); ++i) {
                            File search = this.searches.get(i);
                            this.window.visited_files = i + 1;
                            if (query.getAbsolutePath().equalsIgnoreCase(search.getAbsolutePath())) continue;
                            BufferedImage img_search = null;
                            try {
                                img_search = ImageIO.read(search);
                            }
                            catch (IOException e) {
                                return;
                            }
                            if (img_search == null) continue;
                            float[][][] w2 = this.img_to_array(img_search);
                            double match = this.match(this.match_type, w1, w2, best_match);
                            if (match > best_match) {
                                best_match = match;
                                best_matches.clear();
                                best_matches.add(search);
                                row_progress.match = search;
                                row_progress.fitness = best_match;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ImageFinder.this.window.out();
                                    }
                                });
                            } else if (match > 0.0 && match == best_match) {
                                best_matches.add(search);
                            }
                            if (this.cancel || this.skip) break;
                        }
                    }
                    this.skip = false;
                    this.out.remove(row_progress);
                    if (!best_matches.isEmpty()) {
                        for (File file : best_matches) {
                            this.out.add(new RowData(query, file, best_match));
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImageFinder.this.window.out();
                            }
                        });
                    }
                }
                if (!this.cancel) continue;
                break;
            }
            temp = this.queries;
            this.queries = new_queries;
            new_queries = temp;
            new_queries.clear();
            if (!this.cancel) continue;
        }
        this.terminated = true;
    }

    private double match(int type, float[][][] w1, float[][][] w2, double min_fitness) {
        double[] fitness = new double[6];
        switch (type) {
            case 0: {
                fitness[0] = this._match_identical(w1, w2, min_fitness);
                if (this.flip_h) {
                    fitness[1] = this._match_identical(w1, w2, min_fitness, false, 1, true, 0, false);
                }
                if (this.flip_v) {
                    fitness[2] = this._match_identical(w1, w2, min_fitness, false, 0, false, 1, true);
                }
                if (this.flip_h && this.flip_v || this.quarter_rot) {
                    fitness[3] = this._match_identical(w1, w2, min_fitness, false, 1, true, 1, true);
                }
                if (!this.quarter_rot) break;
                fitness[4] = this._match_identical(w1, w2, min_fitness, true, 0, false, 1, true);
                fitness[5] = this._match_identical(w1, w2, min_fitness, true, 1, true, 0, false);
                break;
            }
            case 1: {
                fitness[0] = this._match_similarity(w1, w2, min_fitness);
                if (this.flip_h) {
                    fitness[1] = this._match_similarity(w1, w2, min_fitness, false, 1, true, 0, false);
                }
                if (this.flip_v) {
                    fitness[2] = this._match_similarity(w1, w2, min_fitness, false, 0, false, 1, true);
                }
                if (this.flip_h && this.flip_v || this.quarter_rot) {
                    fitness[3] = this._match_similarity(w1, w2, min_fitness, false, 1, true, 1, true);
                }
                if (!this.quarter_rot) break;
                fitness[4] = this._match_similarity(w1, w2, min_fitness, true, 0, false, 1, true);
                fitness[5] = this._match_similarity(w1, w2, min_fitness, true, 1, true, 0, false);
                break;
            }
            case 2: {
                fitness[0] = this._match_scaled(w1, w2, min_fitness);
                if (this.flip_h) {
                    fitness[1] = this._match_scaled(w1, w2, min_fitness, false, 1, true, 0, false);
                }
                if (this.flip_v) {
                    fitness[2] = this._match_scaled(w1, w2, min_fitness, false, 0, false, 1, true);
                }
                if (this.flip_h && this.flip_v || this.quarter_rot) {
                    fitness[3] = this._match_scaled(w1, w2, min_fitness, false, 1, true, 1, true);
                }
                if (!this.quarter_rot) break;
                fitness[4] = this._match_scaled(w1, w2, min_fitness, true, 0, false, 1, true);
                fitness[5] = this._match_scaled(w1, w2, min_fitness, true, 1, true, 0, false);
            }
        }
        return IxeMath.max(fitness);
    }

    private void set() {
        this.queries.clear();
        this.searches.clear();
        this.out.clear();
        if (this.window.files[0] != null) {
            this.queries.addAll(Arrays.asList(this.window.files[0]));
        }
        if (this.window.files[1] != null) {
            this.searches.addAll(Arrays.asList(this.window.files[1]));
        }
        this.match_type = -1;
        if (this.window.btn_exact_match.isSelected()) {
            this.match_type = 0;
        }
        if (this.window.btn_similarity_match.isSelected()) {
            this.match_type = 1;
        }
        if (this.window.btn_stretch_match.isSelected()) {
            this.match_type = 2;
        }
        this.flip_h = this.window.orientation_hflip.isSelected();
        this.flip_v = this.window.orientation_vflip.isSelected();
        this.quarter_rot = this.window.orientation_quarter_rot.isSelected();
        this.allowed_chan[0] = this.window.blue.isSelected();
        this.allowed_chan[1] = this.window.green.isSelected();
        this.allowed_chan[2] = this.window.red.isSelected();
        this.allowed_chan[3] = this.window.alpha.isSelected();
        this.chan_nb = (this.allowed_chan[0] ? 1 : 0) + (this.allowed_chan[1] ? 1 : 0) + (this.allowed_chan[2] ? 1 : 0) + (this.allowed_chan[3] ? 1 : 0);
        this.allowed_chan_index = new int[this.chan_nb];
        int it = 0;
        for (int i = 0; i < this.allowed_chan.length; ++i) {
            if (!this.allowed_chan[i]) continue;
            this.allowed_chan_index[it++] = i;
        }
    }

    private float[][][] img_to_array(BufferedImage img) {
        if (img == null) {
            return null;
        }
        float[][][] a = new float[img.getWidth()][img.getHeight()][this.chan_nb];
        float div = this.match_type == 0 ? 1.0f : 255.0f;
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                int rgb = img.getRGB(i, j);
                for (int k = 0; k < this.chan_nb; ++k) {
                    a[i][j][k] = (float)IxeColor.chan(this.allowed_chan_index[k], rgb) / div;
                }
            }
        }
        return a;
    }

    public void skip() {
        this.skip = true;
    }

    private double _match_scaled(float[][][] w1, float[][][] w2, double min_fitness) {
        int width = Math.max(w1.length, w2.length);
        int height = Math.max(w1[0].length, w2[0].length);
        double match = 0.0;
        double dw1 = (double)w1.length / (double)width;
        double dw2 = (double)w2.length / (double)width;
        double dh1 = (double)w1[0].length / (double)height;
        double dh2 = (double)w2[0].length / (double)height;
        double count = (double)width * (double)height * (double)this.chan_nb;
        for (int i = 0; i < width; ++i) {
            int i1 = (int)(dw1 * (double)i);
            int i2 = (int)(dw2 * (double)i);
            for (int j = 0; j < height; ++j) {
                int j1 = (int)(dh1 * (double)j);
                int j2 = (int)(dh2 * (double)j);
                for (int k = 0; k < this.chan_nb; ++k) {
                    float m = w1[i1][j1][k] - w2[i2][j2][k];
                    match += 1.0 - (double)(m * m);
                }
            }
            if ((match + (double)((width - (i + 1)) * height * this.chan_nb)) / count < min_fitness) break;
        }
        return match / count;
    }

    private double _match_similarity(float[][][] w1, float[][][] w2, double min_fitness) {
        if (w1.length != w2.length || w1[0].length != w2[0].length) {
            return 0.0;
        }
        int width = w1.length;
        int height = w1[0].length;
        double match = 0.0;
        double count = (double)width * (double)height * (double)this.chan_nb;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < this.chan_nb; ++k) {
                    float m = w1[i][j][k] - w2[i][j][k];
                    match += 1.0 - (double)(m * m);
                }
            }
            if ((match + (double)((width - (i + 1)) * height * this.chan_nb)) / count < min_fitness) break;
        }
        return match / count;
    }

    private double _match_identical(float[][][] w1, float[][][] w2, double min_fitness) {
        if (w1.length != w2.length || w1[0].length != w2[0].length) {
            return 0.0;
        }
        int width = w1.length;
        int height = w1[0].length;
        double match = 0.0;
        double count = (double)width * (double)height;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                boolean same = true;
                for (int k = 0; k < this.chan_nb; ++k) {
                    if (w1[i][j][k] == w2[i][j][k]) continue;
                    same = false;
                    break;
                }
                match += same ? 1.0 : 0.0;
            }
            if ((match + (double)((width - (i + 1)) * height)) / count < min_fitness) break;
        }
        return match / count;
    }

    private double _match_scaled(float[][][] w1, float[][][] w2, double min_fitness, boolean invert, int off_x, boolean sign_x, int off_y, boolean sign_y) {
        if (invert && w2.length != w2[0].length) {
            return 0.0;
        }
        int width = Math.max(w1.length, w2.length);
        int height = Math.max(w1[0].length, w2[0].length);
        double match = 0.0;
        double dw1 = (double)w1.length / (double)width;
        double dw2 = (double)w2.length / (double)width;
        double dh1 = (double)w1[0].length / (double)height;
        double dh2 = (double)w2[0].length / (double)height;
        double count = (double)width * (double)height * (double)this.chan_nb;
        for (int i = 0; i < width; ++i) {
            int i1 = (int)(dw1 * (double)i);
            int i2 = (int)(dw2 * (double)i);
            for (int j = 0; j < height; ++j) {
                int j1 = (int)(dh1 * (double)j);
                int j2 = (int)(dh2 * (double)j);
                int x = (w2.length - 1) * off_x + (sign_x ? -1 : 1) * (invert ? j2 : i2);
                int y = (w2[0].length - 1) * off_y + (sign_y ? -1 : 1) * (invert ? i2 : j2);
                for (int k = 0; k < this.chan_nb; ++k) {
                    float m = w1[i1][j1][k] - w2[x][y][k];
                    match += 1.0 - (double)(m * m);
                }
            }
            if ((match + (double)((width - (i + 1)) * height * this.chan_nb)) / count < min_fitness) break;
        }
        return match / count;
    }

    private double _match_similarity(float[][][] w1, float[][][] w2, double min_fitness, boolean invert, int off_x, boolean sign_x, int off_y, boolean sign_y) {
        if (w1.length != w2.length || w1[0].length != w2[0].length || invert && w2.length != w2[0].length) {
            return 0.0;
        }
        int width = w1.length;
        int height = w1[0].length;
        double match = 0.0;
        double count = (double)width * (double)height * (double)this.chan_nb;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int x = (w2.length - 1) * off_x + (sign_x ? -1 : 1) * (invert ? j : i);
                int y = (w2[0].length - 1) * off_y + (sign_y ? -1 : 1) * (invert ? i : j);
                for (int k = 0; k < this.chan_nb; ++k) {
                    float m = w1[i][j][k] - w2[x][y][k];
                    match += 1.0 - (double)(m * m);
                }
            }
            if ((match + (double)((width - (i + 1)) * height * this.chan_nb)) / count < min_fitness) break;
        }
        return match / count;
    }

    private double _match_identical(float[][][] w1, float[][][] w2, double min_fitness, boolean invert, int off_x, boolean sign_x, int off_y, boolean sign_y) {
        if (w1.length != w2.length || w1[0].length != w2[0].length || invert && w2.length != w2[0].length) {
            return 0.0;
        }
        int width = w1.length;
        int height = w1[0].length;
        double match = 0.0;
        double count = (double)width * (double)height;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                boolean same = true;
                int x = (w2.length - 1) * off_x + (sign_x ? -1 : 1) * (invert ? j : i);
                int y = (w2[0].length - 1) * off_y + (sign_y ? -1 : 1) * (invert ? i : j);
                for (int k = 0; k < this.chan_nb; ++k) {
                    if (w1[i][j][k] == w2[x][y][k]) continue;
                    same = false;
                    break;
                }
                match += same ? 1.0 : 0.0;
            }
            if ((match + (double)((width - (i + 1)) * height)) / count < min_fitness) break;
        }
        return match / count;
    }
}

