/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_graphic.Frame;
import pkg_graphic.Menubar;
import pkg_graphic.RowData;
import pkg_graphic.TableModel;
import pkg_ixe.Ixe;

public class Window
extends Frame {
    protected static final JFileChooser fc = new JFileChooser();
    public boolean request_image_finder_run = false;
    public boolean request_image_finder_cancel = false;
    public boolean request_image_finder_skip = false;
    public boolean stop = false;
    public boolean run = false;
    JTextArea query_area = new JTextArea();
    JTextArea search_area = new JTextArea();
    JButton btn_open_query;
    JButton btn_open_search;
    JButton btn_execute;
    JButton btn_skip;
    JLabel lbl_visit = new JLabel("... / ...", 0);
    TableModel table_model = new TableModel();
    JTable output = new JTable(this.table_model);
    public int visited_files = 0;
    public int total_files = 0;
    public File[][] files = new File[2][];
    public JCheckBox red;
    public JCheckBox green;
    public JCheckBox blue;
    public JCheckBox alpha;
    public JRadioButton btn_exact_match;
    public JRadioButton btn_similarity_match;
    public JRadioButton btn_stretch_match;
    public JCheckBox orientation_vflip;
    public JCheckBox orientation_hflip;
    public JCheckBox orientation_quarter_rot;

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(new Menubar(this));
        this.init_dialog();
        this.query_area.setEnabled(false);
        this.search_area.setEnabled(false);
        JPanel pnl_north = new JPanel(new GridLayout(1, 2));
        this.btn_open_query = new JButton("Select query files...");
        this.btn_open_search = new JButton("Select search files...");
        pnl_north.add(this.btn_open_query);
        pnl_north.add(this.btn_open_search);
        final Window window = this;
        this.btn_open_query.addActionListener(new ActionListener(){
            final /* synthetic */ Window this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(window);
                if (returnVal == 0) {
                    this.this$0.files[0] = fc.getSelectedFiles();
                    String txt = "";
                    for (int i = 0; i < this.this$0.files[0].length; ++i) {
                        txt = txt + this.this$0.files[0][i].getAbsolutePath() + "\n";
                    }
                    this.this$0.query_area.setText(txt);
                }
            }
        });
        this.btn_open_search.addActionListener(new ActionListener(){
            final /* synthetic */ Window this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(window);
                if (returnVal == 0) {
                    this.this$0.files[1] = fc.getSelectedFiles();
                    String txt = "";
                    for (int i = 0; i < this.this$0.files[1].length; ++i) {
                        txt = txt + this.this$0.files[1][i].getAbsolutePath() + "\n";
                    }
                    this.this$0.search_area.setText(txt);
                }
            }
        });
        JPanel pnl_center = new JPanel(new GridLayout(2, 1));
        JPanel pnl_center_north = new JPanel(new GridLayout(1, 2));
        JScrollPane pane1 = new JScrollPane(this.query_area, 20, 30);
        JScrollPane pane2 = new JScrollPane(this.search_area, 20, 30);
        pnl_center_north.add(pane1);
        pnl_center_north.add(pane2);
        this.output.setAutoCreateRowSorter(true);
        TableColumn column = this.output.getColumnModel().getColumn(2);
        column.setMaxWidth(50);
        JScrollPane pane3 = new JScrollPane(this.output, 20, 30);
        pnl_center.add(pnl_center_north);
        pnl_center.add(pane3);
        JPanel pnl_south = new JPanel(new GridLayout(1, 2));
        JPanel pnl_exec = new JPanel(new GridLayout(1, 2));
        JPanel pnl_exec_skip = new JPanel(new GridLayout(2, 1));
        this.btn_execute = new JButton("Run");
        this.btn_execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Window.this.run) {
                    Window.this.stop();
                } else {
                    Window.this.start();
                }
            }
        });
        this.btn_skip = new JButton("Skip");
        this.btn_skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.request_image_finder_skip = true;
            }
        });
        pnl_exec_skip.add(this.lbl_visit);
        pnl_exec_skip.add(this.btn_skip);
        pnl_exec.add(pnl_exec_skip);
        pnl_exec.add(this.btn_execute);
        JPanel panel_options = new JPanel(new GridLayout(3, 1));
        JPanel panel_fit = new JPanel(new GridLayout(1, 4));
        JLabel lbl_fitness = new JLabel("Match");
        this.btn_exact_match = new JRadioButton("Exact");
        this.btn_similarity_match = new JRadioButton("Similar");
        this.btn_stretch_match = new JRadioButton("Stretch");
        ButtonGroup group = new ButtonGroup();
        group.add(this.btn_exact_match);
        group.add(this.btn_similarity_match);
        group.add(this.btn_stretch_match);
        panel_fit.add(lbl_fitness);
        panel_fit.add(this.btn_exact_match);
        panel_fit.add(this.btn_similarity_match);
        panel_fit.add(this.btn_stretch_match);
        this.btn_stretch_match.setSelected(true);
        JPanel panel_chan = new JPanel(new GridLayout(1, 5));
        JLabel lbl_chan = new JLabel("Channels");
        this.red = new JCheckBox("Red", true);
        this.green = new JCheckBox("Green", true);
        this.blue = new JCheckBox("Blue", true);
        this.alpha = new JCheckBox("Alpha", false);
        panel_chan.add(lbl_chan);
        panel_chan.add(this.red);
        panel_chan.add(this.green);
        panel_chan.add(this.blue);
        panel_chan.add(this.alpha);
        JPanel panel_orientation = new JPanel(new GridLayout(1, 4));
        JLabel lbl_orientation = new JLabel("Orientations");
        this.orientation_vflip = new JCheckBox("V-Flip", true);
        this.orientation_hflip = new JCheckBox("H-Flip", true);
        this.orientation_quarter_rot = new JCheckBox("Quarter Rots", true);
        panel_orientation.add(lbl_orientation);
        panel_orientation.add(this.orientation_vflip);
        panel_orientation.add(this.orientation_hflip);
        panel_orientation.add(this.orientation_quarter_rot);
        panel_options.add(panel_fit);
        panel_options.add(panel_chan);
        panel_options.add(panel_orientation);
        pnl_south.add(panel_options);
        pnl_south.add(pnl_exec);
        this.add((Component)pnl_north, "North");
        this.add((Component)pnl_center, "Center");
        this.add((Component)pnl_south, "South");
        this.fullscreen();
        this.setVisible(true);
    }

    public void append_to_output(File f1, File f2, double fitness) {
        this.table_model.addRow(new Object[]{f1, f2, fitness});
    }

    private void start() {
        this.run = true;
        this.stop = false;
        this.btn_open_query.setEnabled(false);
        this.btn_open_search.setEnabled(false);
        this.btn_skip.setEnabled(true);
        this.btn_execute.setText("Stop");
        this.visited_files = 0;
        this.total_files = 0;
        this.table_model.reset(null);
        this.request_image_finder_run = true;
    }

    public void stop() {
        this.request_image_finder_cancel = true;
        this.run = false;
        this.stop = false;
        this.btn_open_query.setEnabled(true);
        this.btn_open_search.setEnabled(true);
        this.btn_skip.setEnabled(false);
        this.btn_execute.setText("Run");
        this.visited_files = 0;
        this.total_files = 0;
        this.lbl_visit.setText(Ixe.rax(this.visited_files) + " / " + Ixe.rax(this.total_files));
    }

    private void init_dialog() {
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "images";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".png") || filename.endsWith(".jpg") || filename.endsWith(".jpeg");
            }
        });
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        if (this.run) {
            if (this.stop) {
                this.stop();
            }
            this.lbl_visit.setText(Ixe.rax(this.visited_files) + " / " + Ixe.rax(this.total_files));
        }
    }

    public File[][] get_files() {
        return this.files;
    }

    public void out() {
        this.table_model.fireTableDataChanged();
    }

    public ArrayList<RowData> table_ref() {
        return this.table_model.get_data();
    }
}

