/*
 * Decompiled with CFR 0.152.
 */
package pkg_core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import pkg_graphic.Window;
import pkg_ixe.IxeDialog;
import pkg_logic.ImageFinder;

public class Manager
implements Runnable {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ScheduledFuture<?> scheduler_handle;
    private final Window window = new Window("\u2734Locator");
    private final ImageFinder image_finder = new ImageFinder(this.window);

    public Manager() {
        IxeDialog.DialogWindow = this.window;
        this.scheduler_handle = this.scheduler.scheduleAtFixedRate(this, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (this.window.request_close) {
            this.scheduler_handle.cancel(true);
            System.exit(0);
        } else {
            this.window.update();
            if (this.window.request_image_finder_run) {
                Thread t = new Thread(this.image_finder);
                t.start();
                this.window.request_image_finder_run = false;
            }
            if (this.window.request_image_finder_cancel) {
                this.image_finder.cancel();
                this.window.request_image_finder_cancel = false;
            }
            if (this.window.request_image_finder_skip) {
                this.image_finder.skip();
                this.window.request_image_finder_skip = false;
            }
            if (this.image_finder.pick_terminated() && this.window.run) {
                this.window.stop = true;
            }
        }
    }
}

