/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.io.File;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;

public class Listener {
    public static final float MUTE_GAIN = -80.0f;
    protected boolean is_muted = false;
    protected DataLine dataline = null;
    protected FloatControl gain_ctl = null;
    protected FloatControl pan_ctl = null;
    protected float gain = 0.0f;
    protected float pan = 0.0f;
    protected float frame_rate = 0.0f;
    protected long frame_length = 0L;
    protected double duration = 0.0;

    public void load(File input) {
    }

    public void set_gain(float gain) {
        this.gain = gain;
        if (this.gain_ctl != null) {
            this.gain_ctl.setValue(this.is_muted ? -80.0f : gain);
        }
    }

    public void set_pan(float pan) {
        this.pan = pan;
        if (this.pan_ctl != null) {
            this.pan_ctl.setValue(pan);
        }
    }

    public void set_muted(boolean is_muted) {
        this.is_muted = is_muted;
        if (this.gain_ctl != null) {
            this.gain_ctl.setValue(is_muted ? -80.0f : this.gain);
        }
    }

    public void start() {
        if (this.dataline != null) {
            this.dataline.start();
        }
    }

    public void stop() {
        if (this.dataline != null) {
            this.dataline.stop();
        }
    }

    public void kill() {
        if (this.dataline != null) {
            this.dataline.stop();
            this.dataline.flush();
            this.dataline.drain();
        }
    }

    public float get_tracking() {
        return this.dataline == null || this.frame_length <= 0L ? 0.0f : (float)this.get_frame_position() / (float)this.frame_length;
    }

    public void set_tracking(float track) {
    }

    public long get_frame_position() {
        return this.dataline == null ? 0L : (long)this.dataline.getFramePosition();
    }

    public long get_frame_length() {
        return this.frame_length;
    }

    public double get_duration() {
        return this.duration;
    }

    public float get_frame_rate() {
        return this.frame_rate;
    }
}

