/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import pkg_logic.Listener;

public class ClipListener
extends Listener {
    public static double read_duration(File file) {
        double duration = 0.0;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(file);
            AudioFormat format = stream.getFormat();
            duration = 1.517037037 * ((double)stream.getFrameLength() / (double)format.getFrameRate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return duration;
    }

    @Override
    public void load(File input) {
        this.kill();
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(input);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.start();
            this.dataline = clip;
            this.frame_length = stream.getFrameLength();
            this.frame_rate = format.getFrameRate();
            this.duration = 1.517037037 * ((double)this.frame_length / (double)this.frame_rate);
            clip.open(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.dataline != null) {
            this.gain_ctl = (FloatControl)this.dataline.getControl(FloatControl.Type.MASTER_GAIN);
            this.pan_ctl = (FloatControl)this.dataline.getControl(FloatControl.Type.PAN);
            this.dataline.start();
        }
    }

    @Override
    public void set_tracking(float track) {
        if (this.dataline != null) {
            ((Clip)this.dataline).setFramePosition((int)(track * (float)this.frame_length));
        }
    }
}

