/*
 * Decompiled with CFR 0.152.
 */
package pkg_list;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ListVals {
    private static final String default_split_regex = "\\s+";

    public static int[] getInts(byte[] bytes) throws BufferUnderflowException {
        ByteBuffer b = ByteBuffer.wrap(bytes);
        int[] vals = new int[bytes.length / 4];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = b.getInt();
        }
        return vals;
    }

    public static float[] getFloats(byte[] bytes) throws BufferUnderflowException {
        ByteBuffer b = ByteBuffer.wrap(bytes);
        float[] vals = new float[bytes.length / 4];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = b.getFloat();
        }
        return vals;
    }

    public static double[] getDoubles(byte[] bytes) throws BufferUnderflowException {
        ByteBuffer b = ByteBuffer.wrap(bytes);
        double[] vals = new double[bytes.length / 8];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = b.getDouble();
        }
        return vals;
    }

    public static long[] getLongs(byte[] bytes) throws BufferUnderflowException {
        ByteBuffer b = ByteBuffer.wrap(bytes);
        long[] vals = new long[bytes.length / 8];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = b.getLong();
        }
        return vals;
    }

    public static byte[] getBytes(byte[] bytes) {
        return bytes;
    }

    public static short[] getShorts(byte[] bytes) throws BufferUnderflowException {
        ByteBuffer b = ByteBuffer.wrap(bytes);
        short[] vals = new short[bytes.length / 2];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = b.getShort();
        }
        return vals;
    }

    public static boolean[] getBooleans(byte[] bytes) {
        boolean[] booleans = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            booleans[i] = bytes[i] != 0;
        }
        return booleans;
    }

    public static boolean[] getBits(byte[] bytes) {
        boolean[] booleans = new boolean[bytes.length * 8];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            for (int j = 0; j < 8; ++j) {
                booleans[i * 8 + j] = (b & 1 << j) != 0;
            }
        }
        return booleans;
    }

    public static String getString(byte[] bytes) {
        return ListVals.getString(bytes, StandardCharsets.UTF_8);
    }

    public static String getString(byte[] bytes, Charset charset) {
        String s = new String(bytes, charset);
        String s2 = "";
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    s2 = s2 + "\\t";
                    continue block8;
                }
                case '\n': {
                    s2 = s2 + "\\n";
                    continue block8;
                }
                case '\\': {
                    s2 = s2 + "\\\\";
                    continue block8;
                }
                case '`': {
                    s2 = s2 + (charset == StandardCharsets.US_ASCII ? "\\`" : "`");
                    continue block8;
                }
                case '\"': {
                    s2 = s2 + (charset == StandardCharsets.UTF_8 ? "\\\"" : "\"");
                    continue block8;
                }
                case '#': {
                    s2 = s2 + (charset == StandardCharsets.UTF_16 ? "\\#" : "#");
                    continue block8;
                }
                default: {
                    s2 = s2 + c;
                }
            }
        }
        return s2;
    }

    public static String[] getStrings(byte[] bytes) {
        return bytes.length == 0 ? new String[]{} : ListVals.getString(bytes).split("\u0000", -1);
    }

    public static byte[] parseBytes_byte(String content) throws NumberFormatException {
        int count = 0;
        for (int i = 0; i < content.length(); ++i) {
            if (Character.digit(content.charAt(i), 16) == -1) continue;
            ++count;
        }
        if (count % 2 == 1) {
            throw new NumberFormatException("Odd hex count");
        }
        byte[] bytes = new byte[count / 2];
        count = 0;
        char c1 = ' ';
        boolean first = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (Character.digit(c, 16) == -1) continue;
            if (first) {
                bytes[count++] = (byte)((Character.digit(c1, 16) << 4) + Character.digit(c, 16));
            } else {
                c1 = c;
            }
            first = !first;
        }
        return bytes;
    }

    public static byte[] parseBytes_boolean(String content) throws NumberFormatException {
        int count = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c != '0' && c != '1') continue;
            ++count;
        }
        byte[] bytes = new byte[count];
        count = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c != '0' && c != '1') continue;
            bytes[count++] = (byte)(c - 48);
        }
        return bytes;
    }

    public static byte[] parseBytes_int(String content) throws NumberFormatException {
        return ListVals.parseBytes_int(content, default_split_regex);
    }

    public static byte[] parseBytes_long(String content) throws NumberFormatException {
        return ListVals.parseBytes_long(content, default_split_regex);
    }

    public static byte[] parseBytes_short(String content) throws NumberFormatException {
        return ListVals.parseBytes_short(content, default_split_regex);
    }

    public static byte[] parseBytes_float(String content) throws NumberFormatException {
        return ListVals.parseBytes_float(content, default_split_regex);
    }

    public static byte[] parseBytes_double(String content) throws NumberFormatException {
        return ListVals.parseBytes_double(content, default_split_regex);
    }

    public static byte[] parseBytes_int(String content, String splitRegex) throws NumberFormatException {
        String[] split = content.split(splitRegex);
        ByteBuffer b = ByteBuffer.allocate(4 * split.length);
        for (int i = 0; i < split.length; ++i) {
            b.putInt(Integer.parseInt(split[i]));
        }
        return b.array();
    }

    public static byte[] parseBytes_long(String content, String splitRegex) throws NumberFormatException {
        String[] split = content.split(splitRegex);
        ByteBuffer b = ByteBuffer.allocate(8 * split.length);
        for (int i = 0; i < split.length; ++i) {
            b.putLong(Long.parseLong(split[i]));
        }
        return b.array();
    }

    public static byte[] parseBytes_short(String content, String splitRegex) throws NumberFormatException {
        String[] split = content.split(splitRegex);
        ByteBuffer b = ByteBuffer.allocate(2 * split.length);
        for (int i = 0; i < split.length; ++i) {
            b.putShort(Short.parseShort(split[i]));
        }
        return b.array();
    }

    public static byte[] parseBytes_float(String content, String splitRegex) throws NumberFormatException {
        String[] split = content.split(splitRegex);
        ByteBuffer b = ByteBuffer.allocate(4 * split.length);
        for (int i = 0; i < split.length; ++i) {
            b.putFloat(Float.parseFloat(split[i]));
        }
        return b.array();
    }

    public static byte[] parseBytes_double(String content, String splitRegex) throws NumberFormatException {
        String[] split = content.split(splitRegex);
        ByteBuffer b = ByteBuffer.allocate(8 * split.length);
        for (int i = 0; i < split.length; ++i) {
            b.putDouble(Double.parseDouble(split[i]));
        }
        return b.array();
    }

    public static byte[] parseBytes_boolean(boolean[] content) {
        byte[] bytes = new byte[content.length];
        for (int i = 0; i < content.length; ++i) {
            bytes[i] = (byte)(content[i] ? 1 : 0);
        }
        return bytes;
    }

    public static byte[] parseBytes_int(int[] content) {
        ByteBuffer b = ByteBuffer.allocate(4 * content.length);
        for (int i = 0; i < content.length; ++i) {
            b.putInt(content[i]);
        }
        return b.array();
    }

    public static byte[] parseBytes_long(long[] content) {
        ByteBuffer b = ByteBuffer.allocate(8 * content.length);
        for (int i = 0; i < content.length; ++i) {
            b.putLong(content[i]);
        }
        return b.array();
    }

    public static byte[] parseBytes_short(short[] content) {
        ByteBuffer b = ByteBuffer.allocate(2 * content.length);
        for (int i = 0; i < content.length; ++i) {
            b.putShort(content[i]);
        }
        return b.array();
    }

    public static byte[] parseBytes_float(float[] content) {
        ByteBuffer b = ByteBuffer.allocate(4 * content.length);
        for (int i = 0; i < content.length; ++i) {
            b.putFloat(content[i]);
        }
        return b.array();
    }

    public static byte[] parseBytes_double(double[] content) {
        ByteBuffer b = ByteBuffer.allocate(8 * content.length);
        for (int i = 0; i < content.length; ++i) {
            b.putDouble(content[i]);
        }
        return b.array();
    }

    public static byte[] parseBytes_str(String content) {
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] parseBytes_str(String content, Charset charset) {
        return content.getBytes(charset);
    }
}

