/*
 * Decompiled with CFR 0.152.
 */
package pkg_list;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import pkg_list.ListCoder;
import pkg_list.ListPage;
import pkg_list.ListVal;
import pkg_list.Lists;

public class ListDecoder
extends ListCoder {
    private static InputStream in;
    private static int[] sections;
    private static int section_it;
    private static int bytes_read;
    private static byte[] read;
    private static int read_it;
    private static long page_it;

    public static Lists open(File file) throws IOException {
        in = new FileInputStream(file);
        Lists lists = new Lists();
        ListDecoder.read(lists);
        ListDecoder.close();
        return lists;
    }

    public static Lists open(File file, Lists lists) throws IOException {
        in = new FileInputStream(file);
        ListDecoder.read(lists);
        ListDecoder.close();
        return lists;
    }

    private static void close() throws IOException {
        in.close();
    }

    private static void read(Lists lists) throws IOException {
        buffer_it = 0;
        section_it = 0;
        read_it = 0;
        page_it = 0L;
        long page_size = 0L;
        long page_type = 0L;
        ListPage page = null;
        long key = 0L;
        int value_size_length = 0;
        int value_type = 0;
        long value_size = 0L;
        boolean next_page = false;
        while ((bytes_read = in.read(buffer)) != -1) {
            while (buffer_it < bytes_read) {
                if (!ListDecoder.section()) continue;
                int page_it_inc = sections[section_it];
                int section_it_next = section_it + 1;
                switch (section_it) {
                    case 0: {
                        page_size = ListDecoder.read_long(8);
                        if (page_size >= 0L) break;
                        throw new IOException("Negative page size: " + page_size + " " + page_it);
                    }
                    case 1: {
                        page_type = ListDecoder.read_long(8);
                        page = new ListPage(page_type);
                        lists.add_page(page);
                        if (page_it + (long)page_it_inc != page_size) break;
                        next_page = true;
                        break;
                    }
                    case 2: {
                        key = ListDecoder.read_long(8);
                        break;
                    }
                    case 3: {
                        int value_meta = ListDecoder.read_unsigned_byte();
                        value_size_length = value_meta % 8 + 1;
                        value_type = value_meta / 8;
                        ListDecoder.sections[ListDecoder.section_it + 1] = value_size_length;
                        break;
                    }
                    case 4: {
                        value_size = ListDecoder.read_long(value_size_length);
                        ListDecoder.sections[ListDecoder.section_it + 1] = (int)value_size;
                        break;
                    }
                    case 5: {
                        page.map.put(key, new ListVal(read, (byte)value_type, 0, (int)value_size));
                        if (page_it + (long)page_it_inc > page_size) {
                            throw new IOException("Page overflow " + page_it + "+" + page_it_inc + ">" + page_size);
                        }
                        if (page_it + (long)page_it_inc == page_size) {
                            next_page = true;
                            break;
                        }
                        section_it_next = 2;
                    }
                }
                if (next_page) {
                    next_page = false;
                    section_it_next = 0;
                    page_it = 0L;
                    page_it_inc = 0;
                }
                page_it += (long)page_it_inc;
                section_it = section_it_next;
                read_it = 0;
                if (sections[section_it] <= read.length) continue;
                read = new byte[sections[section_it]];
            }
            buffer_it = 0;
        }
        if (section_it >= 4) {
            page.map.put(key, new ListVal(read, (byte)value_type, 0, (int)value_size));
        }
    }

    private static int read_unsigned_byte() {
        return read[0] & 0xFF;
    }

    private static long read_long(int length) {
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l <<= 8;
            l |= (long)(read[i] & 0xFF);
        }
        return l;
    }

    private static boolean section() {
        while (read_it < sections[section_it] && buffer_it < bytes_read) {
            ListDecoder.read[ListDecoder.read_it++] = buffer[buffer_it++];
        }
        return read_it == sections[section_it];
    }

    static {
        sections = new int[]{8, 8, 8, 1, 0, 0};
        read = new byte[8];
    }
}

