/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.JTable;
import pkg_core.HardInfo;
import pkg_core.Screen;
import pkg_data.Playlist;
import pkg_graphic.AudioPanel;
import pkg_graphic.ControlPanel;
import pkg_graphic.Frame;
import pkg_graphic.IndexPanel;
import pkg_graphic.Menubar;
import pkg_graphic.PlaylistData;
import pkg_graphic.PlaylistPanel;
import pkg_ixe.IxeDialog;
import pkg_list.ListDecoder;
import pkg_list.ListPage;
import pkg_list.ListVal;
import pkg_list.ListVals;
import pkg_list.Lists;
import pkg_logic.ClipListener;

public class Window
extends Frame {
    private ArrayList<Playlist> playlists = new ArrayList();
    private ClipListener listener = new ClipListener();
    private IndexPanel index = new IndexPanel(this.playlists);
    private PlaylistPanel playlist = new PlaylistPanel();
    private AudioPanel audio = new AudioPanel(this.listener);
    private ControlPanel control = new ControlPanel(this.listener);

    public Window(String title) {
        super(title);
        this.setLayout(new BorderLayout());
        this.playlist.get_table().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable table = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int row = table.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2 && table.getSelectedRow() != -1 && row != -1) {
                    int index = table.convertRowIndexToModel(row);
                    if (Window.this.control.get_data() != Window.this.playlist.get_table_model().get_data()) {
                        Window.this.control.set_data(Window.this.playlist.get_table_model().get_data(), true);
                    }
                    Window.this.control.select(index, true, false);
                }
            }
        });
        this.playlist.setVisible(false);
        this.add((Component)this.index, "West");
        this.add((Component)this.playlist, "Center");
        this.add((Component)this.control, "South");
        this.add((Component)this.audio, "East");
        this.setJMenuBar(new Menubar(this));
        this.auto();
        this.fullscreen();
        this.setVisible(true);
    }

    private void auto() {
        this.auto_file = new File("auto.list");
        if (this.auto_file.exists() && this.auto_file.isFile()) {
            try {
                this.load_data(ListDecoder.open(this.auto_file));
            }
            catch (IOException e) {
                IxeDialog.error("Cannot load " + this.auto_file + "\n" + e.getMessage());
                this.load_data(null);
            }
        }
        this.autosave();
    }

    private void load_data(Lists data) {
        this.playlists.clear();
        try {
            for (ListPage lp : data.get_all_pages()) {
                String name = "";
                Playlist p = new Playlist("");
                int index = 0;
                for (ListVal lv : lp.map.values()) {
                    if (index == 0) {
                        name = lv.str();
                    } else {
                        p.add(lv.str());
                    }
                    ++index;
                }
                p.set_name(name);
                this.playlists.add(p);
            }
        }
        catch (Exception e) {
            IxeDialog.error(e.getMessage());
        }
        this.index.update_list();
    }

    @Override
    public Lists parse() {
        Lists data = new Lists();
        for (int i = 0; i < this.playlists.size(); ++i) {
            ListPage p = new ListPage(i);
            data.add_page(p);
            p.put(0L, new ListVal(ListVal.VALTYPE.UTF8, ListVals.parseBytes_str(this.playlists.get(i).get_name(), StandardCharsets.UTF_8)));
            ArrayList<PlaylistData> clips = this.playlists.get(i).get_data();
            for (int j = 0; j < clips.size(); ++j) {
                p.put((long)(j + 1), new ListVal(ListVal.VALTYPE.UTF8, ListVals.parseBytes_str(clips.get(j).get_file().getAbsolutePath(), StandardCharsets.UTF_8)));
            }
        }
        return data;
    }

    public void playback_start() {
        this.listener.start();
    }

    public void playback_stop() {
        this.listener.stop();
    }

    private void fullscreen() {
        Screen.device.setFullScreenWindow(HardInfo.FULLSCREEN ? this : null);
    }

    @Override
    public void update() {
        if (this.request_fullscreen) {
            this.fullscreen();
            this.request_fullscreen = false;
        }
        if (this.index.request_index_change != -1) {
            this.playlist.setVisible(true);
            this.playlist.reset(this.index.get_data(this.index.request_index_change));
            this.control.set_data(this.playlist.get_table_model().get_data(), false);
            this.index.request_index_change = -1;
        }
        this.control.update();
        if (this.control.request_repaint) {
            this.revalidate();
            this.repaint();
            this.control.request_repaint = false;
        }
    }

    public void clip_action(int action) {
        this.playlist.action(action);
    }

    public void playlist_action(int action) {
        int index = this.index.get_selected();
        boolean change = false;
        int index2 = -1;
        Playlist p = null;
        if (action == 5) {
            String input = IxeDialog.input("New playlist", "New name");
            if (input != null) {
                p = new Playlist(input);
                change = true;
                index2 = this.playlists.size();
            }
        } else if (action == 6) {
            p = this.playlists.get(index);
            String input = IxeDialog.input("Edit playlist", "Edit name", p.get_name());
            if (input != null) {
                p.set_name(input);
                change = true;
            }
        } else if (index >= 0 && index < this.playlists.size()) {
            p = this.playlists.get(index);
            switch (action) {
                case 0: {
                    if (index == 0) break;
                    index2 = 0;
                    change = true;
                    break;
                }
                case 1: {
                    if (index == 0) break;
                    index2 = index - 1;
                    change = true;
                    break;
                }
                case 2: {
                    if (index == this.playlists.size() - 1) break;
                    index2 = index + 1;
                    change = true;
                    break;
                }
                case 3: {
                    if (index == this.playlists.size() - 1) break;
                    index2 = this.playlists.size() - 1;
                    change = true;
                    break;
                }
                case 4: {
                    change = true;
                    if (p.get_data() != this.playlist.get_table_model().get_data() || this.playlists.size() != 1) break;
                    this.playlist.setVisible(false);
                    this.playlist.reset(null);
                }
            }
            if (change) {
                this.playlists.remove(index);
            }
        }
        if (change) {
            if (index2 != -1) {
                this.playlists.add(index2, p);
            }
            this.index.update_list();
        }
        if (index2 != -1) {
            this.index.set_selected(index2);
        } else if (this.playlists.size() > 0) {
            this.index.set_selected(Math.max(index - 1, 0));
        }
    }

    public void load_clips() {
        if (this.index.get_selected() != -1) {
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File[] files = fc.getSelectedFiles();
                try {
                    Playlist p = this.playlists.get(this.index.get_selected());
                    int size = p.size();
                    for (File f : files) {
                        p.add_file(f);
                    }
                    if (size < p.size()) {
                        this.playlist.get_table_model().fireTableRowsInserted(size, p.size() - 1);
                    }
                }
                catch (Exception e) {
                    IxeDialog.error("Cannot load " + files.length + " files\n" + e.getMessage());
                }
            }
        } else {
            IxeDialog.error("No active playlist. Create or select a playlist.");
        }
    }

    public boolean stop() {
        this.listener.kill();
        return true;
    }

    public void control_action(int action) {
        this.control.action(action);
    }

    public void audio_action(int action) {
        this.audio.action(action);
    }
}

