/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import pkg_data.Playlist;
import pkg_graphic.PlaylistModel;

public class PlaylistPanel
extends JPanel
implements DropTargetListener {
    private PlaylistModel table_model;
    private JTable table;
    private int[] col_width = new int[]{15, 30, 400, 200};
    private Playlist playlist = null;

    public PlaylistPanel() {
        this.setLayout(new BorderLayout());
        DropTarget dt = new DropTarget(this, 3, this, true, null);
        this.setDropTarget(dt);
        this.table_model = new PlaylistModel();
        this.table = new JTable(this.table_model);
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateRowSorter(true);
        TableColumn column = null;
        for (int i = 0; i < this.table_model.col_nb; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.col_width[i]);
            column.setMinWidth(this.col_width[i] < 50 ? this.col_width[i] : 50);
        }
        this.align_fix();
        JScrollPane scroller = new JScrollPane(this.table, 20, 30);
        this.table.setFillsViewportHeight(true);
        ((DefaultRowSorter)this.table.getRowSorter()).setSortable(0, false);
        this.add((Component)scroller, "Center");
    }

    private void align_fix() {
        DefaultTableCellRenderer right = new DefaultTableCellRenderer();
        right.setHorizontalAlignment(4);
        this.table.getColumnModel().getColumn(1).setCellRenderer(right);
        DefaultTableCellRenderer center = new DefaultTableCellRenderer();
        center.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(3).setCellRenderer(center);
    }

    public int get_selected_row() {
        return this.table.getSelectedRow();
    }

    public void reset(Playlist playlist) {
        this.playlist = playlist;
        this.table_model.reset(playlist);
    }

    public PlaylistModel get_table_model() {
        return this.table_model;
    }

    public JTable get_table() {
        return this.table;
    }

    public void action(int action) {
        int index = this.table_model.action(this.get_selected_row(), action);
        if (index != -1) {
            this.table.setRowSelectionInterval(index, index);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.setBorder(BorderFactory.createBevelBorder(0, Color.RED.brighter(), Color.RED.darker()));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setBorder(null);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            dtde.acceptDrop(3);
            String[] text = ((String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor)).split("\n");
            int data_size = this.table_model.get_data().size();
            for (int i = 0; i < text.length; ++i) {
                this.playlist.add_file(new File(text[i]));
            }
            dtde.dropComplete(true);
            if (data_size < this.table_model.get_data().size()) {
                this.table_model.fireTableRowsInserted(data_size, this.table_model.get_data().size() - 1);
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

