/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import pkg_data.Playlist;
import pkg_graphic.PlaylistData;
import pkg_ixe.Ixe;
import pkg_ixe.IxeTime;

public class PlaylistModel
extends AbstractTableModel {
    private String[] columns = new String[]{"\u25a3", "#", "Name", "Time"};
    private Object[] classes = new Object[]{new Boolean(false), new String(""), new String(""), new String("")};
    private boolean[] editable = new boolean[]{false, false, false, false};
    public int col_nb = this.columns.length;
    private ArrayList<PlaylistData> data = new ArrayList();

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).is_playing();
            }
            case 1: {
                return Ixe.rax(this.data.get(rowIndex).get_index());
            }
            case 2: {
                return this.data.get(rowIndex).get_name();
            }
            case 3: {
                return IxeTime.str_major((long)this.data.get(rowIndex).get_duration(), 4);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size()) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                break;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column >= 0 && column < this.editable.length && this.editable[column];
    }

    @Override
    public String getColumnName(int column) {
        return this.columns[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex].getClass();
    }

    public void reset(Playlist playlist) {
        this.data = playlist == null ? new ArrayList() : playlist.get_data();
        this.fireTableDataChanged();
    }

    public void addRow(Object[] row) {
        this.data.add(new PlaylistData(row, this.data.size()));
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public void delete(int index) {
        if (index >= 0 && index < this.data.size()) {
            this.data.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public ArrayList<PlaylistData> get_data() {
        return this.data;
    }

    public int action(int index, int action) {
        int index2 = -1;
        if (index >= 0 && index < this.data.size()) {
            PlaylistData p = this.data.get(index);
            boolean change = false;
            switch (action) {
                case 0: {
                    if (index == 0) break;
                    index2 = 0;
                    change = true;
                    break;
                }
                case 1: {
                    if (index == 0) break;
                    index2 = index - 1;
                    change = true;
                    break;
                }
                case 2: {
                    if (index == this.data.size() - 1) break;
                    index2 = index + 1;
                    change = true;
                    break;
                }
                case 3: {
                    if (index == this.data.size() - 1) break;
                    index2 = this.data.size() - 1;
                    change = true;
                    break;
                }
                case 4: {
                    change = true;
                }
            }
            if (change) {
                this.data.remove(index);
                if (index2 != -1) {
                    this.data.add(index2, p);
                }
                for (int i = 0; i < this.data.size(); ++i) {
                    this.data.get(i).set_index(i);
                }
                this.fireTableDataChanged();
            }
        }
        return index2;
    }
}

