/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pkg_core.Screen;
import pkg_ixe.IxeDialog;
import pkg_list.ListEncoder;
import pkg_list.Lists;

public abstract class Frame
extends JFrame {
    protected static final JFileChooser fc = new JFileChooser();
    public boolean request_close = false;
    public boolean request_fullscreen = true;
    protected File auto_file = null;

    public Frame(String title) {
        this.init_dialog();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame.this.request_close = true;
            }
        });
        this.setSize(Screen.w / 2, Screen.h / 2);
        this.setLocationRelativeTo(null);
        this.setTitle(title);
    }

    private void init_dialog() {
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ".wav audio files";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return filename.endsWith(".wav");
            }
        });
    }

    public abstract void update();

    public abstract Lists parse();

    public void autosave() {
        if (this.auto_file != null && (!this.auto_file.exists() || this.auto_file.isFile())) {
            try {
                ListEncoder.open(this.auto_file, false, this.parse());
            }
            catch (Exception e) {
                IxeDialog.error("Cannot save " + this.auto_file + "\n" + e.getMessage());
            }
        }
    }
}

