/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_graphic.CharButton;
import pkg_graphic.PlaylistData;
import pkg_ixe.Ixe;
import pkg_ixe.IxeConst;
import pkg_ixe.IxeTime;
import pkg_logic.Listener;

public class ControlPanel
extends JPanel {
    public boolean request_repaint = false;
    private Listener listener;
    private ArrayList<PlaylistData> data = null;
    private PlaylistData playing_file = null;
    private JSlider tracking_bar = new JSlider();
    private JLabel lbl_name = new JLabel("", 2);
    private JLabel lbl_time_lapsed = new JLabel("", 0);
    private JLabel lbl_time_remaining = new JLabel("", 0);
    private JLabel lbl_time_total = new JLabel("", 0);
    private CharButton btn_play;
    private CharButton btn_loop;
    private CharButton btn_shuffle;
    private boolean shuffle = false;
    private boolean loop = false;
    private boolean play = false;

    public ControlPanel(final Listener listener) {
        super(new GridLayout(2, 1));
        this.listener = listener;
        this.btn_play = new CharButton("\u25a3");
        CharButton btn_stop = new CharButton("\u2612");
        CharButton btn_next = new CharButton("\u2192");
        CharButton btn_previous = new CharButton("\u2190");
        CharButton btn_first = new CharButton("\u21e4");
        CharButton btn_last = new CharButton("\u21e5");
        this.btn_loop = new CharButton("\u2941");
        this.btn_shuffle = new CharButton("\u2928");
        this.btn_loop.setForeground(Color.GRAY);
        this.btn_shuffle.setForeground(Color.GRAY);
        this.btn_play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(0);
            }
        });
        btn_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(1);
            }
        });
        btn_next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(4);
            }
        });
        btn_previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(3);
            }
        });
        btn_first.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(2);
            }
        });
        btn_last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(5);
            }
        });
        this.btn_loop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(6);
            }
        });
        this.btn_shuffle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.action(7);
            }
        });
        this.tracking_bar.setValue(0);
        this.tracking_bar.addChangeListener(new ChangeListener(){
            final /* synthetic */ ControlPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!this.this$0.tracking_bar.getValueIsAdjusting()) {
                    float v = (float)this.this$0.tracking_bar.getValue() / 100.0f;
                    if (!Ixe.near(listener.get_tracking(), v, 0.005f)) {
                        listener.set_tracking(v);
                    }
                }
            }
        });
        JPanel nav_panel = new JPanel(new GridLayout(1, 8));
        nav_panel.add(btn_first);
        nav_panel.add(btn_previous);
        nav_panel.add(this.btn_play);
        nav_panel.add(btn_stop);
        nav_panel.add(btn_next);
        nav_panel.add(btn_last);
        nav_panel.add(this.btn_loop);
        nav_panel.add(this.btn_shuffle);
        JPanel track_panel = new JPanel(new GridLayout(2, 1));
        JPanel info_panel = new JPanel(new BorderLayout());
        info_panel.add((Component)this.lbl_name, "Center");
        JPanel time_panel = new JPanel(new GridLayout(1, 3));
        this.lbl_time_lapsed.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.lbl_time_remaining.setBorder(new EmptyBorder(new Insets(0, 10, 0, 0)));
        this.lbl_time_total.setBorder(new EmptyBorder(new Insets(0, 10, 0, 10)));
        time_panel.add(this.lbl_time_lapsed);
        time_panel.add(this.lbl_time_remaining);
        time_panel.add(this.lbl_time_total);
        info_panel.add((Component)time_panel, "East");
        track_panel.add(this.tracking_bar);
        track_panel.add(info_panel);
        this.add(track_panel);
        this.add(nav_panel);
        this.select(-1, false, true);
    }

    public void action(int action) {
        int index = -1;
        switch (action) {
            case 0: {
                if (this.data == null || this.data.isEmpty()) break;
                if (this.play) {
                    this.listener.stop();
                    this.update_play(!this.play);
                    break;
                }
                if (this.playing_file == null) {
                    this.select(0, false, false);
                    break;
                }
                this.listener.start();
                this.update_play(!this.play);
                break;
            }
            case 1: {
                if (this.data == null || this.data.isEmpty()) break;
                this.select(-1, false, true);
                break;
            }
            case 2: {
                if (this.data != null && !this.data.isEmpty()) {
                    index = 0;
                }
                this.select(index, false, false);
                break;
            }
            case 3: {
                if (this.playing_file != null) {
                    index = this.playing_file.get_index() - 1;
                } else if (this.data != null && !this.data.isEmpty()) {
                    index = 0;
                }
                this.select(index, false, false);
                break;
            }
            case 4: {
                if (this.playing_file != null) {
                    index = this.playing_file.get_index() + 1;
                } else if (this.data != null && !this.data.isEmpty()) {
                    index = 0;
                }
                this.select(index, false, false);
                break;
            }
            case 5: {
                if (this.data != null && !this.data.isEmpty()) {
                    index = this.data.size() - 1;
                }
                this.select(index, false, false);
                break;
            }
            case 6: {
                this.loop = !this.loop;
                this.btn_loop.setForeground(this.loop ? Color.BLACK : Color.GRAY);
                break;
            }
            case 7: {
                this.shuffle = !this.shuffle;
                this.btn_shuffle.setForeground(this.shuffle ? Color.BLACK : Color.GRAY);
            }
        }
    }

    private void update_play(boolean play) {
        this.play = play;
        this.btn_play.setText(play ? "\u25a1" : "\u25a3");
    }

    public void update() {
        if (this.playing_file != null) {
            this.adjust_playback();
            long time_total = (long)(1.517037037 * (double)this.listener.get_frame_length() / (double)this.listener.get_frame_rate());
            long time_lapsed = this.tracking_bar.getValueIsAdjusting() ? (long)((float)this.tracking_bar.getValue() / 100.0f * (float)time_total) : (long)(1.517037037 * (double)this.listener.get_frame_position() / (double)this.listener.get_frame_rate());
            long time_remaining = time_total - time_lapsed;
            this.lbl_time_lapsed.setText(IxeTime.str_major(time_lapsed, 4));
            this.lbl_time_remaining.setText(IxeTime.str_major(time_remaining, 4));
            this.lbl_time_total.setText(IxeTime.str_major(time_total, 4));
        }
    }

    private void adjust_playback() {
        if (!this.tracking_bar.getValueIsAdjusting()) {
            this.tracking_bar.setValue((int)(this.listener.get_tracking() * 100.0f));
        }
    }

    public void select(int index, boolean override, boolean stop) {
        if (this.data == null) {
            return;
        }
        this.listener.kill();
        if (this.playing_file != null) {
            this.playing_file.set_playing(false);
        }
        this.lbl_time_lapsed.setText("");
        this.lbl_time_remaining.setText("");
        this.lbl_time_total.setText("");
        if (!this.data.isEmpty()) {
            if (!stop && this.loop && !this.shuffle) {
                index = (index % this.data.size() + this.data.size()) % this.data.size();
            }
            if (index >= 0 && index < this.data.size()) {
                if (this.shuffle && !override) {
                    index = this.playing_file == null ? IxeConst.random.nextInt(this.data.size()) : (IxeConst.random.nextInt(this.data.size() - 1) + 1 + this.playing_file.get_index()) % this.data.size();
                }
                this.playing_file = this.data.get(index);
                this.listener.load(this.playing_file.get_file());
                this.playing_file.set_playing(true);
            } else {
                this.playing_file = null;
            }
        } else {
            this.playing_file = null;
        }
        if (this.playing_file == null) {
            this.lbl_name.setText("");
        } else {
            this.lbl_name.setText(this.playing_file.get_name());
        }
        this.update_play(this.playing_file != null);
        this.tracking_bar.setVisible(this.playing_file != null);
        this.request_repaint = true;
    }

    public void set_data(ArrayList<PlaylistData> data, boolean replace) {
        if (this.playing_file == null || replace) {
            this.data = data;
            this.playing_file = null;
        }
    }

    public ArrayList<PlaylistData> get_data() {
        return this.data;
    }
}

