/*
 * Decompiled with CFR 0.152.
 */
package pkg_graphic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pkg_graphic.CharButton;
import pkg_graphic.CharLabel;
import pkg_logic.Listener;

public class AudioPanel
extends JPanel {
    private JSlider gain = new JSlider();
    private JSlider pan = new JSlider();
    private Listener listener;
    private CharButton btn_mute = new CharButton("\ud83d\udd08");
    private boolean is_mute = false;

    public AudioPanel(final Listener listener) {
        super(new BorderLayout());
        this.listener = listener;
        JPanel pnl_north = new JPanel(new GridLayout(1, 2));
        JPanel pnl_center = new JPanel(new GridLayout(1, 2));
        JPanel pnl_south = new JPanel(new GridLayout(1, 2));
        this.gain.setOrientation(1);
        this.pan.setOrientation(1);
        this.pan.setMajorTickSpacing(50);
        Hashtable<Integer, CharLabel> labels = new Hashtable<Integer, CharLabel>();
        labels.put(0, new CharLabel("L"));
        labels.put(100, new CharLabel("R"));
        this.pan.setLabelTable(labels);
        this.pan.setPaintLabels(true);
        this.pan.setPaintTicks(true);
        this.pan.addChangeListener(new ChangeListener(){
            final /* synthetic */ AudioPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                float v = (float)(this.this$0.pan.getValue() - 50) / 50.0f;
                listener.set_pan(v);
            }
        });
        this.gain.addChangeListener(new ChangeListener(){
            final /* synthetic */ AudioPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                float v = (float)(this.this$0.gain.getValue() - 50) / 50.0f;
                v = v < 0.0f ? (v *= 20.0f) : (v *= 6.0f);
                if (this.this$0.gain.getValue() == 0) {
                    v = -80.0f;
                }
                listener.set_gain(v);
            }
        });
        this.btn_mute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioPanel.this.action(0);
            }
        });
        pnl_north.add(new CharLabel("\ud83d\udd0a", 0));
        pnl_north.add(new CharLabel("\u29d7", 0));
        pnl_center.add(this.gain);
        pnl_center.add(this.pan);
        pnl_south.add(this.btn_mute);
        pnl_south.add(new JLabel());
        this.add((Component)pnl_north, "North");
        this.add((Component)pnl_center, "Center");
        this.add((Component)pnl_south, "South");
    }

    public void action(int action) {
        switch (action) {
            case 0: {
                this.is_mute = !this.is_mute;
                this.listener.set_muted(this.is_mute);
                this.btn_mute.setText(this.is_mute ? "\ud83d\udd07" : "\ud83d\udd08");
            }
        }
    }
}

