/*
 * Decompiled with CFR 0.152.
 */
package pkg_data;

import java.io.File;
import java.util.ArrayList;
import pkg_graphic.PlaylistData;
import pkg_logic.ClipListener;

public class Playlist {
    private ArrayList<PlaylistData> data = new ArrayList();
    private String name;

    public Playlist(String name) {
        this.name = name;
    }

    public String get_name() {
        return this.name;
    }

    public void set_name(String name) {
        this.name = name;
    }

    public int size() {
        return this.data.size();
    }

    public ArrayList<PlaylistData> get_data() {
        return this.data;
    }

    public void add(String path) {
        try {
            File f = new File(path);
            double duration = ClipListener.read_duration(f);
            if (f.isFile()) {
                String name = f.getName();
                PlaylistData p = new PlaylistData(f, this.data.size(), name, duration);
                this.data.add(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void add_file(File f) {
        if (f.isDirectory()) {
            if (f.listFiles() != null) {
                for (File f2 : f.listFiles()) {
                    this.add_file(f2);
                }
            }
        } else {
            double duration = ClipListener.read_duration(f);
            if (duration > 0.0) {
                this.data.add(new PlaylistData(f, this.data.size(), f.getName(), duration));
            }
        }
    }
}

