/*
 * Decompiled with CFR 0.152.
 */
package pkg_logic;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import pkg_graphic.Executable;

public class ExecThread
extends Thread {
    private Executable executable;
    private boolean fullscreen;
    private boolean request_close = false;
    private boolean exit = false;
    private int exit_code = 0;

    public ExecThread(Executable executable, boolean fullscreen) {
        this.executable = executable;
        this.fullscreen = fullscreen;
    }

    public boolean has_request_close() {
        return this.request_close;
    }

    public void request_close() {
        this.request_close = true;
    }

    public boolean has_exit_code() {
        return this.exit;
    }

    @Override
    public void run() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("java", "-jar", this.executable.get_file().getAbsolutePath(), "fullscreen=" + (this.fullscreen ? 1 : 0));
            Process process = processBuilder.start();
            while (!this.request_close) {
                process.waitFor(1L, TimeUnit.SECONDS);
            }
            process.destroy();
            process.waitFor(10L, TimeUnit.SECONDS);
            process.destroyForcibly();
            this.exit_code = process.waitFor();
            this.exit = true;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }
}

